/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel.denizen.properties;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.RunningAnimation;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import meigo.dbettermodel.denizen.objects.BMBoneTag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DBetterModelPlayerTagExtensions {
    public static void register() {
        PlayerTag.tagProcessor.registerTag(ObjectTag.class, "limb", (attribute, object) -> {
            EntityTracker targetTracker;
            Player player = object.getPlayerEntity();
            if (player == null) {
                return null;
            }
            Optional registryOpt = BetterModel.registry((Entity)player);
            if (registryOpt.isEmpty()) {
                return null;
            }
            EntityTrackerRegistry registry = (EntityTrackerRegistry)registryOpt.get();
            Set limbModelNames = BetterModel.limbs().stream().map(ModelRenderer::name).collect(Collectors.toSet());
            if (limbModelNames.isEmpty()) {
                return null;
            }
            List<EntityTracker> playerLimbTrackers = registry.trackers().stream().filter(tracker -> limbModelNames.contains(tracker.name())).toList();
            if (playerLimbTrackers.isEmpty()) {
                return null;
            }
            if (attribute.hasContext(1)) {
                String modelName = attribute.getContext(1);
                targetTracker = playerLimbTrackers.stream().filter(tracker -> tracker.name().equalsIgnoreCase(modelName)).findFirst().orElse(null);
            } else {
                targetTracker = playerLimbTrackers.get(0);
            }
            if (targetTracker == null) {
                return null;
            }
            RunningAnimation runningAnimation = targetTracker.getPipeline().runningAnimation();
            if (runningAnimation != null) {
                MapTag map = new MapTag();
                map.putObject("animation_name", (ObjectTag)new ElementTag(runningAnimation.name()));
                map.putObject("loop_mode", (ObjectTag)new ElementTag(runningAnimation.type().name().toLowerCase()));
                Optional blueprintOpt = targetTracker.renderer().animation(runningAnimation.name());
                blueprintOpt.ifPresent(blueprint -> map.putObject("default_loop_mode", (ObjectTag)new ElementTag(blueprint.loop().name().toLowerCase())));
                return map;
            }
            return null;
        }, new String[0]);
        PlayerTag.tagProcessor.registerTag(MapTag.class, "limb_bones", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The limb_bones tag must have a model name specified.");
                return null;
            }
            String modelName = attribute.getContext(1);
            Player player = object.getPlayerEntity();
            if (player == null) {
                return null;
            }
            if (BetterModel.limbs().stream().noneMatch(limb -> limb.name().equalsIgnoreCase(modelName))) {
                attribute.echoError("Model '" + modelName + "' is not a valid player limb model.");
                return null;
            }
            return BetterModel.registry((Entity)player).flatMap(registry -> Optional.ofNullable(registry.tracker(modelName))).map(tracker -> {
                MapTag map = new MapTag();
                UUID uuid = tracker.registry().uuid();
                for (RenderedBone bone : tracker.bones()) {
                    map.putObject(bone.name().name(), (ObjectTag)new BMBoneTag(uuid, modelName, bone.name().name()));
                }
                return map;
            }).orElse(null);
        }, new String[0]);
    }
}

