/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel.services;

import java.util.List;
import java.util.function.Predicate;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.function.BonePredicate;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BoneController {
    private final EntityTracker tracker;
    private final RenderedBone bone;
    private final Quaternionf customRotation = new Quaternionf();
    private TransformedItemStack currentTransformedItemStack;

    public BoneController(EntityTracker tracker, RenderedBone bone) {
        this.tracker = tracker;
        this.bone = bone;
        this.currentTransformedItemStack = bone.getGroup().getItemStack().copy();
        this.bone.addRotationModifier((Predicate)BonePredicate.TRUE, animationRotation -> animationRotation.mul((Quaternionfc)this.customRotation, new Quaternionf()));
    }

    private void forceUpdate() {
        this.tracker.forceUpdate(true);
    }

    public Location getWorldLocation() {
        Vector3f worldPos = this.bone.worldPosition();
        return new Location(this.tracker.sourceEntity().getWorld(), (double)worldPos.x(), (double)worldPos.y(), (double)worldPos.z());
    }

    public Vector3f getWorldRotationEuler() {
        return this.bone.worldRotation();
    }

    public boolean isVisible() {
        ModelDisplay display = this.bone.getDisplay();
        return display != null && !display.invisible();
    }

    public void setRotation(Quaternionf rotation) {
        this.customRotation.set((Quaternionfc)rotation);
        this.forceUpdate();
    }

    public void setTint(int color) {
        if (this.bone.tint((Predicate)BonePredicate.TRUE, color)) {
            this.forceUpdate();
        }
    }

    public void setVisible(boolean visible) {
        if (this.bone.togglePart((Predicate)BonePredicate.TRUE, visible)) {
            this.forceUpdate();
        }
    }

    public void setVisible(boolean visible, List<Player> players) {
        if (players == null || players.isEmpty()) {
            this.setVisible(visible);
            return;
        }
        ModelDisplay display = this.bone.getDisplay();
        if (display == null) {
            return;
        }
        PacketBundler bundler = this.tracker.getPipeline().createParallelBundler();
        if (visible) {
            display.spawn(true, bundler);
        } else {
            display.remove(bundler);
        }
        for (Player player : players) {
            bundler.send(player);
        }
    }

    public void setViewRange(float range) {
        ModelDisplay display = this.bone.getDisplay();
        if (display != null) {
            display.viewRange(range);
            PacketBundler bundler = this.tracker.getPipeline().createParallelBundler();
            display.sendDirtyEntityData(bundler);
            this.tracker.getPipeline().viewedPlayer().forEach(arg_0 -> ((PacketBundler)bundler).send(arg_0));
        }
    }

    public void setItem(ItemStack itemStack) {
        this.currentTransformedItemStack = new TransformedItemStack(this.currentTransformedItemStack.position(), this.currentTransformedItemStack.offset(), this.currentTransformedItemStack.scale(), itemStack);
        this.updateItemStack();
    }

    public void setOffset(Vector3f localOffset) {
        this.currentTransformedItemStack = new TransformedItemStack(this.currentTransformedItemStack.position(), localOffset, this.currentTransformedItemStack.scale(), this.currentTransformedItemStack.itemStack());
        this.updateItemStack();
    }

    public void setScale(Vector3f scale) {
        this.currentTransformedItemStack = new TransformedItemStack(this.currentTransformedItemStack.position(), this.currentTransformedItemStack.offset(), scale, this.currentTransformedItemStack.itemStack());
        this.updateItemStack();
    }

    public void setInterpolationDuration(int ticks) {
        this.bone.moveDuration((Predicate)BonePredicate.TRUE, ticks);
        this.forceUpdate();
    }

    public void setGlow(boolean glow) {
        if (this.bone.glow((Predicate)BonePredicate.TRUE, glow)) {
            this.forceUpdate();
        }
    }

    public void setGlowColor(int color) {
        if (this.bone.glowColor((Predicate)BonePredicate.TRUE, color)) {
            this.forceUpdate();
        }
    }

    public void setBrightness(int blockLight, int skyLight) {
        if (this.bone.brightness((Predicate)BonePredicate.TRUE, blockLight, skyLight)) {
            this.forceUpdate();
        }
    }

    private void updateItemStack() {
        if (this.bone.itemStack((Predicate)BonePredicate.TRUE, this.currentTransformedItemStack)) {
            this.forceUpdate();
        }
    }

    public void mount(Entity entity) {
        HitBox hitbox = this.bone.getHitBox();
        if (hitbox != null && hitbox.mountController().canMount()) {
            hitbox.mount(entity);
        }
    }

    public void dismount(Entity entity) {
        HitBox hitbox = this.bone.getHitBox();
        if (hitbox != null) {
            hitbox.dismount(entity);
        }
    }

    public void dismountAll() {
        HitBox hitbox = this.bone.getHitBox();
        if (hitbox != null) {
            hitbox.dismountAll();
        }
    }
}

