/*
 * Decompiled with CFR 0.152.
 */
package me.wyzebb.playerviewdistancecontroller;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.wyzebb.playerviewdistancecontroller.UpdateChecker;
import me.wyzebb.playerviewdistancecontroller.commands.CommandManager;
import me.wyzebb.playerviewdistancecontroller.data.LuckPermsDetector;
import me.wyzebb.playerviewdistancecontroller.data.PlayerDataHandler;
import me.wyzebb.playerviewdistancecontroller.events.JoinLeaveEvent;
import me.wyzebb.playerviewdistancecontroller.events.LuckPermsEvents;
import me.wyzebb.playerviewdistancecontroller.events.NotAfkEvents;
import me.wyzebb.playerviewdistancecontroller.lib.folialib.FoliaLib;
import me.wyzebb.playerviewdistancecontroller.metrics.bukkit.Metrics;
import me.wyzebb.playerviewdistancecontroller.metrics.charts.SimplePie;
import me.wyzebb.playerviewdistancecontroller.utility.ClampAmountUtility;
import me.wyzebb.playerviewdistancecontroller.utility.PlaceholderAPIExpansion;
import me.wyzebb.playerviewdistancecontroller.utility.PlayerUtility;
import me.wyzebb.playerviewdistancecontroller.utility.lang.LanguageManager;
import me.wyzebb.playerviewdistancecontroller.utility.lang.MessageProcessor;
import net.luckperms.api.LuckPerms;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayerViewDistanceController
extends JavaPlugin {
    public static PlayerViewDistanceController plugin;
    public static final Map<UUID, Integer> playerAfkMap;
    private final FoliaLib foliaLib = new FoliaLib((Plugin)this);
    private LanguageManager languageManager;
    public static boolean luckPermsDetected;

    public void onEnable() {
        this.getLogger().info("Plugin started!");
        plugin = this;
        int pluginId = 24498;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new SimplePie("used_language", () -> this.getConfig().getString("language", "en_US")));
        luckPermsDetected = LuckPermsDetector.detectLuckPermsWithMsg();
        this.languageManager = new LanguageManager();
        if (luckPermsDetected) {
            LuckPerms luckPerms;
            try {
                luckPerms = (LuckPerms)this.getServer().getServicesManager().load(LuckPerms.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            new LuckPermsEvents(luckPerms).register();
        }
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinLeaveEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NotAfkEvents(), (Plugin)this);
        Objects.requireNonNull(this.getCommand("pvdc")).setExecutor((CommandExecutor)new CommandManager());
        Objects.requireNonNull(this.getCommand("pvdc")).setTabCompleter((TabCompleter)new CommandManager());
        if (this.getConfig().getBoolean("update-checker-enabled")) {
            UpdateChecker updateChecker = new UpdateChecker();
            Thread updateCheck = new Thread((Runnable)updateChecker, "Update Check Thread");
            updateCheck.start();
        }
        if (this.getConfig().getBoolean("afk-chunk-limiter")) {
            this.scheduleAfkChecker();
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            plugin.getLogger().info("Enabling PlaceholderAPI Hook");
            PlaceholderAPIExpansion.registerHook();
        }
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public void updateLastMoved(Player player) {
        UUID playerId = player.getUniqueId();
        if (playerAfkMap.containsKey(playerId) && playerAfkMap.get(playerId) == 0) {
            PlayerDataHandler dataHandler = PlayerUtility.getPlayerDataHandler(player);
            player.setViewDistance(dataHandler.getChunks());
            MessageProcessor.processMessage("messages.afk-return", 2, 0, (CommandSender)player);
        }
        playerAfkMap.put(playerId, (int)System.currentTimeMillis());
    }

    private void scheduleAfkChecker() {
        this.foliaLib.getScheduler().runTimer(this::checkAfk, 0L, 20L);
    }

    private void checkAfk() {
        int currentTime = (int)System.currentTimeMillis();
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID playerId = player.getUniqueId();
            int lastMoved = playerAfkMap.getOrDefault(playerId, currentTime);
            if (currentTime - lastMoved <= this.getConfig().getInt("afkTime") * 1000 || playerAfkMap.get(playerId) == 0 || this.getConfig().getBoolean("spectators-can-afk") && player.getGameMode() == GameMode.SPECTATOR || player.hasPermission("pvdc.bypass-afk")) continue;
            int afkChunks = ClampAmountUtility.clampChunkValue(this.getConfig().getInt("afkChunks"));
            player.setViewDistance(afkChunks);
            playerAfkMap.put(playerId, 0);
            MessageProcessor.processMessage("messages.afk", 2, afkChunks, (CommandSender)player);
        }
    }

    public void onDisable() {
        playerAfkMap.clear();
        LuckPermsEvents.lastUpdates.clear();
        this.getLogger().info("Plugin shut down!");
    }

    static {
        playerAfkMap = new HashMap<UUID, Integer>();
        luckPermsDetected = false;
    }
}

