/*
 * Decompiled with CFR 0.152.
 */
package me.wyzebb.playerviewdistancecontroller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import me.wyzebb.playerviewdistancecontroller.PlayerViewDistanceController;

public class UpdateChecker
implements Runnable {
    private static boolean upToDate = false;
    private static String latest = "";
    private static String pluginVersion = "";

    @Override
    public void run() {
        block11: {
            PlayerViewDistanceController.plugin.getLogger().info("Checking for updates...");
            pluginVersion = PlayerViewDistanceController.plugin.getDescription().getVersion();
            String versionUrl = "https://raw.githubusercontent.com/Wyzebb/PlayerViewDistanceController/refs/heads/master/version.txt";
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(versionUrl).openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                if (connection.getResponseCode() == 200) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                        latest = reader.readLine();
                    }
                    if (pluginVersion.equals(latest)) {
                        PlayerViewDistanceController.plugin.getLogger().info("Plugin is up to date!");
                        upToDate = true;
                    } else {
                        PlayerViewDistanceController.plugin.getLogger().warning("Plugin is out of date! Please update from v" + pluginVersion + " to v" + latest + "!");
                    }
                    break block11;
                }
                PlayerViewDistanceController.plugin.getLogger().warning("Unable to check for updates! HTTP response code: " + connection.getResponseCode());
            }
            catch (IOException exception) {
                PlayerViewDistanceController.plugin.getLogger().warning("Error while checking for updates: " + exception.getMessage());
            }
        }
    }

    public static boolean isUpToDate() {
        return upToDate;
    }

    public static String getLatestVersion() {
        return latest;
    }

    public static String getPluginVersion() {
        return pluginVersion;
    }
}

