/*
 * Decompiled with CFR 0.152.
 */
package me.wyzebb.playerviewdistancecontroller.commands;

import java.util.ArrayList;
import java.util.List;
import me.wyzebb.playerviewdistancecontroller.commands.subcommands.GetCommand;
import me.wyzebb.playerviewdistancecontroller.commands.subcommands.HelpCommand;
import me.wyzebb.playerviewdistancecontroller.commands.subcommands.ReloadCommand;
import me.wyzebb.playerviewdistancecontroller.commands.subcommands.ResetCommand;
import me.wyzebb.playerviewdistancecontroller.commands.subcommands.SetCommand;
import me.wyzebb.playerviewdistancecontroller.commands.subcommands.SetOnlineCommand;
import me.wyzebb.playerviewdistancecontroller.commands.subcommands.SubCommand;
import me.wyzebb.playerviewdistancecontroller.utility.SendHelpMsgUtility;
import me.wyzebb.playerviewdistancecontroller.utility.lang.MessageProcessor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor {
    private final ArrayList<SubCommand> subcommands = new ArrayList();

    public CommandManager() {
        this.subcommands.add(new SetCommand());
        this.subcommands.add(new SetOnlineCommand());
        this.subcommands.add(new GetCommand());
        this.subcommands.add(new ResetCommand());
        this.subcommands.add(new ReloadCommand());
        this.subcommands.add(new HelpCommand());
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        if (args.length > 0) {
            boolean found = false;
            for (int i = 0; i < this.getSubcommands().size(); ++i) {
                if (args[0].equalsIgnoreCase(this.getSubcommands().get(i).getName())) {
                    this.getSubcommands().get(i).performCommand(commandSender, args);
                    found = true;
                    continue;
                }
                if (i != this.getSubcommands().size() - 1 || found) continue;
                MessageProcessor.processMessage("messages.incorrect-args", 1, 0, commandSender);
            }
        } else {
            SendHelpMsgUtility.sendHelpMessage(commandSender);
        }
        return true;
    }

    public ArrayList<SubCommand> getSubcommands() {
        return this.subcommands;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (int i = 0; i < this.getSubcommands().size(); ++i) {
                suggestions.add(this.getSubcommands().get(i).getName());
            }
            return suggestions;
        }
        if (args.length == 2 && args[0].equals("get")) {
            ArrayList<String> playerNames = new ArrayList<String>();
            Player[] players = new Player[Bukkit.getServer().getOnlinePlayers().toArray().length];
            Bukkit.getServer().getOnlinePlayers().toArray(players);
            for (Player player : players) {
                playerNames.add(player.getName());
            }
            return playerNames;
        }
        if (args.length == 3 && args[0].equals("set")) {
            ArrayList<String> playerNames = new ArrayList<String>();
            Player[] players = new Player[Bukkit.getServer().getOnlinePlayers().toArray().length];
            Bukkit.getServer().getOnlinePlayers().toArray(players);
            for (Player player : players) {
                playerNames.add(player.getName());
            }
            return playerNames;
        }
        return new ArrayList<String>(){};
    }
}

