/*
 * Decompiled with CFR 0.152.
 */
package me.wyzebb.playerviewdistancecontroller.data;

import java.io.File;
import me.wyzebb.playerviewdistancecontroller.PlayerViewDistanceController;
import me.wyzebb.playerviewdistancecontroller.data.PlayerDataHandler;
import me.wyzebb.playerviewdistancecontroller.events.JoinLeaveEvent;
import me.wyzebb.playerviewdistancecontroller.utility.ClampAmountUtility;
import me.wyzebb.playerviewdistancecontroller.utility.PlayerUtility;
import me.wyzebb.playerviewdistancecontroller.utility.lang.MessageProcessor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class VdCalculator {
    public static void calcVdSet(Player player, boolean luckPermsEvent) {
        PlayerUtility playerUtility;
        File playerDataFile;
        int amount = ClampAmountUtility.clampChunkValue(PlayerViewDistanceController.plugin.getConfig().getInt("default-distance"));
        int amountOthers = 0;
        boolean bedrockPlayer = player.getName().startsWith(".");
        if (bedrockPlayer) {
            amount = ClampAmountUtility.clampChunkValue(PlayerViewDistanceController.plugin.getConfig().getInt("bedrock-default-distance"));
        }
        if ((playerDataFile = (playerUtility = new PlayerUtility()).getPlayerDataFile(player)).exists()) {
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerDataFile);
            amount = cfg.getInt("chunks");
            amountOthers = cfg.getInt("chunksOthers");
        }
        int luckpermsDistance = JoinLeaveEvent.getLuckpermsDistance(player);
        luckpermsDistance = ClampAmountUtility.clampChunkValue(luckpermsDistance);
        int finalChunks = player.hasPermission("pvdc.bypass-maxdistance") ? amount : Math.min(amount, luckpermsDistance);
        if (amountOthers != 0 && amountOthers > finalChunks) {
            finalChunks = amountOthers;
        }
        if (!luckPermsEvent) {
            PlayerDataHandler dataHandler = PlayerUtility.getPlayerDataHandler(player);
            dataHandler.setChunks(amount);
            dataHandler.setChunksOthers(amountOthers);
            PlayerUtility.setPlayerDataHandler(player, dataHandler);
        }
        player.setViewDistance(finalChunks);
        if (!luckPermsEvent && PlayerViewDistanceController.plugin.getConfig().getBoolean("display-msg-on-join")) {
            if (finalChunks == PlayerViewDistanceController.plugin.getConfig().getInt("max-distance") || finalChunks == PlayerViewDistanceController.plugin.getConfig().getInt("default-distance") && !bedrockPlayer || finalChunks == PlayerViewDistanceController.plugin.getConfig().getInt("bedrock-default-distance") && bedrockPlayer || finalChunks == ClampAmountUtility.getMaxPossible()) {
                if (PlayerViewDistanceController.plugin.getConfig().getBoolean("display-max-join-msg")) {
                    MessageProcessor.processMessage("messages.join", 3, finalChunks, (CommandSender)player);
                }
            } else {
                MessageProcessor.processMessage("messages.join", 3, finalChunks, (CommandSender)player);
            }
        }
        if (luckPermsEvent) {
            MessageProcessor.processMessage("messages.target-view-distance-change", 3, VdCalculator.calcVdGet(player), (CommandSender)player);
        }
    }

    public static void calcVdReset(Player player) {
        PlayerDataHandler dataHandler = new PlayerDataHandler();
        int luckpermsDistance = JoinLeaveEvent.getLuckpermsDistance(player);
        luckpermsDistance = ClampAmountUtility.clampChunkValue(luckpermsDistance);
        dataHandler.setChunks(32);
        dataHandler.setChunksOthers(0);
        player.setViewDistance(luckpermsDistance);
        PlayerUtility.setPlayerDataHandler(player, dataHandler);
    }

    public static int calcVdGet(Player player) {
        int luckpermsDistance = JoinLeaveEvent.getLuckpermsDistance(player);
        luckpermsDistance = ClampAmountUtility.clampChunkValue(luckpermsDistance);
        int finalChunks = Math.min(PlayerUtility.getPlayerDataHandler(player).getChunks(), luckpermsDistance);
        if (PlayerUtility.getPlayerDataHandler(player).getChunksOthers() != 0 && PlayerUtility.getPlayerDataHandler(player).getChunksOthers() > finalChunks) {
            finalChunks = PlayerUtility.getPlayerDataHandler(player).getChunksOthers();
        }
        return finalChunks;
    }
}

