/*
 * Decompiled with CFR 0.152.
 */
package me.wyzebb.playerviewdistancecontroller.events;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.wyzebb.playerviewdistancecontroller.PlayerViewDistanceController;
import me.wyzebb.playerviewdistancecontroller.data.VdCalculator;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeClearEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.PermissionNode;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class LuckPermsEvents {
    private final LuckPerms luckPerms;
    public static Map<UUID, Integer> lastUpdates = new HashMap<UUID, Integer>();

    public LuckPermsEvents(LuckPerms luckPerms) {
        this.luckPerms = luckPerms;
    }

    private void messageIfNotAlready(UUID playerId) {
        OfflinePlayer offlinePlayer;
        int lastMoved;
        int currentTime = (int)System.currentTimeMillis();
        if (currentTime - (lastMoved = lastUpdates.getOrDefault(playerId, 10).intValue()) > 1000 && (offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerId)).isOnline()) {
            VdCalculator.calcVdSet(Bukkit.getPlayer((UUID)playerId), true);
        }
        lastUpdates.put(playerId, currentTime);
    }

    public void register() {
        EventBus eventBus = this.luckPerms.getEventBus();
        eventBus.subscribe((Object)PlayerViewDistanceController.plugin, NodeAddEvent.class, e -> {
            if (e.isUser()) {
                if (e.getNode().getType() == NodeType.PERMISSION && ((PermissionNode)e.getNode()).getPermission().contains("pvdc")) {
                    this.messageIfNotAlready(Bukkit.getPlayerUniqueId((String)e.getTarget().getFriendlyName()));
                }
            } else {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.messageIfNotAlready(player.getUniqueId());
                }
            }
        });
        eventBus.subscribe((Object)PlayerViewDistanceController.plugin, NodeRemoveEvent.class, e -> {
            if (e.isUser()) {
                if (e.getNode().getType() == NodeType.PERMISSION && ((PermissionNode)e.getNode()).getPermission().contains("pvdc")) {
                    this.messageIfNotAlready(Bukkit.getPlayerUniqueId((String)e.getTarget().getFriendlyName()));
                }
            } else {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.messageIfNotAlready(player.getUniqueId());
                }
            }
        });
        eventBus.subscribe((Object)PlayerViewDistanceController.plugin, NodeClearEvent.class, e -> {
            if (e.isUser()) {
                for (int i = 1; i <= e.getDataBefore().size(); ++i) {
                    if (!((Node)e.getDataBefore().stream().toList().get(i - 1)).toString().contains("pvdc")) continue;
                    this.messageIfNotAlready(Bukkit.getPlayerUniqueId((String)e.getTarget().getFriendlyName()));
                }
            } else {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.messageIfNotAlready(player.getUniqueId());
                }
            }
        });
    }
}

