/*
 * Decompiled with CFR 0.152.
 */
package me.wyzebb.playerviewdistancecontroller.utility;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.wyzebb.playerviewdistancecontroller.PlayerViewDistanceController;
import me.wyzebb.playerviewdistancecontroller.data.VdCalculator;
import me.wyzebb.playerviewdistancecontroller.utility.lang.MessageProcessor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPIExpansion
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "pvdc";
    }

    @NotNull
    public String getAuthor() {
        return "Wyzebb";
    }

    @NotNull
    public String getVersion() {
        return "1.0.0";
    }

    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        if (offlinePlayer != null && offlinePlayer.isOnline()) {
            Player player = offlinePlayer.getPlayer();
            if (params.contains("chunks_")) {
                String playerName = params.replace("chunks_", "");
                try {
                    Player target = Bukkit.getPlayer((String)playerName);
                    return String.valueOf(VdCalculator.calcVdGet(target));
                }
                catch (Exception e) {
                    MessageProcessor.processMessage("messages.player-offline", 1, 0, (CommandSender)player);
                    return String.valueOf(VdCalculator.calcVdGet(player));
                }
            }
            if (params.equalsIgnoreCase("chunks")) {
                return String.valueOf(VdCalculator.calcVdGet(player));
            }
            if (params.contains("afk_")) {
                String playerName = params.replace("afk_", "");
                try {
                    Player target = Bukkit.getPlayer((String)playerName);
                    if (PlayerViewDistanceController.playerAfkMap.get(target.getUniqueId()) == 0) {
                        return "AFK";
                    }
                    return "NOT AFK";
                }
                catch (Exception e) {
                    MessageProcessor.processMessage("messages.player-offline", 1, 0, (CommandSender)player);
                }
            } else if (params.equalsIgnoreCase("afk")) {
                if (PlayerViewDistanceController.playerAfkMap.get(player.getUniqueId()) == 0) {
                    return "AFK";
                }
                return "NOT AFK";
            }
        }
        return null;
    }

    public static void registerHook() {
        new PlaceholderAPIExpansion().register();
    }
}

