/*
 * Decompiled with CFR 0.152.
 */
package me.wyzebb.playerviewdistancecontroller.utility.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import me.wyzebb.playerviewdistancecontroller.PlayerViewDistanceController;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private final Map<String, FileConfiguration> languages = new HashMap<String, FileConfiguration>();
    private String defaultLanguage;

    public LanguageManager() {
        this.loadConfig();
        this.copyDefaultLanguages();
        this.loadLanguages();
    }

    private void loadConfig() {
        FileConfiguration config = PlayerViewDistanceController.plugin.getConfig();
        this.defaultLanguage = config.getString("language", "en_US");
    }

    private void copyDefaultLanguages() {
        String[] languages = new String[]{"en_US.yml", "ru_RU.yml", "zh_CN.yml"};
        File languagesFolder = new File(PlayerViewDistanceController.plugin.getDataFolder(), "lang");
        if (!languagesFolder.exists()) {
            languagesFolder.mkdirs();
        }
        for (String langFileName : languages) {
            File langFile = new File(languagesFolder, langFileName);
            if (!langFile.exists()) {
                try (InputStream in = PlayerViewDistanceController.plugin.getResource("lang/" + langFileName);){
                    if (in != null) {
                        Files.copy(in, langFile.toPath(), new CopyOption[0]);
                        PlayerViewDistanceController.plugin.getLogger().info(langFileName + " successfully copied to lang folder.");
                        continue;
                    }
                    PlayerViewDistanceController.plugin.getLogger().warning("Resource file not found: " + langFileName);
                }
                catch (IOException e) {
                    PlayerViewDistanceController.plugin.getLogger().warning("Failed to copy language file: " + langFileName);
                    e.printStackTrace();
                }
                continue;
            }
            PlayerViewDistanceController.plugin.getLogger().info(langFileName + " already exists, skipping copy.");
        }
    }

    private void loadLanguages() {
        File languagesFolder = new File(PlayerViewDistanceController.plugin.getDataFolder(), "lang");
        File[] files = languagesFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".yml")) continue;
                String lang = file.getName().replace(".yml", "");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                this.languages.put(lang, (FileConfiguration)config);
            }
        }
    }

    public FileConfiguration getLanguageFile() {
        return this.languages.getOrDefault(this.defaultLanguage, this.languages.get("en_US"));
    }
}

