/*
 * Decompiled with CFR 0.152.
 */
package com.friskmochi.texelize;

import com.friskmochi.texelize.ImageConfig;
import com.friskmochi.texelize.TexelizeClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "texelize.json");
    public static ImageConfig CONFIG = new ImageConfig();

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                CONFIG = (ImageConfig)GSON.fromJson((Reader)reader, ImageConfig.class);
            }
            catch (IOException e) {
                TexelizeClient.LOGGER.error("Could not load config", (Throwable)e);
            }
        } else {
            ConfigManager.saveConfig();
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)CONFIG, (Appendable)writer);
        }
        catch (IOException e) {
            TexelizeClient.LOGGER.error("Could not save config", (Throwable)e);
        }
    }
}

