/*
 * Decompiled with CFR 0.152.
 */
package com.friskmochi.texelize;

import com.friskmochi.texelize.TexelizeClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ImageManager {
    public static final Path IMAGE_DIR = class_310.method_1551().field_1697.toPath().resolve("texelize");
    private static final List<String> loadedImageNames = new ArrayList<String>();
    private static final Map<String, ImageDimensions> imageOriginalDimensions = new HashMap<String, ImageDimensions>();

    private static String sanitizeFileName(String fileName) {
        return fileName.toLowerCase().replaceAll("[^a-z0-9._-]", "_");
    }

    public static void scanAndRegisterImages() {
        File[] files;
        if (!IMAGE_DIR.toFile().exists()) {
            IMAGE_DIR.toFile().mkdirs();
        }
        if ((files = IMAGE_DIR.toFile().listFiles((dir, name) -> name.toLowerCase().endsWith(".png"))) == null) {
            return;
        }
        loadedImageNames.clear();
        imageOriginalDimensions.clear();
        for (File file : files) {
            try (FileInputStream stream = new FileInputStream(file);){
                class_1011 image = class_1011.method_4309((InputStream)stream);
                class_1043 texture = new class_1043(image);
                String sanitizedName = ImageManager.sanitizeFileName(file.getName());
                class_2960 textureId = class_2960.method_60655((String)"texelize", (String)("textures/dynamic/" + sanitizedName));
                class_310.method_1551().method_1531().method_4616(textureId, (class_1044)texture);
                loadedImageNames.add(file.getName());
                imageOriginalDimensions.put(file.getName(), new ImageDimensions(image.method_4307(), image.method_4323()));
                TexelizeClient.LOGGER.info("Loaded and registered image: " + file.getName() + " (" + image.method_4307() + "x" + image.method_4323() + ") as " + sanitizedName);
            }
            catch (IOException e) {
                TexelizeClient.LOGGER.error("Failed to load image " + file.getName(), (Throwable)e);
            }
        }
    }

    public static List<String> getLoadedImageNames() {
        return loadedImageNames;
    }

    public static ImageDimensions getOriginalDimensions(String imageName) {
        return imageOriginalDimensions.get(imageName);
    }

    public static class_2960 getTextureId(String imageName) {
        if (imageName == null || imageName.isEmpty() || !loadedImageNames.contains(imageName)) {
            return null;
        }
        String sanitizedName = ImageManager.sanitizeFileName(imageName);
        return class_2960.method_60655((String)"texelize", (String)("textures/dynamic/" + sanitizedName));
    }

    public record ImageDimensions(int width, int height) {
    }
}

