/*
 * Decompiled with CFR 0.152.
 */
package com.friskmochi.texelize.config;

import com.friskmochi.texelize.ConfigManager;
import com.friskmochi.texelize.ImageConfig;
import com.friskmochi.texelize.ImageManager;
import com.friskmochi.texelize.gui.InteractiveHudScreen;
import com.friskmochi.texelize.gui.SliderWidget;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class TexelizeConfigScreen
extends class_437 {
    private final class_437 parent;
    private final TempConfig tempConfig;
    private SliderWidget widthSlider;
    private SliderWidget heightSlider;
    private boolean aspectLock = false;
    private class_4185 imageDisplayButton;

    public TexelizeConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"title.texelize.config"));
        this.parent = parent;
        this.tempConfig = new TempConfig(ConfigManager.CONFIG);
    }

    public TempConfig getTempConfig() {
        return this.tempConfig;
    }

    protected void method_25426() {
        ImageManager.scanAndRegisterImages();
        int centerX = this.field_22789 / 2;
        int startY = this.field_22790 / 4 + 20;
        int widgetWidth = 150;
        int widgetHeight = 20;
        int gap = 5;
        class_4185 toggleButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)(this.tempConfig.enabled ? "gui.texelize.enabled" : "gui.texelize.disabled")), button -> {
            this.tempConfig.enabled = !this.tempConfig.enabled;
            button.method_25355((class_2561)class_2561.method_43471((String)(this.tempConfig.enabled ? "gui.texelize.enabled" : "gui.texelize.disabled")));
        }).method_46434(centerX - widgetWidth / 2, startY - (widgetHeight + gap), widgetWidth, widgetHeight).method_46431();
        this.method_37063((class_364)toggleButton);
        int smallButtonWidth = 20;
        int displayWidth = widgetWidth - smallButtonWidth * 2 - gap * 2;
        int displayX = centerX - displayWidth / 2;
        class_4185 prevButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"<"), button -> this.cycleImage(false)).method_46434(displayX - smallButtonWidth - gap, startY, smallButtonWidth, widgetHeight).method_46431();
        this.method_37063((class_364)prevButton);
        this.imageDisplayButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)this.tempConfig.imageName), button -> {}).method_46434(displayX, startY, displayWidth, widgetHeight).method_46431();
        this.method_37063((class_364)this.imageDisplayButton);
        class_4185 nextButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)">"), button -> this.cycleImage(true)).method_46434(displayX + displayWidth + gap, startY, smallButtonWidth, widgetHeight).method_46431();
        this.method_37063((class_364)nextButton);
        this.method_37063((class_364)new SliderWidget(centerX - widgetWidth / 2, startY + (widgetHeight + gap), widgetWidth, widgetHeight, (class_2561)class_2561.method_43471((String)"gui.texelize.x_position"), this.tempConfig.x, val -> {
            this.tempConfig.x = val.floatValue();
        }));
        this.method_37063((class_364)new SliderWidget(centerX - widgetWidth / 2, startY + 2 * (widgetHeight + gap), widgetWidth, widgetHeight, (class_2561)class_2561.method_43471((String)"gui.texelize.y_position"), this.tempConfig.y, val -> {
            this.tempConfig.y = val.floatValue();
        }));
        this.method_37063((class_364)new SliderWidget(centerX - widgetWidth / 2, startY + 6 * (widgetHeight + gap), widgetWidth, widgetHeight, (class_2561)class_2561.method_43471((String)"gui.texelize.opacity"), this.tempConfig.opacity, val -> {
            this.tempConfig.opacity = val.floatValue();
        }));
        this.widthSlider = new SliderWidget(centerX - widgetWidth / 2, startY + 3 * (widgetHeight + gap), widgetWidth, widgetHeight, (class_2561)class_2561.method_43471((String)"gui.texelize.width"), this.tempConfig.width, val -> {
            this.tempConfig.width = val.floatValue();
            if (this.aspectLock) {
                this.updateHeightWithAspectRatio();
            }
        });
        this.method_37063((class_364)this.widthSlider);
        this.heightSlider = new SliderWidget(centerX - widgetWidth / 2, startY + 4 * (widgetHeight + gap), widgetWidth, widgetHeight, (class_2561)class_2561.method_43471((String)"gui.texelize.height"), this.tempConfig.height, val -> {
            this.tempConfig.height = val.floatValue();
            if (this.aspectLock) {
                this.updateWidthWithAspectRatio();
            }
        });
        this.method_37063((class_364)this.heightSlider);
        class_4185 lockButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)(this.aspectLock ? "gui.texelize.lock_ratio.on" : "gui.texelize.lock_ratio.off")), button -> {
            this.aspectLock = !this.aspectLock;
            button.method_25355((class_2561)class_2561.method_43471((String)(this.aspectLock ? "gui.texelize.lock_ratio.on" : "gui.texelize.lock_ratio.off")));
            if (this.aspectLock) {
                this.updateHeightWithAspectRatio();
            }
        }).method_46434(centerX - widgetWidth / 2, startY + 5 * (widgetHeight + gap), widgetWidth, widgetHeight).method_46431();
        this.method_37063((class_364)lockButton);
        class_4185 openFolderButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.texelize.open_folder"), button -> class_156.method_668().method_672(ImageManager.IMAGE_DIR.toFile())).method_46434(centerX - widgetWidth / 2, startY + 7 * (widgetHeight + gap) + 10, widgetWidth, widgetHeight).method_46431();
        this.method_37063((class_364)openFolderButton);
        class_4185 customizeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.texelize.customize"), button -> this.field_22787.method_1507((class_437)new InteractiveHudScreen(this, this.tempConfig))).method_46434(centerX - widgetWidth / 2, startY + 8 * (widgetHeight + gap) + 10, widgetWidth, widgetHeight).method_46431();
        this.method_37063((class_364)customizeButton);
        class_4185 doneButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> this.method_25419()).method_46434(centerX - widgetWidth / 2, startY + 9 * (widgetHeight + gap) + 10, widgetWidth, widgetHeight).method_46431();
        this.method_37063((class_364)doneButton);
    }

    private void cycleImage(boolean forward) {
        List<String> names = ImageManager.getLoadedImageNames();
        if (names.isEmpty()) {
            return;
        }
        int currentIndex = names.indexOf(this.tempConfig.imageName);
        if (currentIndex == -1) {
            currentIndex = 0;
        }
        int nextIndex = forward ? (currentIndex + 1) % names.size() : (currentIndex - 1 + names.size()) % names.size();
        this.tempConfig.imageName = names.get(nextIndex);
        this.imageDisplayButton.method_25355(class_2561.method_30163((String)this.tempConfig.imageName));
        if (this.aspectLock) {
            this.updateHeightWithAspectRatio();
        }
    }

    private void updateHeightWithAspectRatio() {
        ImageManager.ImageDimensions dims = ImageManager.getOriginalDimensions(this.tempConfig.imageName);
        if (dims != null && dims.width() > 0 && this.field_22790 > 0) {
            double ratio = (double)dims.height() / (double)dims.width();
            double newPixelWidth = this.tempConfig.width * (float)this.field_22789;
            double newPixelHeight = newPixelWidth * ratio;
            this.tempConfig.height = (float)(newPixelHeight / (double)this.field_22790);
            this.heightSlider.setValue(this.tempConfig.height);
        }
    }

    private void updateWidthWithAspectRatio() {
        ImageManager.ImageDimensions dims = ImageManager.getOriginalDimensions(this.tempConfig.imageName);
        if (dims != null && dims.height() > 0 && this.field_22789 > 0) {
            double ratio = (double)dims.width() / (double)dims.height();
            double newPixelHeight = this.tempConfig.height * (float)this.field_22790;
            double newPixelWidth = newPixelHeight * ratio;
            this.tempConfig.width = (float)(newPixelWidth / (double)this.field_22789);
            this.widthSlider.setValue(this.tempConfig.width);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, -1);
    }

    public void method_25419() {
        this.saveSettings();
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private void saveSettings() {
        ConfigManager.CONFIG.enabled = this.tempConfig.enabled;
        ConfigManager.CONFIG.imageName = this.tempConfig.imageName;
        ConfigManager.CONFIG.x = this.tempConfig.x;
        ConfigManager.CONFIG.y = this.tempConfig.y;
        ConfigManager.CONFIG.width = this.tempConfig.width;
        ConfigManager.CONFIG.height = this.tempConfig.height;
        ConfigManager.CONFIG.opacity = this.tempConfig.opacity;
        ConfigManager.saveConfig();
    }

    public static class TempConfig {
        public boolean enabled;
        public String imageName;
        public float x;
        public float y;
        public float width;
        public float height;
        public float opacity;

        public TempConfig(ImageConfig source) {
            this.enabled = source.enabled;
            this.imageName = source.imageName;
            this.x = source.x;
            this.y = source.y;
            this.width = source.width;
            this.height = source.height;
            this.opacity = source.opacity;
        }
    }
}

