/*
 * Decompiled with CFR 0.152.
 */
package com.friskmochi.texelize.gui;

import com.friskmochi.texelize.ImageManager;
import com.friskmochi.texelize.config.TexelizeConfigScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class InteractiveHudScreen
extends class_437 {
    private final class_437 parent;
    private final TexelizeConfigScreen.TempConfig tempConfig;
    private InteractionState currentState = InteractionState.NONE;
    private double dragOffsetX;
    private double dragOffsetY;
    private static final int RESIZE_BORDER_SIZE = 8;

    public InteractiveHudScreen(class_437 parent, TexelizeConfigScreen.TempConfig tempConfig) {
        super(class_2561.method_30163((String)""));
        this.parent = parent;
        this.tempConfig = tempConfig;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int imageX = (int)(this.tempConfig.x * (float)this.field_22789);
        int imageY = (int)(this.tempConfig.y * (float)this.field_22790);
        int imageWidth = (int)(this.tempConfig.width * (float)this.field_22789);
        int imageHeight = (int)(this.tempConfig.height * (float)this.field_22790);
        class_2960 textureId = ImageManager.getTextureId(this.tempConfig.imageName);
        if (textureId != null) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            context.method_51422(1.0f, 1.0f, 1.0f, this.tempConfig.opacity);
            context.method_25290(textureId, imageX, imageY, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
        }
        if (this.isMouseOverImage(mouseX, mouseY) || this.currentState != InteractionState.NONE) {
            context.method_49601(imageX - 1, imageY - 1, imageWidth + 2, imageHeight + 2, -2130706433);
        }
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.texelize.interactive_exit_prompt"), this.field_22789 / 2, this.field_22790 / 2, -1);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isMouseOnResizeBorder(mouseX, mouseY)) {
                this.currentState = InteractionState.RESIZING;
                return true;
            }
            if (this.isMouseInsideImage(mouseX, mouseY)) {
                this.currentState = InteractionState.DRAGGING;
                int imageX = (int)(this.tempConfig.x * (float)this.field_22789);
                int imageY = (int)(this.tempConfig.y * (float)this.field_22790);
                this.dragOffsetX = mouseX - (double)imageX;
                this.dragOffsetY = mouseY - (double)imageY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.currentState == InteractionState.DRAGGING) {
            double newImageX = mouseX - this.dragOffsetX;
            double newImageY = mouseY - this.dragOffsetY;
            if (this.field_22789 > 0) {
                this.tempConfig.x = (float)(newImageX / (double)this.field_22789);
            }
            if (this.field_22790 > 0) {
                this.tempConfig.y = (float)(newImageY / (double)this.field_22790);
            }
            return true;
        }
        if (this.currentState == InteractionState.RESIZING) {
            int imageX = (int)(this.tempConfig.x * (float)this.field_22789);
            int imageY = (int)(this.tempConfig.y * (float)this.field_22790);
            int newWidth = (int)(mouseX - (double)imageX);
            int newHeight = (int)(mouseY - (double)imageY);
            newWidth = Math.max(16, newWidth);
            newHeight = Math.max(16, newHeight);
            if (this.field_22789 > 0) {
                this.tempConfig.width = (float)newWidth / (float)this.field_22789;
            }
            if (this.field_22790 > 0) {
                this.tempConfig.height = (float)newHeight / (float)this.field_22790;
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.currentState = InteractionState.NONE;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private boolean isMouseInsideImage(double mouseX, double mouseY) {
        int imageX = (int)(this.tempConfig.x * (float)this.field_22789);
        int imageY = (int)(this.tempConfig.y * (float)this.field_22790);
        int imageWidth = (int)(this.tempConfig.width * (float)this.field_22789);
        int imageHeight = (int)(this.tempConfig.height * (float)this.field_22790);
        return mouseX >= (double)imageX && mouseX <= (double)(imageX + imageWidth) && mouseY >= (double)imageY && mouseY <= (double)(imageY + imageHeight);
    }

    private boolean isMouseOnResizeBorder(double mouseX, double mouseY) {
        int x = (int)(this.tempConfig.x * (float)this.field_22789);
        int y = (int)(this.tempConfig.y * (float)this.field_22790);
        int width = (int)(this.tempConfig.width * (float)this.field_22789);
        int height = (int)(this.tempConfig.height * (float)this.field_22790);
        return mouseX >= (double)(x + width - 8) && mouseX <= (double)(x + width + 8) && mouseY >= (double)(y + height - 8) && mouseY <= (double)(y + height + 8);
    }

    private boolean isMouseOverImage(double mouseX, double mouseY) {
        int x = (int)(this.tempConfig.x * (float)this.field_22789) - 8;
        int y = (int)(this.tempConfig.y * (float)this.field_22790) - 8;
        int width = (int)(this.tempConfig.width * (float)this.field_22789) + 16;
        int height = (int)(this.tempConfig.height * (float)this.field_22790) + 16;
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    public boolean method_25421() {
        return false;
    }

    private static enum InteractionState {
        NONE,
        DRAGGING,
        RESIZING;

    }
}

