/*
 * Decompiled with CFR 0.152.
 */
package it.digifox03.reselect.lang.functions;

import it.digifox03.reselect.lang.core.ConstExpr;
import it.digifox03.reselect.lang.core.Expression;
import it.digifox03.reselect.lang.core.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lit/digifox03/reselect/lang/functions/IfFunction;", "Lit/digifox03/reselect/lang/core/Function;", "()V", "function", "Lkotlin/Pair;", "", "getFunction", "()Lkotlin/Pair;", "make", "Lit/digifox03/reselect/lang/core/Expression;", "expr", "", "IfExpression", "reselect"})
public final class IfFunction
implements Function {
    @NotNull
    public static final IfFunction INSTANCE = new IfFunction();
    @NotNull
    private static final Pair<String, IfFunction> function = TuplesKt.to((Object)"if", (Object)INSTANCE);

    private IfFunction() {
    }

    @NotNull
    public final Pair<String, IfFunction> getFunction() {
        return function;
    }

    @Override
    @NotNull
    public Expression make(@NotNull List<? extends Expression> expr) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Expression cond = expr.get(0);
        Expression bt = expr.get(1);
        Expression be = expr.get(2);
        if (cond instanceof ConstExpr) {
            return (Boolean)cond.value() != false ? bt : be;
        }
        if (!Intrinsics.areEqual((Object)bt.getType(), (Object)be.getType())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new IfExpression(cond, bt, be);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lit/digifox03/reselect/lang/functions/IfFunction$IfExpression;", "Lit/digifox03/reselect/lang/core/Expression;", "cond", "bt", "be", "(Lit/digifox03/reselect/lang/core/Expression;Lit/digifox03/reselect/lang/core/Expression;Lit/digifox03/reselect/lang/core/Expression;)V", "getBe", "()Lit/digifox03/reselect/lang/core/Expression;", "getBt", "getCond", "type", "", "getType", "()Ljava/lang/String;", "value", "", "reselect"})
    private static final class IfExpression
    implements Expression {
        @NotNull
        private final Expression cond;
        @NotNull
        private final Expression bt;
        @NotNull
        private final Expression be;
        @NotNull
        private final String type;

        public IfExpression(@NotNull Expression cond, @NotNull Expression bt, @NotNull Expression be) {
            Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
            Intrinsics.checkNotNullParameter((Object)bt, (String)"bt");
            Intrinsics.checkNotNullParameter((Object)be, (String)"be");
            this.cond = cond;
            this.bt = bt;
            this.be = be;
            this.type = this.bt.getType();
        }

        @NotNull
        public final Expression getCond() {
            return this.cond;
        }

        @NotNull
        public final Expression getBt() {
            return this.bt;
        }

        @NotNull
        public final Expression getBe() {
            return this.be;
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @NotNull
        public Object value() {
            return (Boolean)this.cond.value() != false ? this.bt.value() : this.be.value();
        }
    }
}

