/*
 * Decompiled with CFR 0.152.
 */
package it.digifox03.reselect.lang.functions;

import it.digifox03.reselect.lang.core.ConstExpr;
import it.digifox03.reselect.lang.core.Expression;
import it.digifox03.reselect.lang.core.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lit/digifox03/reselect/lang/functions/MatchesFunction;", "Lit/digifox03/reselect/lang/core/Function;", "()V", "function", "Lkotlin/Pair;", "", "getFunction", "()Lkotlin/Pair;", "make", "Lit/digifox03/reselect/lang/core/Expression;", "expr", "", "MatchesExpression", "reselect"})
public final class MatchesFunction
implements Function {
    @NotNull
    public static final MatchesFunction INSTANCE = new MatchesFunction();
    @NotNull
    private static final Pair<String, MatchesFunction> function = TuplesKt.to((Object)"matches", (Object)INSTANCE);

    private MatchesFunction() {
    }

    @NotNull
    public final Pair<String, MatchesFunction> getFunction() {
        return function;
    }

    @Override
    @NotNull
    public Expression make(@NotNull List<? extends Expression> expr) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Expression str = expr.get(0);
        Expression reg = expr.get(1);
        if (!(reg instanceof ConstExpr)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual((Object)str.getType(), (Object)"string")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Regex regex = new Regex((String)reg.value());
        if (str instanceof ConstExpr) {
            boolean res = regex.matches((CharSequence)((String)str.value()));
            return new ConstExpr("boolean", res);
        }
        return new MatchesExpression(str, regex);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lit/digifox03/reselect/lang/functions/MatchesFunction$MatchesExpression;", "Lit/digifox03/reselect/lang/core/Expression;", "str", "regex", "Lkotlin/text/Regex;", "(Lit/digifox03/reselect/lang/core/Expression;Lkotlin/text/Regex;)V", "getRegex", "()Lkotlin/text/Regex;", "getStr", "()Lit/digifox03/reselect/lang/core/Expression;", "type", "", "getType", "()Ljava/lang/String;", "value", "", "()Ljava/lang/Boolean;", "reselect"})
    private static final class MatchesExpression
    implements Expression {
        @NotNull
        private final Expression str;
        @NotNull
        private final Regex regex;
        @NotNull
        private final String type;

        public MatchesExpression(@NotNull Expression str, @NotNull Regex regex) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            this.str = str;
            this.regex = regex;
            this.type = "boolean";
        }

        @NotNull
        public final Expression getStr() {
            return this.str;
        }

        @NotNull
        public final Regex getRegex() {
            return this.regex;
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @NotNull
        public Boolean value() {
            return this.regex.matches((CharSequence)((String)this.str.value()));
        }
    }
}

