/*
 * Decompiled with CFR 0.152.
 */
package it.digifox03.reselect.lang.functions;

import it.digifox03.reselect.lang.core.ConstExpr;
import it.digifox03.reselect.lang.core.Expression;
import it.digifox03.reselect.lang.core.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lit/digifox03/reselect/lang/functions/OrFunction;", "Lit/digifox03/reselect/lang/core/Function;", "()V", "function", "Lkotlin/Pair;", "", "getFunction", "()Lkotlin/Pair;", "make", "Lit/digifox03/reselect/lang/core/Expression;", "expr", "", "OrExpression", "reselect"})
public final class OrFunction
implements Function {
    @NotNull
    public static final OrFunction INSTANCE = new OrFunction();
    @NotNull
    private static final Pair<String, OrFunction> function = TuplesKt.to((Object)"or", (Object)INSTANCE);

    private OrFunction() {
    }

    @NotNull
    public final Pair<String, OrFunction> getFunction() {
        return function;
    }

    @Override
    @NotNull
    public Expression make(@NotNull List<? extends Expression> expr) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Expression a = expr.get(0);
        Expression b = expr.get(1);
        if (a instanceof ConstExpr && b instanceof ConstExpr) {
            return new ConstExpr("boolean", (Boolean)a.value() != false || (Boolean)b.value() != false);
        }
        return new OrExpression(a, b);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lit/digifox03/reselect/lang/functions/OrFunction$OrExpression;", "Lit/digifox03/reselect/lang/core/Expression;", "a", "b", "(Lit/digifox03/reselect/lang/core/Expression;Lit/digifox03/reselect/lang/core/Expression;)V", "getA", "()Lit/digifox03/reselect/lang/core/Expression;", "getB", "type", "", "getType", "()Ljava/lang/String;", "value", "", "reselect"})
    private static final class OrExpression
    implements Expression {
        @NotNull
        private final Expression a;
        @NotNull
        private final Expression b;
        @NotNull
        private final String type;

        public OrExpression(@NotNull Expression a, @NotNull Expression b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.a = a;
            this.b = b;
            this.type = "boolean";
        }

        @NotNull
        public final Expression getA() {
            return this.a;
        }

        @NotNull
        public final Expression getB() {
            return this.b;
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @NotNull
        public Object value() {
            return (Boolean)this.a.value() != false || (Boolean)this.b.value() != false;
        }
    }
}

