/*
 * Decompiled with CFR 0.152.
 */
package it.digifox03.reselect.lang.functions;

import it.digifox03.reselect.lang.core.ConstExpr;
import it.digifox03.reselect.lang.core.Expression;
import it.digifox03.reselect.lang.core.Function;
import it.digifox03.reselect.lang.typeclasses.RandomTC;
import it.digifox03.reselect.lang.typeclasses.SeedableTC;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lit/digifox03/reselect/lang/functions/RandFunction;", "Lit/digifox03/reselect/lang/core/Function;", "()V", "function", "Lkotlin/Pair;", "", "getFunction", "()Lkotlin/Pair;", "make", "Lit/digifox03/reselect/lang/core/Expression;", "expr", "", "RandExpression", "reselect"})
public final class RandFunction
implements Function {
    @NotNull
    public static final RandFunction INSTANCE = new RandFunction();
    @NotNull
    private static final Pair<String, RandFunction> function = TuplesKt.to((Object)"rand", (Object)INSTANCE);

    private RandFunction() {
    }

    @NotNull
    public final Pair<String, RandFunction> getFunction() {
        return function;
    }

    @Override
    @NotNull
    public Expression make(@NotNull List<? extends Expression> expr) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Expression seed2 = expr.get(0);
        Expression min = expr.get(1);
        Expression max = expr.get(2);
        if (!Intrinsics.areEqual((Object)min.getType(), (Object)max.getType())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Expression seedValue = SeedableTC.Companion.getSeed().make(CollectionsKt.listOf((Object)seed2));
        RandomTC<Object> randomTC = RandomTC.Companion.getReg().getInstance(min.getType());
        if (randomTC == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        RandomTC<Object> rtc = randomTC;
        if (seedValue instanceof ConstExpr && min instanceof ConstExpr && max instanceof ConstExpr) {
            Random rand = RandomKt.Random((long)((Long)seed2.value()));
            return new ConstExpr(min.getType(), rtc.rand(rand, min.value(), max.value()));
        }
        return new RandExpression(rtc, seedValue, min, max);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0004H\u0016R\u0011\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lit/digifox03/reselect/lang/functions/RandFunction$RandExpression;", "Lit/digifox03/reselect/lang/core/Expression;", "rtc", "Lit/digifox03/reselect/lang/typeclasses/RandomTC;", "", "seed", "min", "max", "(Lit/digifox03/reselect/lang/typeclasses/RandomTC;Lit/digifox03/reselect/lang/core/Expression;Lit/digifox03/reselect/lang/core/Expression;Lit/digifox03/reselect/lang/core/Expression;)V", "getMax", "()Lit/digifox03/reselect/lang/core/Expression;", "getMin", "getRtc", "()Lit/digifox03/reselect/lang/typeclasses/RandomTC;", "getSeed", "type", "", "getType", "()Ljava/lang/String;", "value", "reselect"})
    private static final class RandExpression
    implements Expression {
        @NotNull
        private final RandomTC<Object> rtc;
        @NotNull
        private final Expression seed;
        @NotNull
        private final Expression min;
        @NotNull
        private final Expression max;
        @NotNull
        private final String type;

        public RandExpression(@NotNull RandomTC<Object> rtc, @NotNull Expression seed2, @NotNull Expression min, @NotNull Expression max) {
            Intrinsics.checkNotNullParameter(rtc, (String)"rtc");
            Intrinsics.checkNotNullParameter((Object)seed2, (String)"seed");
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            this.rtc = rtc;
            this.seed = seed2;
            this.min = min;
            this.max = max;
            this.type = "integer";
        }

        @NotNull
        public final RandomTC<Object> getRtc() {
            return this.rtc;
        }

        @NotNull
        public final Expression getSeed() {
            return this.seed;
        }

        @NotNull
        public final Expression getMin() {
            return this.min;
        }

        @NotNull
        public final Expression getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @NotNull
        public Object value() {
            Random rand = RandomKt.Random((long)((Long)this.seed.value()));
            return this.rtc.rand(rand, this.min.value(), this.max.value());
        }
    }
}

