/*
 * Decompiled with CFR 0.152.
 */
package com.crepsman.ultimate_furnace;

import com.crepsman.ultimate_furnace.blocks.entity.UltimateFurnaceBlockEntity;
import com.crepsman.ultimate_furnace.registry.ModBlockEntities;
import com.crepsman.ultimate_furnace.registry.ModBlocks;
import com.crepsman.ultimate_furnace.util.FurnaceConfig;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UltimateFurnaceMod
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ultimate Furnace");
    public static final String MOD_ID = "ultimate_furnace";

    public void onInitialize() {
        LOGGER.info("Initializing Ultimate Furnace!");
        FurnaceConfig.load();
        ModBlocks.registerModBlocks();
        ModBlockEntities.registerModBlockEntities();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder reload = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(src -> src.method_9259(4))).executes(ctx -> {
                FurnaceConfig.reload();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.reload.success"), true);
                return 1;
            });
            LiteralArgumentBuilder info = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(src -> src.method_9259(FurnaceConfig.getInfoPermissionLevel()))).then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).executes(context -> {
                class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"position");
                class_2248 block = ((class_2168)context.getSource()).method_9225().method_8320(pos).method_26204();
                if (block == ModBlocks.ULTIMATE_FURNACE) {
                    UltimateFurnaceBlockEntity entity = ((class_2168)context.getSource()).method_9225().method_35230(pos, ModBlockEntities.ULTIMATE_FURNACE_BLOCK_ENTITY).orElse(null);
                    if (entity != null) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.ultimate_furnace.info", (Object[])new Object[]{entity.getFurnaceLevel(), entity.getSmeltCount(), entity.getStoredPower(), UltimateFurnaceBlockEntity.getMaxStoredPower(entity.getFurnaceLevel()), FurnaceConfig.getItemsPerLevel(), FurnaceConfig.getCookTimeForLevel(entity.getFurnaceLevel()), FurnaceConfig.getPowerGainRateForLevel(entity.getFurnaceLevel())}), false);
                    } else {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.fail"), false);
                    }
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.fail"), false);
                }
                return 1;
            }));
            LiteralArgumentBuilder get = (LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).executes(context -> {
                class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"position");
                class_2248 block = ((class_2168)context.getSource()).method_9225().method_8320(pos).method_26204();
                if (block == ModBlocks.ULTIMATE_FURNACE) {
                    UltimateFurnaceBlockEntity entity = ((class_2168)context.getSource()).method_9225().method_35230(pos, ModBlockEntities.ULTIMATE_FURNACE_BLOCK_ENTITY).orElse(null);
                    if (entity != null) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.ultimate_furnace.get", (Object[])new Object[]{entity.getFurnaceLevel(), entity.getSmeltCount(), entity.getStoredPower()}), false);
                    } else {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.fail"), false);
                    }
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.fail"), false);
                }
                return 1;
            }));
            LiteralArgumentBuilder set = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(src -> src.method_9259(4))).then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)FurnaceConfig.getMaxLevel())).then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).executes(context -> {
                int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
                class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"position");
                class_2248 block = ((class_2168)context.getSource()).method_9225().method_8320(pos).method_26204();
                if (block == ModBlocks.ULTIMATE_FURNACE) {
                    UltimateFurnaceBlockEntity entity = ((class_2168)context.getSource()).method_9225().method_35230(pos, ModBlockEntities.ULTIMATE_FURNACE_BLOCK_ENTITY).orElse(null);
                    if (entity != null) {
                        entity.setLevel(level);
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.ultimate_furnace.set.level", (Object[])new Object[]{entity.getFurnaceLevel()}), true);
                    } else {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.fail"), false);
                    }
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.fail"), false);
                }
                return 1;
            }))))).then(class_2170.method_9247((String)"smeltcount").then(class_2170.method_9244((String)"smeltcount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)15000)).then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).executes(context -> {
                int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"smeltcount");
                class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"position");
                class_2248 block = ((class_2168)context.getSource()).method_9225().method_8320(pos).method_26204();
                if (block == ModBlocks.ULTIMATE_FURNACE) {
                    UltimateFurnaceBlockEntity entity = ((class_2168)context.getSource()).method_9225().method_35230(pos, ModBlockEntities.ULTIMATE_FURNACE_BLOCK_ENTITY).orElse(null);
                    if (entity != null) {
                        entity.setSmeltCount(count);
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.ultimate_furnace.set.count", (Object[])new Object[]{entity.getSmeltCount()}), true);
                    } else {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.fail"), false);
                    }
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.fail"), false);
                }
                return 1;
            }))))).then(class_2170.method_9247((String)"storepower").then(class_2170.method_9244((String)"storedPower", (ArgumentType)IntegerArgumentType.integer((int)0, (int)18000)).then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).executes(context -> {
                int power = IntegerArgumentType.getInteger((CommandContext)context, (String)"storedPower");
                class_2338 pos = class_2262.method_48299((CommandContext)context, (String)"position");
                class_2248 block = ((class_2168)context.getSource()).method_9225().method_8320(pos).method_26204();
                if (block == ModBlocks.ULTIMATE_FURNACE) {
                    UltimateFurnaceBlockEntity entity = ((class_2168)context.getSource()).method_9225().method_35230(pos, ModBlockEntities.ULTIMATE_FURNACE_BLOCK_ENTITY).orElse(null);
                    if (entity != null) {
                        entity.setStoredPower(power);
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.ultimate_furnace.set.power", (Object[])new Object[]{entity.getStoredPower()}), true);
                    } else {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.fail"), false);
                    }
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.ultimate_furnace.fail"), false);
                }
                return 1;
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ultimatefurnace").then((ArgumentBuilder)reload)).then((ArgumentBuilder)info)).then((ArgumentBuilder)get)).then((ArgumentBuilder)set));
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(UltimateFurnaceMod::addItemsToFunctionalItemGroup);
    }

    private static void addItemsToFunctionalItemGroup(FabricItemGroupEntries entries) {
        entries.method_45421((class_1935)ModBlocks.ULTIMATE_FURNACE);
        entries.method_45421((class_1935)ModBlocks.COPPER_PLATE);
    }
}

