/*
 * Decompiled with CFR 0.152.
 */
package com.crepsman.ultimate_furnace;

import com.crepsman.ultimate_furnace.blocks.entity.UltimateFurnaceBlockEntity;
import com.crepsman.ultimate_furnace.registry.ModBlocks;
import com.crepsman.ultimate_furnace.registry.ModScreenHandlers;
import com.crepsman.ultimate_furnace.screen.UltimateFurnaceScreen;
import com.crepsman.ultimate_furnace.util.ClientConfig;
import com.crepsman.ultimate_furnace.util.FurnaceConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3929;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class UltimateFurnaceModClient
implements ClientModInitializer {
    public void onInitializeClient() {
        class_3929.method_17542(ModScreenHandlers.ULTIMATE_FURNACE_SCREEN_HANDLER, UltimateFurnaceScreen::new);
        ClientConfig.load();
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            class_9279 data;
            if (stack.method_7909() == ModBlocks.ULTIMATE_FURNACE.method_8389() && (data = (class_9279)stack.method_57824(class_9334.field_49628)) != null) {
                class_2487 tag = data.method_57463();
                int level = tag.method_10550("Level");
                int smelts = tag.method_10550("SmeltCount");
                int stored = tag.method_10550("StoredPower");
                int maxStored = UltimateFurnaceBlockEntity.getMaxStoredPower(level);
                lines.add(class_2561.method_43469((String)"tooltip.ultimate_furnace.level", (Object[])new Object[]{level}).method_27692(class_124.field_1080));
                int itemsPerLevel = FurnaceConfig.getItemsPerLevel();
                int threshold = Math.max(1, itemsPerLevel * Math.max(1, level));
                lines.add(class_2561.method_43469((String)"tooltip.ultimate_furnace.smelted", (Object[])new Object[]{smelts}).method_10852((class_2561)class_2561.method_43470((String)" / ")).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(threshold))).method_27692(class_124.field_1063));
                lines.add(class_2561.method_43469((String)"tooltip.ultimate_furnace.power", (Object[])new Object[]{stored, maxStored}).method_27692(class_124.field_1065));
                if (maxStored > 0) {
                    boolean unicode = ClientConfig.useUnicodeBar();
                    class_124 color = UltimateFurnaceModClient.safeColor(ClientConfig.barColor());
                    int barLen = 20;
                    double pct = Math.min(1.0, (double)stored / (double)maxStored);
                    int filled = (int)Math.round((double)barLen * pct);
                    StringBuilder bar = new StringBuilder();
                    char filledChar = unicode ? (char)'\u2588' : (char)'|';
                    char emptyChar = unicode ? (char)'\u2591' : (char)'.';
                    for (int i = 0; i < barLen; ++i) {
                        bar.append(i < filled ? filledChar : emptyChar);
                    }
                    lines.add(class_2561.method_43470((String)bar.toString()).method_27692(color));
                }
            }
        });
    }

    private static class_124 safeColor(String name) {
        try {
            return class_124.valueOf((String)name.toUpperCase());
        }
        catch (Exception e) {
            return class_124.field_1077;
        }
    }
}

