/*
 * Decompiled with CFR 0.152.
 */
package com.crepsman.ultimate_furnace.blocks.entity;

import com.crepsman.ultimate_furnace.blocks.UltimateFurnaceBlock;
import com.crepsman.ultimate_furnace.registry.ModBlockEntities;
import com.crepsman.ultimate_furnace.registry.ModScreenHandlers;
import com.crepsman.ultimate_furnace.screen.UltimateFurnaceScreenHandler;
import com.crepsman.ultimate_furnace.util.FurnaceConfig;
import com.crepsman.ultimate_furnace.util.ModProperties;
import java.util.Optional;
import net.minecraft.class_10290;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3861;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5421;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;

public class UltimateFurnaceBlockEntity
extends class_2609
implements class_1278 {
    private int smeltCount = 0;
    private int level = 1;
    private int burnTime;
    private int storedPower = 0;
    private int cookTime;
    private int cookTimeTotal;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return UltimateFurnaceBlockEntity.this.smeltCount;
                }
                case 1: {
                    return UltimateFurnaceBlockEntity.this.level;
                }
                case 2: {
                    return UltimateFurnaceBlockEntity.this.burnTime;
                }
                case 3: {
                    return UltimateFurnaceBlockEntity.this.storedPower;
                }
                case 4: {
                    return UltimateFurnaceBlockEntity.this.cookTime;
                }
                case 5: {
                    return UltimateFurnaceBlockEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    UltimateFurnaceBlockEntity.this.smeltCount = value;
                    break;
                }
                case 1: {
                    UltimateFurnaceBlockEntity.this.level = value;
                    break;
                }
                case 2: {
                    UltimateFurnaceBlockEntity.this.burnTime = value;
                    break;
                }
                case 3: {
                    UltimateFurnaceBlockEntity.this.storedPower = value;
                    break;
                }
                case 4: {
                    UltimateFurnaceBlockEntity.this.cookTime = value;
                    break;
                }
                case 5: {
                    UltimateFurnaceBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int method_17389() {
            return 6;
        }
    };

    public UltimateFurnaceBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.ULTIMATE_FURNACE_BLOCK_ENTITY, pos, state, class_3956.field_17546);
        if (this.field_11863 != null) {
            boolean hasDirectSkylight;
            boolean isDay = this.field_11863.method_8532() % 24000L < 12000L;
            boolean bl = hasDirectSkylight = this.field_11863.method_8314(class_1944.field_9284, pos.method_10084()) > 0;
            if (!((Boolean)state.method_11654((class_2769)ModProperties.DAY_MODE)).booleanValue()) {
                this.field_11863.method_8652(pos, (class_2680)state.method_11657((class_2769)ModProperties.DAY_MODE, (Comparable)Boolean.valueOf(isDay && hasDirectSkylight)), 3);
            }
        }
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return slot != 0;
    }

    public int getSmeltCount() {
        return this.smeltCount;
    }

    private void levelUp() {
        int maxLevel = FurnaceConfig.getMaxLevel();
        if (this.level < maxLevel) {
            ++this.level;
            this.smeltCount = 0;
        }
    }

    public int getFurnaceLevel() {
        return this.level;
    }

    public void setSmeltCount(int count) {
        this.smeltCount = count;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isBurning() {
        return this.cookTime > 0 || this.storedPower > 0;
    }

    private void updateDaytimeBurning(class_1937 world, class_2338 pos) {
        class_2680 currentState;
        boolean newDayMode;
        if (world == null) {
            return;
        }
        boolean isDay = world.method_8532() % 24000L < 12000L;
        boolean hasDirectSkylight = world.method_8314(class_1944.field_9284, pos.method_10084()) > 0;
        boolean bl = newDayMode = isDay && hasDirectSkylight;
        if (newDayMode && this.level > 1 && this.storedPower < UltimateFurnaceBlockEntity.getMaxStoredPower(this.level)) {
            int powerGainRate = FurnaceConfig.getPowerGainRateForLevel(this.level);
            this.storedPower = Math.min(this.storedPower + powerGainRate, UltimateFurnaceBlockEntity.getMaxStoredPower(this.level));
        }
        if ((Boolean)(currentState = world.method_8320(pos)).method_11654((class_2769)UltimateFurnaceBlock.DAY_MODE) != newDayMode) {
            world.method_8652(pos, (class_2680)currentState.method_11657((class_2769)UltimateFurnaceBlock.DAY_MODE, (Comparable)Boolean.valueOf(newDayMode)), 3);
        }
    }

    private void smeltItem(class_5455 registryManager, class_8786<class_3861> recipe) {
        if (recipe != null && this.canAcceptRecipeOutput(registryManager, recipe, (class_2371<class_1799>)this.field_11984, this.method_5444())) {
            class_1799 inputStack = (class_1799)this.field_11984.get(0);
            class_1799 outputStack = ((class_3861)recipe.comp_1933()).method_59998(new class_9696(inputStack), (class_7225.class_7874)registryManager);
            class_1799 currentOutputStack = (class_1799)this.field_11984.get(2);
            if (currentOutputStack.method_7960()) {
                this.field_11984.set(2, (Object)outputStack.method_7972());
            } else if (class_1799.method_7984((class_1799)currentOutputStack, (class_1799)outputStack)) {
                currentOutputStack.method_7933(outputStack.method_7947());
            }
            inputStack.method_7934(1);
            ++this.smeltCount;
            this.cookTime = 0;
            this.cookTimeTotal = this.getCookTime();
            if (this.storedPower > 0) {
                --this.storedPower;
            }
        } else {
            this.cookTime = 0;
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, UltimateFurnaceBlockEntity blockEntity) {
        int requiredForNextLevel;
        boolean newDayMode;
        boolean canSmelt;
        if (world == null || pos == null || state == null || blockEntity == null) {
            return;
        }
        blockEntity.updateDaytimeBurning(world, pos);
        boolean isBurning = blockEntity.isBurning();
        boolean stateChanged = false;
        if (isBurning) {
            --blockEntity.burnTime;
        }
        class_1799 inputStack = blockEntity.method_5438(0);
        class_1799 outputStack = blockEntity.method_5438(2);
        boolean hasInput = !inputStack.method_7960();
        boolean bl = canSmelt = outputStack.method_7947() < outputStack.method_7914();
        if (hasInput && canSmelt) {
            Optional<class_8786<class_3861>> recipeEntry = blockEntity.getFirstMatch(new class_9696(inputStack), world);
            if (recipeEntry.isPresent()) {
                class_8786<class_3861> recipe = recipeEntry.get();
                if (recipe != null) {
                    if (blockEntity.cookTime == 0) {
                        blockEntity.cookTimeTotal = blockEntity.getCookTime();
                    }
                    if (blockEntity.cookTime < blockEntity.cookTimeTotal) {
                        ++blockEntity.cookTime;
                    } else {
                        blockEntity.smeltItem(world.method_30349(), recipe);
                        if (blockEntity.level == 1) {
                            blockEntity.burnTime = 200;
                        }
                    }
                } else {
                    blockEntity.cookTime = 0;
                }
            } else {
                blockEntity.cookTime = 0;
            }
        } else {
            blockEntity.cookTime = 0;
            if (!hasInput) {
                blockEntity.burnTime = 0;
            }
        }
        boolean dayMode = (Boolean)state.method_11654((class_2769)ModProperties.DAY_MODE);
        boolean bl2 = newDayMode = world.method_8532() % 24000L < 12000L && world.method_8314(class_1944.field_9284, pos.method_10084()) > 0;
        if (isBurning != blockEntity.isBurning() || dayMode != newDayMode) {
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)class_2363.field_11105, (Comparable)Boolean.valueOf(blockEntity.isBurning()))).method_11657((class_2769)ModProperties.DAY_MODE, (Comparable)Boolean.valueOf(newDayMode)), 3);
            stateChanged = true;
        }
        if (stateChanged) {
            blockEntity.method_5431();
        }
        if (blockEntity.smeltCount >= (requiredForNextLevel = FurnaceConfig.getItemsPerLevel() * blockEntity.getFurnaceLevel())) {
            blockEntity.levelUp();
        }
        if (!dayMode && blockEntity.storedPower > 0) {
            --blockEntity.storedPower;
        }
    }

    private Optional<class_8786<class_3861>> getFirstMatch(class_9696 input, class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_1863 recipeManager = serverWorld.method_64577();
            if (recipeManager == null || input == null) {
                return Optional.empty();
            }
            return recipeManager.method_8132(class_3956.field_17546, (class_9695)input, world);
        }
        return Optional.empty();
    }

    private boolean canAcceptRecipeOutput(class_5455 registryManager, class_8786<class_3861> recipe, class_2371<class_1799> slots, int count) {
        if (!((class_1799)slots.get(0)).method_7960() && recipe != null) {
            class_1799 itemStack = ((class_3861)recipe.comp_1933()).method_59998(new class_9696((class_1799)slots.get(0)), (class_7225.class_7874)registryManager);
            if (itemStack.method_7960()) {
                return false;
            }
            class_1799 itemStack2 = (class_1799)slots.get(2);
            if (itemStack2.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)itemStack2, (class_1799)itemStack)) {
                return false;
            }
            if (itemStack2.method_7947() < count && itemStack2.method_7947() < itemStack2.method_7914()) {
                return true;
            }
            return itemStack2.method_7947() < itemStack.method_7914();
        }
        return false;
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        nbt.method_10569("SmeltCount", this.smeltCount);
        nbt.method_10569("Level", this.level);
        nbt.method_10569("BurnTime", this.burnTime);
        nbt.method_10569("StoredPower", this.storedPower);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        this.smeltCount = nbt.method_10550("SmeltCount");
        this.level = nbt.method_10550("Level");
        this.burnTime = nbt.method_10550("BurnTime");
        this.storedPower = nbt.method_10550("StoredPower");
    }

    private int getCookTime() {
        return FurnaceConfig.getCookTimeForLevel(this.level);
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0, 2};
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.ultimate_furnace.ultimate_furnace");
    }

    public class_1703 method_5465(int syncId, class_1661 playerInventory) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_1863 recipeManager = serverWorld.method_64577();
            class_5321 key = class_10290.field_54650;
            if (key == null) {
                return null;
            }
            class_10290 propertySet = recipeManager.method_64678(key);
            if (propertySet == null) {
                return null;
            }
            return new UltimateFurnaceScreenHandler(ModScreenHandlers.ULTIMATE_FURNACE_SCREEN_HANDLER, (class_3956<? extends class_1874>)class_3956.field_17546, (class_5321<class_10290>)key, class_5421.field_25764, syncId, playerInventory, (class_1263)this, this.propertyDelegate);
        }
        return null;
    }

    public void setStoredPower(int storedPower) {
        this.storedPower = storedPower;
    }

    public int getStoredPower() {
        return this.storedPower;
    }

    public static int getMaxStoredPower(int level) {
        return FurnaceConfig.getMaxStoredPowerForLevel(level);
    }
}

