/*
 * Decompiled with CFR 0.152.
 */
package com.crepsman.ultimate_furnace.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ClientConfig {
    private static final String FILE_NAME = "ultimate_furnace_client.properties";
    private static boolean loaded = false;
    private static boolean useUnicodeBar = true;
    private static String barColor = "DARK_GREEN";

    public static void load() {
        if (loaded || FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path file = configDir.resolve(FILE_NAME);
        Properties props = new Properties();
        if (Files.notExists(file, new LinkOption[0])) {
            useUnicodeBar = true;
            barColor = "DARK_GREEN";
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                writer.write("useUnicodeBar=true\n");
                writer.write("barColor=DARK_GREEN\n");
            }
            catch (IOException iOException) {}
        } else {
            try {
                props.load(Files.newBufferedReader(file));
                useUnicodeBar = Boolean.parseBoolean(props.getProperty("useUnicodeBar", "true"));
                barColor = props.getProperty("barColor", "DARK_GREEN");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        loaded = true;
    }

    public static boolean useUnicodeBar() {
        return useUnicodeBar;
    }

    public static String barColor() {
        return barColor;
    }
}

