/*
 * Decompiled with CFR 0.152.
 */
package com.crepsman.ultimate_furnace.util;

import com.crepsman.ultimate_furnace.UltimateFurnaceMod;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;

public class FurnaceConfig {
    private static final String FILE_NAME = "ultimate_furnace_config.txt";
    private static boolean loaded = false;
    private static final int DEFAULT_MAX_LEVEL = 5;
    private static final int DEFAULT_ITEMS_PER_LEVEL = 3000;
    private static final int DEFAULT_INFO_PERMISSION_LEVEL = 0;
    private static final int[] DEFAULT_COOK_TIMES = new int[]{400, 300, 200, 100, 40};
    private static final int[] DEFAULT_MAX_STORED_POWER = new int[]{0, 6000, 8000, 12000, 18000};
    private static final int[] DEFAULT_POWER_GAIN_RATE = new int[]{0, 1, 2, 4, 5};
    private static int maxLevel = 5;
    private static int itemsPerLevel = 3000;
    private static int infoPermissionLevel = 0;
    private static int[] cookTimes = Arrays.copyOf(DEFAULT_COOK_TIMES, DEFAULT_COOK_TIMES.length);
    private static int[] maxStoredPower = Arrays.copyOf(DEFAULT_MAX_STORED_POWER, DEFAULT_MAX_STORED_POWER.length);
    private static int[] powerGainRate = Arrays.copyOf(DEFAULT_POWER_GAIN_RATE, DEFAULT_POWER_GAIN_RATE.length);

    public static synchronized void reload() {
        UltimateFurnaceMod.LOGGER.info("Reloading Ultimate Furnace config (array format)...");
        loaded = false;
        FurnaceConfig.load();
    }

    public static void load() {
        if (loaded) {
            return;
        }
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path file = configDir.resolve(FILE_NAME);
        maxLevel = 5;
        itemsPerLevel = 3000;
        infoPermissionLevel = 0;
        cookTimes = Arrays.copyOf(DEFAULT_COOK_TIMES, DEFAULT_COOK_TIMES.length);
        maxStoredPower = Arrays.copyOf(DEFAULT_MAX_STORED_POWER, DEFAULT_MAX_STORED_POWER.length);
        powerGainRate = Arrays.copyOf(DEFAULT_POWER_GAIN_RATE, DEFAULT_POWER_GAIN_RATE.length);
        if (Files.notExists(file, new LinkOption[0])) {
            try {
                FurnaceConfig.createDefaultConfig(file);
            }
            catch (IOException e) {
                UltimateFurnaceMod.LOGGER.error("Failed to create default config file", (Throwable)e);
            }
        } else {
            TreeMap<Integer, Integer> legacyCookTimes = new TreeMap<Integer, Integer>();
            TreeMap<Integer, Integer> legacyMaxStored = new TreeMap<Integer, Integer>();
            TreeMap<Integer, Integer> legacyGainRate = new TreeMap<Integer, Integer>();
            try (Stream<String> lines = Files.lines(file);){
                lines.forEach(rawLine -> {
                    String line = rawLine.trim();
                    if (line.isEmpty() || line.startsWith("#")) {
                        return;
                    }
                    int idx = line.indexOf(61);
                    if (idx <= 0) {
                        return;
                    }
                    String key = line.substring(0, idx).trim();
                    String value = line.substring(idx + 1).trim();
                    try {
                        switch (key) {
                            case "max_level": {
                                maxLevel = FurnaceConfig.parsePositive(value, 5);
                                break;
                            }
                            case "items_per_level": {
                                itemsPerLevel = FurnaceConfig.parsePositive(value, 3000);
                                break;
                            }
                            case "info_permission_level": {
                                infoPermissionLevel = FurnaceConfig.clamp(FurnaceConfig.parsePositive(value, 0), 0, 4);
                                break;
                            }
                            case "cook_times": {
                                cookTimes = FurnaceConfig.parseIntArray(value, DEFAULT_COOK_TIMES);
                                break;
                            }
                            case "max_stored_power": {
                                maxStoredPower = FurnaceConfig.parseIntArray(value, DEFAULT_MAX_STORED_POWER);
                                break;
                            }
                            case "power_gain_rate": {
                                powerGainRate = FurnaceConfig.parseIntArray(value, DEFAULT_POWER_GAIN_RATE);
                                break;
                            }
                            default: {
                                int lvl;
                                if (key.startsWith("cook_time_level_")) {
                                    int lvl2 = FurnaceConfig.parsePositive(key.substring("cook_time_level_".length()), -1);
                                    if (lvl2 > 0) {
                                        legacyCookTimes.put(lvl2, FurnaceConfig.parsePositive(value, DEFAULT_COOK_TIMES[0]));
                                    }
                                } else if (key.startsWith("max_stored_power_level_")) {
                                    int lvl3 = FurnaceConfig.parsePositive(key.substring("max_stored_power_level_".length()), -1);
                                    if (lvl3 > 0) {
                                        legacyMaxStored.put(lvl3, FurnaceConfig.parsePositive(value, DEFAULT_MAX_STORED_POWER[0]));
                                    }
                                } else if (key.startsWith("power_gain_rate_level_") && (lvl = FurnaceConfig.parsePositive(key.substring("power_gain_rate_level_".length()), -1)) > 0) {
                                    legacyGainRate.put(lvl, FurnaceConfig.parsePositive(value, DEFAULT_POWER_GAIN_RATE[0]));
                                }
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e) {
                UltimateFurnaceMod.LOGGER.error("Failed reading config file", (Throwable)e);
            }
            if (!FurnaceConfig.fileContainsArrayKey(file, "cook_times") && !legacyCookTimes.isEmpty()) {
                cookTimes = FurnaceConfig.mapToDenseArray(legacyCookTimes, DEFAULT_COOK_TIMES[DEFAULT_COOK_TIMES.length - 1]);
            }
            if (!FurnaceConfig.fileContainsArrayKey(file, "max_stored_power") && !legacyMaxStored.isEmpty()) {
                maxStoredPower = FurnaceConfig.mapToDenseArray(legacyMaxStored, DEFAULT_MAX_STORED_POWER[DEFAULT_MAX_STORED_POWER.length - 1]);
            }
            if (!FurnaceConfig.fileContainsArrayKey(file, "power_gain_rate") && !legacyGainRate.isEmpty()) {
                powerGainRate = FurnaceConfig.mapToDenseArray(legacyGainRate, DEFAULT_POWER_GAIN_RATE[DEFAULT_POWER_GAIN_RATE.length - 1]);
            }
        }
        loaded = true;
        UltimateFurnaceMod.LOGGER.info("Ultimate Furnace config loaded: max_level=" + maxLevel + ", arrays: cook_times=" + Arrays.toString(cookTimes));
    }

    private static boolean fileContainsArrayKey(Path file, String key) {
        boolean bl;
        block8: {
            Stream<String> lines = Files.lines(file);
            try {
                bl = lines.anyMatch(l -> l.trim().startsWith(key + "="));
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            lines.close();
        }
        return bl;
    }

    private static int parsePositive(String s, int def) {
        try {
            int v = Integer.parseInt(s.trim());
            return v > 0 ? v : def;
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private static int clamp(int v, int min, int max) {
        return Math.min(max, Math.max(min, v));
    }

    private static int[] parseIntArray(String value, int[] def) {
        String[] parts = value.split(",");
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (String p : parts) {
            if ((p = p.trim()).isEmpty()) continue;
            try {
                out.add(Integer.parseInt(p));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (out.isEmpty()) {
            return Arrays.copyOf(def, def.length);
        }
        int[] arr = new int[out.size()];
        for (int i = 0; i < out.size(); ++i) {
            arr[i] = (Integer)out.get(i);
        }
        return arr;
    }

    private static int[] mapToDenseArray(Map<Integer, Integer> map, int fallback) {
        int maxKey = map.keySet().stream().max(Integer::compareTo).orElse(1);
        int[] arr = new int[maxKey];
        for (int i = 1; i <= maxKey; ++i) {
            arr[i - 1] = map.getOrDefault(i, fallback);
        }
        return arr;
    }

    private static void createDefaultConfig(Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            writer.write("# Ultimate Furnace Configuration (Array Format)\n");
            writer.write("\n");
            writer.write("# max_level: Highest attainable furnace level. Must be >= 1.\n");
            writer.write("max_level=5\n\n");
            writer.write("# items_per_level: Base smelts needed per level.\n");
            writer.write("#   Threshold to reach next level = current_level * items_per_level\n");
            writer.write("items_per_level=3000\n\n");
            writer.write("# cook_times:\n");
            writer.write("#   20 ticks = 1 second. Lower = faster smelting. Last value reused if level exceeds list length.*\n");
            writer.write("cook_times=" + FurnaceConfig.join(DEFAULT_COOK_TIMES) + "\n\n");
            writer.write("# max_stored_power:\n");
            writer.write("#   Higher values allow more daytime charge to accumulate and be spent at night.*\n");
            writer.write("max_stored_power=" + FurnaceConfig.join(DEFAULT_MAX_STORED_POWER) + "\n\n");
            writer.write("# power_gain_rate:\n");
            writer.write("#   Requires sky access. 20 ticks = 1 second. Last value reused if level exceeds list length.*\n");
            writer.write("power_gain_rate=" + FurnaceConfig.join(DEFAULT_POWER_GAIN_RATE) + "\n\n");
            writer.write("# info_permission_level: Minecraft permission level required for /ultimatefurnace info (0..4).\n");
            writer.write("info_permission_level=0\n\n");
            writer.write("# NOTES:\n");
            writer.write("# - To extend levels beyond max_level, raise max_level AND append additional values to arrays.\n");
            writer.write("# - If arrays are shorter than max_level, the last array value is reused for higher levels.\n");
            writer.write("# - Use /ultimatefurnace reload in-game to apply changes without restarting.\n");
        }
    }

    private static String join(int[] arr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static int getMaxLevel() {
        return maxLevel;
    }

    public static int getItemsPerLevel() {
        return itemsPerLevel;
    }

    public static int getInfoPermissionLevel() {
        return infoPermissionLevel;
    }

    public static int getCookTimeForLevel(int level) {
        if (level <= 0) {
            return cookTimes[0];
        }
        return cookTimes[level - 1 < cookTimes.length ? level - 1 : cookTimes.length - 1];
    }

    public static int getMaxStoredPowerForLevel(int level) {
        if (level <= 0) {
            return maxStoredPower[0];
        }
        return maxStoredPower[level - 1 < maxStoredPower.length ? level - 1 : maxStoredPower.length - 1];
    }

    public static int getPowerGainRateForLevel(int level) {
        if (level <= 0) {
            return powerGainRate[0];
        }
        return powerGainRate[level - 1 < powerGainRate.length ? level - 1 : powerGainRate.length - 1];
    }
}

