/*
 * Decompiled with CFR 0.152.
 */
package me.example.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Config {
    private final JavaPlugin plugin;
    private FileConfiguration config;
    private boolean plantGrowthEnabled;
    private int growthSlowMultiplier;
    private boolean cleanupEnabled;
    private int cleanupInterval;
    private int itemLifetime;
    private List<Material> cleanupItems;
    private boolean pistonSlowEnabled;
    private int pistonSlowChance;

    public Config(JavaPlugin plugin) {
        this.plugin = plugin;
        this.cleanupItems = new ArrayList<Material>();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.plantGrowthEnabled = this.config.getBoolean("plant-growth.enabled", true);
        this.growthSlowMultiplier = this.config.getInt("plant-growth.slow-multiplier", 2);
        this.cleanupEnabled = this.config.getBoolean("cleanup.enabled", true);
        this.cleanupInterval = this.config.getInt("cleanup.interval-seconds", 300);
        this.itemLifetime = this.config.getInt("cleanup.item-lifetime-ticks", 6000);
        this.cleanupItems.clear();
        for (String itemName : this.config.getStringList("cleanup.items")) {
            try {
                Material material = Material.valueOf((String)itemName.toUpperCase());
                this.cleanupItems.add(material);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b: " + itemName);
            }
        }
        this.pistonSlowEnabled = this.config.getBoolean("piston-slow.enabled", true);
        this.pistonSlowChance = this.config.getInt("piston-slow.slow-chance", 30);
    }

    public boolean isPlantGrowthEnabled() {
        return this.plantGrowthEnabled;
    }

    public int getGrowthSlowMultiplier() {
        return this.growthSlowMultiplier;
    }

    public boolean isCleanupEnabled() {
        return this.cleanupEnabled;
    }

    public int getCleanupInterval() {
        return this.cleanupInterval;
    }

    public int getItemLifetime() {
        return this.itemLifetime;
    }

    public List<Material> getCleanupItems() {
        return this.cleanupItems;
    }

    public boolean isPistonSlowEnabled() {
        return this.pistonSlowEnabled;
    }

    public int getPistonSlowChance() {
        return this.pistonSlowChance;
    }
}

