/*
 * Decompiled with CFR 0.152.
 */
package me.example.optimizer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.example.optimizer.Config;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GameOptimizer
extends JavaPlugin
implements Listener {
    private final Random random = new Random();
    private Config config;
    private final Map<Block, Integer> growthAttempts = new HashMap<Block, Integer>();

    public void onEnable() {
        this.config = new Config(this);
        this.config.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.startCleanupTask();
        this.getLogger().info("GameOptimizer \u0432\u043a\u043b\u044e\u0447\u0435\u043d!");
    }

    public void onDisable() {
        this.getLogger().info("GameOptimizer \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d!");
    }

    private void startCleanupTask() {
        new BukkitRunnable(){

            public void run() {
                if (GameOptimizer.this.config.isCleanupEnabled()) {
                    GameOptimizer.this.cleanupWorld();
                }
            }
        }.runTaskTimer((Plugin)this, (long)this.config.getCleanupInterval() * 20L, (long)this.config.getCleanupInterval() * 20L);
    }

    private void cleanupWorld() {
        int removed = 0;
        for (World world : Bukkit.getWorlds()) {
            List entities = world.getEntities();
            for (Entity entity : entities) {
                if (!(entity instanceof Item)) continue;
                Item item = (Item)entity;
                if (!this.config.getCleanupItems().contains(item.getItemStack().getType()) || item.getTicksLived() <= this.config.getItemLifetime()) continue;
                item.remove();
                ++removed;
            }
        }
        this.getLogger().info("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043c\u0438\u0440\u0430: \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + removed + " \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432.");
    }

    @EventHandler
    public void onBlockGrow(BlockGrowEvent event) {
        if (!this.config.isPlantGrowthEnabled()) {
            return;
        }
        Block block = event.getBlock();
        if (block.getBlockData() instanceof Ageable) {
            Ageable ageable = (Ageable)block.getBlockData();
            int attempts = this.growthAttempts.getOrDefault(block, 0) + 1;
            this.growthAttempts.put(block, attempts);
            if (attempts % this.config.getGrowthSlowMultiplier() != 0) {
                event.setCancelled(true);
            } else {
                this.growthAttempts.remove(block);
            }
        }
    }

    @EventHandler
    public void onPistonExtend(final BlockPistonExtendEvent event) {
        if (!this.config.isPistonSlowEnabled()) {
            return;
        }
        if (this.random.nextInt(100) < this.config.getPistonSlowChance()) {
            event.setCancelled(true);
            new BukkitRunnable(){

                public void run() {
                    Block block = event.getBlock();
                    block.getWorld().getBlockAt(block.getLocation()).setBlockData(block.getBlockData());
                }
            }.runTaskLater((Plugin)this, 1L);
        }
    }

    @EventHandler
    public void onPistonRetract(final BlockPistonRetractEvent event) {
        if (!this.config.isPistonSlowEnabled()) {
            return;
        }
        if (this.random.nextInt(100) < this.config.getPistonSlowChance()) {
            event.setCancelled(true);
            new BukkitRunnable(){

                public void run() {
                    Block block = event.getBlock();
                    block.getWorld().getBlockAt(block.getLocation()).setBlockData(block.getBlockData());
                }
            }.runTaskLater((Plugin)this, 1L);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("optimizer")) {
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a76\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: \u00a7f/optimizer reload");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("gameoptimizer.reload")) {
                sender.sendMessage("\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443!");
                return true;
            }
            this.config.loadConfig();
            this.growthAttempts.clear();
            sender.sendMessage("\u00a7a\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!");
            return true;
        }
        sender.sendMessage("\u00a7c\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u00a7f/optimizer reload");
        return true;
    }

    public Config getOptimizerConfig() {
        return this.config;
    }
}

