/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.realmrpgballoons.entity;

import net.mcreator.realmrpgballoons.procedures.TreasureBalloonHitboxSizeProcedure;
import net.mcreator.realmrpgballoons.procedures.TreasureBalloonInteractProcedure;
import net.mcreator.realmrpgballoons.procedures.TreasureBalloonNotPoppedProcedure;
import net.mcreator.realmrpgballoons.procedures.TreasureBalloonUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class TreasureBalloonEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_Rarity = SynchedEntityData.defineId(TreasureBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_FlyDirection = SynchedEntityData.defineId(TreasureBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_BalloonPopped = SynchedEntityData.defineId(TreasureBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_LifeTime = SynchedEntityData.defineId(TreasureBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Blink = SynchedEntityData.defineId(TreasureBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_FallingEffects = SynchedEntityData.defineId(TreasureBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_BreakEffects = SynchedEntityData.defineId(TreasureBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_GotExtraTime = SynchedEntityData.defineId(TreasureBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();

    public TreasureBalloonEntity(EntityType<TreasureBalloonEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Rarity, (Object)0);
        builder.define(DATA_FlyDirection, (Object)0);
        builder.define(DATA_BalloonPopped, (Object)0);
        builder.define(DATA_LifeTime, (Object)6000);
        builder.define(DATA_Blink, (Object)20);
        builder.define(DATA_FallingEffects, (Object)1);
        builder.define(DATA_BreakEffects, (Object)1);
        builder.define(DATA_GotExtraTime, (Object)12000);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.wood.hit"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataRarity", ((Integer)this.entityData.get(DATA_Rarity)).intValue());
        compound.putInt("DataFlyDirection", ((Integer)this.entityData.get(DATA_FlyDirection)).intValue());
        compound.putInt("DataBalloonPopped", ((Integer)this.entityData.get(DATA_BalloonPopped)).intValue());
        compound.putInt("DataLifeTime", ((Integer)this.entityData.get(DATA_LifeTime)).intValue());
        compound.putInt("DataBlink", ((Integer)this.entityData.get(DATA_Blink)).intValue());
        compound.putInt("DataFallingEffects", ((Integer)this.entityData.get(DATA_FallingEffects)).intValue());
        compound.putInt("DataBreakEffects", ((Integer)this.entityData.get(DATA_BreakEffects)).intValue());
        compound.putInt("DataGotExtraTime", ((Integer)this.entityData.get(DATA_GotExtraTime)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataRarity")) {
            this.entityData.set(DATA_Rarity, (Object)compound.getInt("DataRarity"));
        }
        if (compound.contains("DataFlyDirection")) {
            this.entityData.set(DATA_FlyDirection, (Object)compound.getInt("DataFlyDirection"));
        }
        if (compound.contains("DataBalloonPopped")) {
            this.entityData.set(DATA_BalloonPopped, (Object)compound.getInt("DataBalloonPopped"));
        }
        if (compound.contains("DataLifeTime")) {
            this.entityData.set(DATA_LifeTime, (Object)compound.getInt("DataLifeTime"));
        }
        if (compound.contains("DataBlink")) {
            this.entityData.set(DATA_Blink, (Object)compound.getInt("DataBlink"));
        }
        if (compound.contains("DataFallingEffects")) {
            this.entityData.set(DATA_FallingEffects, (Object)compound.getInt("DataFallingEffects"));
        }
        if (compound.contains("DataBreakEffects")) {
            this.entityData.set(DATA_BreakEffects, (Object)compound.getInt("DataBreakEffects"));
        }
        if (compound.contains("DataGotExtraTime")) {
            this.entityData.set(DATA_GotExtraTime, (Object)compound.getInt("DataGotExtraTime"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        TreasureBalloonEntity entity = this;
        Level world = this.level();
        TreasureBalloonInteractProcedure.execute((LevelAccessor)world, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(TreasureBalloonNotPoppedProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        TreasureBalloonUpdateProcedure.execute((LevelAccessor)this.level(), (Entity)this);
        this.refreshDimensions();
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TreasureBalloonEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TreasureBalloonEntity entity = this;
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entityIn) {
    }

    protected void pushEntities() {
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        TreasureBalloonEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)TreasureBalloonHitboxSizeProcedure.execute((Entity)entity));
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 2.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 20.0);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        return builder;
    }
}

