# Execution from sgrave:despawning_management/graves/main

## Remove 1 second from the despawn timer
scoreboard players remove @s[scores={sgrave.no_despawn=0}] sgrave.despawn_time 1

## Tag the marker of the grave
tag @s add sgrave.marker_on_use

## Calculate despawn time from seconds to minutes and hours
scoreboard players operation %grave_despawn_time_h sgrave.dummy = @s sgrave.despawn_time
scoreboard players operation %grave_despawn_time_h sgrave.dummy /= %3600 sgrave.constant_dummy

scoreboard players operation %grave_despawn_time_m sgrave.dummy = @s sgrave.despawn_time
scoreboard players operation %grave_despawn_time_m sgrave.dummy /= %60 sgrave.constant_dummy
scoreboard players operation %grave_despawn_time_m sgrave.dummy %= %60 sgrave.constant_dummy

scoreboard players operation %grave_despawn_time_s sgrave.dummy = @s sgrave.despawn_time
scoreboard players operation %grave_despawn_time_s sgrave.dummy %= %60 sgrave.constant_dummy

## Change the value in the storage as well

### For storage "players[].graves"

#### Cycle through storage "players" and find the one we need
function sgrave:player_management/rotate_data/players_by_stored_id
#### Cycle through storage "players[].graves" and find the one we need
execute store result score %check.grave_id sgrave.dummy run data get entity @s data.sgrave.id
function sgrave:player_management/rotate_data/graves

#### Change value
execute store result storage sgrave players[-1].graves[-1].despawn_time.h int 1 run scoreboard players get %grave_despawn_time_h sgrave.dummy
execute store result storage sgrave players[-1].graves[-1].despawn_time.m int 1 run scoreboard players get %grave_despawn_time_m sgrave.dummy
execute store result storage sgrave players[-1].graves[-1].despawn_time.s int 1 run scoreboard players get %grave_despawn_time_s sgrave.dummy
execute unless score @s sgrave.no_despawn matches 1 run data modify storage sgrave players[-1].graves[-1].despawn_time.infinite set value 0b
execute if score @s sgrave.no_despawn matches 1 run data modify storage sgrave players[-1].graves[-1].despawn_time.infinite set value 1b

#### Cycle back
execute if score %loop_count sgrave.dummy matches 1.. run function sgrave:player_management/rotate_data/graves_reverse

scoreboard players set %loop_count sgrave.dummy 0

### For storage "all_graves"

#### Cycle through storage "all_graves" and find the one we need
execute store result score %check.grave_id sgrave.dummy run data get entity @s data.sgrave.id
function sgrave:player_management/rotate_data/all_graves

#### Change value
execute store result storage sgrave all_graves[-1].despawn_time.h int 1 run scoreboard players get %grave_despawn_time_h sgrave.dummy
execute store result storage sgrave all_graves[-1].despawn_time.m int 1 run scoreboard players get %grave_despawn_time_m sgrave.dummy
execute store result storage sgrave all_graves[-1].despawn_time.s int 1 run scoreboard players get %grave_despawn_time_s sgrave.dummy
execute unless score @s sgrave.no_despawn matches 1 run data modify storage sgrave all_graves[-1].despawn_time.infinite set value 0b
execute if score @s sgrave.no_despawn matches 1 run data modify storage sgrave all_graves[-1].despawn_time.infinite set value 1b

#### Cycle back
execute if score %loop_count sgrave.dummy matches 1.. run function sgrave:player_management/rotate_data/all_graves_reverse

scoreboard players set %loop_count sgrave.dummy 0

## Change the timer in the text display as well
execute positioned ~0.5 ~0.49 ~0.5 if score @s sgrave.no_despawn matches 0 if score %text_type sgrave.config matches 1 run data modify entity @e[tag=sgrave.text_display,limit=1,sort=nearest] text set value [{translate:"sgrave.grave.text_display.normal.info",color:"white",fallback:"%s's grave §c#%s",with:[{nbt: "data.sgrave.owner.name",color:"green",entity:"@e[tag=sgrave.marker_on_use,limit=1,sort=nearest]"},{nbt:"data.sgrave.id",entity:"@e[tag=sgrave.marker_on_use,limit=1,sort=nearest]",color:"gold"}]},"\n",{translate:"sgrave.grave.text_display.normal.time",color:"white",fallback:"%s§ch §f: %s§cm §f: %s§cs",with:[{score:{name: "%grave_despawn_time_h",objective:"sgrave.dummy"},color: "gold"},{score:{name: "%grave_despawn_time_m",objective:"sgrave.dummy"},color: "gold"},{score:{name: "%grave_despawn_time_s",objective:"sgrave.dummy"},color: "gold"}]}]
execute positioned ~0.5 ~0.49 ~0.5 if score @s sgrave.no_despawn matches 0 unless score %text_type sgrave.config matches 1 run data modify entity @e[tag=sgrave.text_display,limit=1,sort=nearest] text set value [{translate:"sgrave.grave.text_display.simplified.info",color:"white",fallback:"%s §c#%s",with:[{nbt: "data.sgrave.owner.name",color:"green",entity:"@e[tag=sgrave.marker_on_use,limit=1,sort=nearest]"},{nbt:"data.sgrave.id",entity:"@e[tag=sgrave.marker_on_use,limit=1,sort=nearest]",color:"gold"}]},"\n",{translate:"sgrave.grave.text_display.simplified.time",color:"white",fallback:"%s : %s : %s",with:[{score:{name: "%grave_despawn_time_h",objective:"sgrave.dummy"},color: "gold"},{score:{name: "%grave_despawn_time_m",objective:"sgrave.dummy"},color: "gold"},{score:{name: "%grave_despawn_time_s",objective:"sgrave.dummy"},color: "gold"}]}]

execute positioned ~0.5 ~0.49 ~0.5 unless score @s sgrave.no_despawn matches 0 if score %text_type sgrave.config matches 1 run data modify entity @e[tag=sgrave.text_display,limit=1,sort=nearest] text set value {translate:"sgrave.grave.text_display.normal.info",color:"white",fallback:"%s's grave §c#%s",with:[{nbt: "data.sgrave.owner.name",color:"green",entity:"@e[tag=sgrave.marker_on_use,limit=1,sort=nearest]"},{nbt:"data.sgrave.id",entity:"@e[tag=sgrave.marker_on_use,limit=1,sort=nearest]",color:"gold"}]}
execute positioned ~0.5 ~0.49 ~0.5 unless score @s sgrave.no_despawn matches 0 unless score %text_type sgrave.config matches 1 run data modify entity @e[tag=sgrave.text_display,limit=1,sort=nearest] text set value {translate:"sgrave.grave.text_display.simplified.info",color:"white",fallback:"%s §c#%s",with:[{nbt: "data.sgrave.owner.name",color:"green",entity:"@e[tag=sgrave.marker_on_use,limit=1,sort=nearest]"},{nbt:"data.sgrave.id",entity:"@e[tag=sgrave.marker_on_use,limit=1,sort=nearest]",color:"gold"}]}

## Remove the unnessecary tag from the marker of the grave
tag @s remove sgrave.marker_on_use

## If despawn timer hits 0, delete the grave
execute as @s[scores={sgrave.despawn_time=-32767..0}] at @s run function sgrave:despawning_management/graves/delete