# Execution from sgrave:on/attack_grave

## Drop all items and experience
function sgrave:drop_items
function sgrave:drop_xp

## Tag the interactor of the grave
execute as @e[type=interaction,limit=1,tag=sgrave.interaction,sort=nearest,nbt={attack:{}}] on attacker run tag @s add sgrave.has_interacted_with_grave

## Remove grave data from storage "players[].graves" and specify it as broken in storage "all_graves"
scoreboard players set %loop_count sgrave.dummy 0

function sgrave:player_management/rotate_data/players_by_stored_id
execute store result score %check.grave_id sgrave.dummy run data get entity @e[tag=sgrave.marker_on_use,limit=1,sort=nearest] data.sgrave.id
function sgrave:player_management/rotate_data/graves
data modify storage sgrave players[-1].graves[-1].to_be_removed set value 1b

function sgrave:player_management/rotate_data/graves_reverse
data remove storage sgrave players[-1].graves[{to_be_removed:1b}]


scoreboard players set %loop_count sgrave.dummy 0

execute store result score %check.grave_id sgrave.dummy run data get entity @s data.sgrave.id
function sgrave:player_management/rotate_data/all_graves
data modify storage sgrave all_graves[-1].broken.status set value "broken"
data modify storage sgrave all_graves[-1].active set value 0b

data modify storage sgrave all_graves[-1].broken.executor.sgrave_id set from storage sgrave players[-1].id
data modify storage sgrave all_graves[-1].broken.executor.uuid set from storage sgrave players[-1].UUID
data modify storage sgrave all_graves[-1].broken.executor.name set from storage sgrave players[-1].name

data modify entity @e[tag=sgrave.marker_on_use,sort=nearest,limit=1] data.sgrave.owner.UUID set from storage sgrave players[-1].UUID
data modify entity @e[tag=sgrave.marker_on_use,sort=nearest,limit=1] data.sgrave.owner.name set from storage sgrave players[-1].name
data modify entity @e[tag=sgrave.marker_on_use,sort=nearest,limit=1] data.sgrave.owner.sgrave_id set from storage sgrave players[-1].id

execute if score %loop_count sgrave.dummy matches 1.. run function sgrave:player_management/rotate_data/all_graves_reverse

scoreboard players set %loop_count sgrave.dummy 0

## Delete the grave
function sgrave:delete_grave

## Un-tag the interactor of the grave (We don't need it anymore)
tag @e[tag=sgrave.has_interacted_with_grave] remove sgrave.has_interacted_with_grave