# Execution from sgrave:push_grave(_no_down)

## Store the position of the grave in integers (which is used for locating the grave)
data modify entity @s data.sgrave.posI set value [I;0,0,0]
execute store result entity @s data.sgrave.posI[0] int 1 run data get entity @s Pos[0]
execute store result entity @s data.sgrave.posI[1] int 1 run data get entity @s Pos[1]
execute store result entity @s data.sgrave.posI[2] int 1 run data get entity @s Pos[2]

## Apply the despawn timer
scoreboard players operation @s sgrave.despawn_time = %grave_despawn_time sgrave.config 
execute if score %grave_no_despawn sgrave.config matches 1 run scoreboard players set @s sgrave.no_despawn 1

## Put the success value (which is unused, for now...)
data modify entity @s data.sgrave.success set value 1b

## Tag the dead player
tag @p[tag=sgrave.dead_player] add sgrave.has_put_grave

## Add grave count to the player and global (this score is unused for the player, for now...)
scoreboard players add @p[tag=sgrave.dead_player] sgrave.grave_count 1
scoreboard players add %global sgrave.grave_count 1

## 
scoreboard players operation %grave_count_2dig sgrave.dummy = %global sgrave.grave_count 
scoreboard players operation %grave_count_2dig sgrave.dummy %= %100 sgrave.constant_dummy

execute if score %grave_count_2dig sgrave.dummy matches 13 run scoreboard players add %global sgrave.grave_count 1

## Assign a grave id
execute store result entity @s data.sgrave.id int 1 run scoreboard players get %global sgrave.grave_count

## Add the grave in the storages "players[].graves" and "all_graves"
function sgrave:player_management/add_grave
execute as @p[tag=sgrave.dead_player] run function sgrave:player_management/rotate_data/players

## Clear items (we don't use /clear to prevent item loss)
execute as @p[tag=sgrave.dead_player] at @s if score %new_item_detection sgrave.config matches 0 run function sgrave:clear_items

## Automatically announce the location of the grave to the player
scoreboard players set @p[tag=sgrave.dead_player] sgrave 1

## Summon the grave model
function sgrave:summon_grave_model

## Un-tag the marker. We don't need it anymore
tag @s remove sgrave.marker_on_use