# Execution from sgrave:grave_info/check_conditions

## Cycle through the "players" storage and set the last grave info viewed which is used for sgrave:grave_info/items
function sgrave:player_management/rotate_data/players
execute store result storage sgrave players[-1].last_grave_id_info_viewed int 1 run scoreboard players get @s sgrave.grave_info

## Get whether the grave is active and not broken
execute store result score %is_active sgrave.dummy run data get storage sgrave all_graves[-1].active

## Tell the player about the informations
tellraw @s {"translate":"sgrave.grave_info.title","fallback":"\nGrave §c#%s Info","with":[{"nbt":"all_graves[-1].id","storage":"sgrave","color": "gold"}]}

execute unless score %grave_info.owner sgrave.config matches 0 run tellraw @s {"translate":"sgrave.grave_info.owner","fallback":"  §bOwner: %s","with":[{"nbt":"all_graves[-1].owner.name","color":"green","storage": "sgrave"}]}

execute unless score %locating sgrave.config matches 0 unless data storage sgrave all_graves[-1].broken{status:"ghost"} run tellraw @s {"translate":"sgrave.grave_info.location","fallback":"  §bLocation: §f[%s§f] in %s","with":[{"nbt":"all_graves[-1].posI[]","separator": "§f, ","color":"gold","storage": "sgrave"},{"nbt":"all_graves[-1].dimension","storage": "sgrave","color": "green"}]}

execute unless score %grave_info.xp sgrave.config matches 0 unless data storage sgrave all_graves[-1].broken{status:"ghost"} run tellraw @s {"translate":"sgrave.grave_info.xp_category","fallback": "  §bExperience:"}

execute unless score %grave_info.xp sgrave.config matches 0 unless data storage sgrave all_graves[-1].broken{status:"ghost"} run tellraw @s {"translate":"sgrave.grave_info.xp.before_death","fallback": "    §eBefore death: %s Levels + %s Points","with":[{"nbt":"all_graves[-1].xp_before_death.lvl","color":"gold","storage": "sgrave"},{"nbt":"all_graves[-1].xp_before_death.points","color":"gold","storage": "sgrave"}]}

execute unless score %grave_info.xp sgrave.config matches 0 unless data storage sgrave all_graves[-1].broken{status:"ghost"} run tellraw @s {"translate":"sgrave.grave_info.xp.after_death","fallback": "    §eAfter death: %s Levels + %s Points","with":[{"nbt":"all_graves[-1].xp.lvl","color":"gold","storage": "sgrave"},{"nbt":"all_graves[-1].xp.points","color":"gold","storage": "sgrave"}]}

execute unless score %grave_info.despawn_time sgrave.config matches 0 unless data storage sgrave all_graves[-1].despawn_time{infinite:0b} unless score %grave_info.despawn_time sgrave.config matches 0 unless score %is_active sgrave.dummy matches 0 run tellraw @s {"translate": "sgrave.grave_info.despawn_time_never", "fallback": "  §7§mDespawn time: §kNever"}

execute unless score %grave_info.despawn_time sgrave.config matches 0 if data storage sgrave all_graves[-1].despawn_time{infinite:0b} unless score %grave_info.despawn_time sgrave.config matches 0 unless score %is_active sgrave.dummy matches 0 run tellraw @s {"translate": "sgrave.grave_info.despawn_time", "fallback":"  §bDespawn time: %s§ch §f: %s§cm §f: %s§cs","with":[{"nbt":"all_graves[-1].despawn_time.h","storage":"sgrave","color":"gold"},{"nbt":"all_graves[-1].despawn_time.m","storage":"sgrave","color":"gold"},{"nbt":"all_graves[-1].despawn_time.s","storage":"sgrave","color":"gold"}]}

execute unless score %grave_info.creation_time sgrave.config matches 0 run tellraw @s {"translate": "sgrave.grave_info.creation_time", "fallback":"  §bCreated at: §rDay %s || %s : %s","with":[{"nbt":"all_graves[-1].creation_time.day","storage":"sgrave","color":"gold"},{"nbt":"all_graves[-1].creation_time.hour","storage":"sgrave","color":"gold"},{"nbt":"all_graves[-1].creation_time.minute","storage":"sgrave","color":"gold"}]}

execute unless score %grave_info.items sgrave.config matches 0 run tellraw @s {"translate": "sgrave.grave_info.item", "fallback":"  §bItems: §7[%s§7]","with":[{"translate":"sgrave.grave_info.item.show_info","fallback":"§6Show info","clickEvent": {"action": "run_command", "value": "/function sgrave:grave_info/items"}}]}

execute unless score %grave_info.broken_status sgrave.config matches 0 unless score %grave_info.breaker sgrave.config matches 0 if data storage sgrave all_graves[-1].broken{status:"opened"} run tellraw @s {"translate": "sgrave.grave_info.status.opened_by", "fallback":"\n  §bStatus: §cOpened by %s","with": [{"nbt":"all_graves[-1].broken.executor.name", "storage": "sgrave", "color": "green"}]}

execute unless score %grave_info.broken_status sgrave.config matches 0 if score %grave_info.breaker sgrave.config matches 0 if data storage sgrave all_graves[-1].broken{status:"opened"} run tellraw @s {"translate": "sgrave.grave_info.status.opened", "fallback":"\n  §bStatus: §cOpened"}

execute unless score %grave_info.broken_status sgrave.config matches 0 unless score %grave_info.breaker sgrave.config matches 0 if data storage sgrave all_graves[-1].broken{status:"broken"} run tellraw @s {"translate": "sgrave.grave_info.status.broken_by", "fallback":"\n  §bStatus: §cBroken by %s","with": [{"nbt":"all_graves[-1].broken.executor.name", "storage": "sgrave", "color": "green"}]}

execute unless score %grave_info.broken_status sgrave.config matches 0 if score %grave_info.breaker sgrave.config matches 0 if data storage sgrave all_graves[-1].broken{status:"broken"} run tellraw @s {"translate": "sgrave.grave_info.status.broken", "fallback":"\n  §bStatus: §cBroken"}

execute unless score %grave_info.broken_status sgrave.config matches 0 if data storage sgrave all_graves[-1].broken{status:"despawned"} run tellraw @s {"translate": "sgrave.grave_info.status.despawned", "fallback":"\n  §bStatus: §cDespawned"}

execute if data storage sgrave all_graves[-1].broken{status:"ghost"} run tellraw @s {"translate": "sgrave.grave_info.status.ghost", "fallback":"\n  §bStatus: §7Ghost","hoverEvent": {"action": "show_text","contents": {"translate": "sgrave.grave_info.status.ghost.description","fallback": "Basically SGrave could not detect any dropped items when you died, but it §odid §rfind items that were in your inventory right before you died.\n\n§aIf you weren't supposed to drop any of the items that were in your inventory (for example all of your items had curse of vanishing or were on 1 durability), then ignore this. You're good to go.\n\n§6If you had items in your inventory and they were supposed to go into the grave, Then you've experienced a bug. Please use `/trigger sgrave.help`. Don't worry; you will be able to recover your items.\n\n§bNote: This grave does not exist in the world!"}}}

execute if score %grave_info.broken_status sgrave.config matches 0 if score %is_active sgrave.dummy matches 0 unless data storage sgrave all_graves[-1].broken{status:"ghost"} run tellraw @s {"translate": "sgrave.grave_info.status.inactive", "fallback":"\n  §bStatus: §cInactive", "hoverEvent": {"action": "show_text", "contents": {"translate":"sgrave.grave_info.status.inactive.description", "fallback":"This grave has either been broken, opened or despawned."}}}

execute if score %is_active sgrave.dummy matches 1 run tellraw @s {"translate": "sgrave.grave_info.status.active", "fallback":"\n  §bStatus: §aActive", "hoverEvent": {"action": "show_text", "contents": {"translate":"sgrave.grave_info.status.active.description", "fallback":"This grave currently exists!"}}}

tellraw @s " "
