# This data pack is made by Sul4ur.
# Tick function

## Schedule this function to run again
schedule function sgrave:main 1t replace
# advancement revoke @a only sgrave:on_death death

## Config management
function sgrave:config_management/main

## Get rid of temp items
kill @e[tag=sgrave.player_name_reader_on_use]
clear @a *[minecraft:custom_data~{sgrave:{player_name_reader:1b}}]

## Change gamerules if the incorrect one was set
execute if score %change_gamerules sgrave.config matches 1 run function sgrave:set_to_correct_gamerules

## Player management (some sub-folders in this folder don't actually have to do anything with the players themselves)
execute as @a at @s run function sgrave:player_management/main

## Store items and xp of the player in a safe place (for the backup process and grave info)
execute as @a[scores={sgrave.death_count=..0},nbt=!{Health:0f}] at @s run function sgrave:store_backup_contents

## Apply inability or ability for items to despawn based on the set config
scoreboard players operation @e[scores={sgrave.no_despawn=0..1},tag=!sgrave.grave] sgrave.no_despawn = %item_no_despawn sgrave.config

## Enable these triggers for normal players
scoreboard players enable @a sgrave
scoreboard players enable @a sgrave.help
scoreboard players enable @a sgrave.info
scoreboard players enable @a sgrave.grave_info

## Enable these triggers for players with admin mode set to true
scoreboard players enable @a[scores={sgrave.is_admin=1}] sgrave.recover_items
scoreboard players enable @a[scores={sgrave.is_admin=1}] sgrave.give_key

## Scoreboard management
execute as @a at @s unless score @s sgrave.is_admin matches 0..1 run scoreboard players set @s sgrave.is_admin 0
execute as @a at @s unless score @s sgrave.keeps_content_on_death matches 0..1 run scoreboard players set @s sgrave.keeps_content_on_death 0

## Get if keepInventory is turned on
execute store result score %keepInventory sgrave.dummy run gamerule keepInventory

## Respond to the triggers
execute as @a[scores={sgrave=1..}] at @s run function sgrave:locate_last_grave
execute as @a[scores={sgrave.info=1..}] at @s run function sul4ur:sgrave/info
execute as @a[scores={sgrave.help=1..}] at @s run function sul4ur:sgrave/help
execute as @a[scores={sgrave.grave_info=1..}] at @s run function sgrave:grave_info/check_conditions
execute as @a[scores={sgrave.is_admin=1,sgrave.recover_items=1..}] at @s run function sgrave:backup/main
give @a[scores={sgrave.is_admin=1,sgrave.give_key=1..}] rabbit_hide[custom_model_data={strings:["sgrave.item.sgrave_key"]},custom_data={sgrave:{key:1b}},enchantments={levels:{vanishing_curse:1},show_in_tooltip:false},item_name='{"translate": "sgrave.key.name","fallback": "§dSGrave key","italic": false}'] 1

## Set these triggers to 0 to prevent looping
scoreboard players set @a sgrave.grave_info 0
scoreboard players set @a sgrave.give_key 0
scoreboard players set @a sgrave.recover_items 0

## Limit the number of elements in the list "all_graves" to 256.
data remove storage sgrave all_graves[-257]

## Save items from the void
execute as @e[tag=sgrave.item] at @s store result score @s sgrave.y_pos run data get entity @s Pos[1]
execute as @e[scores={sgrave.y_pos=..-64},tag=sgrave.item] at @s if score %void_invuln_items sgrave.config matches 1 run tp @s ~ 400 ~

## Run the commands for a dead player
execute as @a[tag=!sgrave.has_put_grave,gamemode=!creative,gamemode=!spectator,scores={sgrave.keeps_content_on_death=0,sgrave.death_count=1..}] at @s unless score %new_item_detection sgrave.config matches 0 unless score %keepInventory sgrave.dummy matches 1 run function sgrave:on/death
execute as @a[tag=!sgrave.has_put_grave,gamemode=creative,scores={sgrave.keeps_content_on_death=0,sgrave.death_count=1..}] at @s unless score %creative_players_grave sgrave.config matches 0 unless score %new_item_detection sgrave.config matches 0 unless score %keepInventory sgrave.dummy matches 1 run function sgrave:on/death
execute as @a[tag=!sgrave.has_put_grave,gamemode=spectator,scores={sgrave.keeps_content_on_death=0,sgrave.death_count=1..}] at @s unless score %spectator_players_grave sgrave.config matches 0 unless score %new_item_detection sgrave.config matches 0 unless score %keepInventory sgrave.dummy matches 1 run function sgrave:on/death

## Run the commands for a dead player (legacy mode)
execute as @a[tag=!sgrave.has_put_grave,gamemode=!creative,gamemode=!spectator,scores={sgrave.keeps_content_on_death=0,sgrave.death_count=1..},nbt={Health:0f}] at @s unless data entity @s Inventory[0] if score %new_item_detection sgrave.config matches 0 run function sgrave:legacy/on/death_no_inventory
execute as @a[tag=!sgrave.has_put_grave,gamemode=!creative,gamemode=!spectator,scores={sgrave.keeps_content_on_death=0,sgrave.death_count=1..},nbt={Health:0f}] at @s if data entity @s Inventory[0] if score %new_item_detection sgrave.config matches 0 run function sgrave:legacy/on/death

execute as @a[tag=!sgrave.has_put_grave,gamemode=creative,scores={sgrave.keeps_content_on_death=0,sgrave.death_count=1..},nbt={Health:0f}] at @s unless score %creative_players_grave sgrave.config matches 0 unless data entity @s Inventory[0] if score %new_item_detection sgrave.config matches 0 run function sgrave:legacy/on/death_no_inventory
execute as @a[tag=!sgrave.has_put_grave,gamemode=creative,scores={sgrave.keeps_content_on_death=0,sgrave.death_count=1..},nbt={Health:0f}] at @s unless score %creative_players_grave sgrave.config matches 0 if data entity @s Inventory[0] if score %new_item_detection sgrave.config matches 0 run function sgrave:legacy/on/death

execute as @a[tag=!sgrave.has_put_grave,gamemode=spectator,scores={sgrave.keeps_content_on_death=0,sgrave.death_count=1..},nbt={Health:0f}] at @s unless score %spectator_players_grave sgrave.config matches 0 unless data entity @s Inventory[0] if score %new_item_detection sgrave.config matches 0 run function sgrave:legacy/on/death_no_inventory
execute as @a[tag=!sgrave.has_put_grave,gamemode=spectator,scores={sgrave.keeps_content_on_death=0,sgrave.death_count=1..},nbt={Health:0f}] at @s unless score %spectator_players_grave sgrave.config matches 0 if data entity @s Inventory[0] if score %new_item_detection sgrave.config matches 0 run function sgrave:legacy/on/death

### Prevent loop
scoreboard players set @a sgrave.death_count 0

## Grave management
execute as @e[tag=sgrave.grave] at @s run function sgrave:grave_management

## Kill experience orbs without any xp stored inside them
kill @e[tag=sgrave.xp,nbt={Value:0s}]

## Remove unnessecary data
data remove storage sgrave temp

## Reset all scores saved in "sgrave.dummy"
scoreboard objectives remove sgrave.dummy
scoreboard objectives add sgrave.dummy dummy

## Remove unnessecary data from interaction entities
execute as @e[tag=sgrave.interaction] at @s run data remove entity @s interaction
execute as @e[tag=sgrave.interaction] at @s run data remove entity @s attack

## Remove unnessecary tags from players
tag @e remove sgrave.has_interacted_with_grave
tag @e[tag=sgrave.has_put_grave,nbt=!{Health:0.0f}] remove sgrave.has_put_grave
tag @e remove sgrave.dead_player

## This is for uninstalling
execute as @e at @s unless score @s sgrave.id matches -2147483648..2147483647 run tag @s remove sgrave.checked
execute as @e at @s unless score @s sgrave.id matches -2147483648..2147483647 run tag @s remove sgrave.is_stored
