# Execution from:
#>  sgrave:grave_management
#>  sgrave:on/attack_grave

## Tag the interactor and the grave marker
tag @s add sgrave.marker_on_use
execute as @e[type=interaction,limit=1,tag=sgrave.interaction,sort=nearest,nbt={interaction:{}}] on target run tag @s add sgrave.has_interacted_with_grave
execute as @e[type=interaction,limit=1,tag=sgrave.interaction,sort=nearest,nbt={attack:{}}] on attacker run tag @s add sgrave.has_interacted_with_grave

## Remove a grave count from the player (This score is unused, for now...)
scoreboard players remove @p[tag=sgrave.has_interacted_with_grave] sgrave.grave_count 1

## Prevent loop
data remove entity @e[type=interaction,limit=1,tag=sgrave.interaction,sort=nearest] interaction
data remove entity @e[type=interaction,limit=1,tag=sgrave.interaction,sort=nearest] attack

## Store player's items in 2 chest minecarts so that we can observe the grave's stored inventory better
summon chest_minecart ~ 65535 ~ {NoGravity:1b,Invulnerable:1b,Tags:["sgrave.temp.chest.1"]}
summon chest_minecart ~ 32767 ~ {NoGravity:1b,Invulnerable:1b,Tags:["sgrave.temp.chest.2"]}

## Fill the first chest minecart with the inventory of the player before death
execute positioned ~ 65535 ~ run function sgrave:on/interaction_with_grave/fill_chest1

## Fill the second chest minecart with the hotbar, armor and offhand slot of the player before death
execute positioned ~ 32767 ~ as @e[tag=sgrave.temp.chest.2,limit=1,sort=nearest,distance=..1] run function sgrave:on/interaction_with_grave/fill_chest2
execute positioned ~ 32767 ~ run function sgrave:on/interaction_with_grave/place_in_chest2

## Replace the player's inventory with items from the minecart chests one by one
execute positioned ~ 65535 ~ as @e[tag=sgrave.temp.chest.1,limit=1,sort=nearest,distance=..1] at @s run function sgrave:on/interaction_with_grave/fill_player_inv/inv1
execute positioned ~ 32767 ~ as @e[tag=sgrave.temp.chest.2,limit=1,sort=nearest,distance=..1] at @s run function sgrave:on/interaction_with_grave/fill_player_inv/inv2

## Clear the chest
execute positioned ~ 65535 ~ as @e[tag=sgrave.temp.chest.1,limit=1,sort=nearest,distance=..1] run function sgrave:on/interaction_with_grave/clear_temp_chest
execute positioned ~ 32767 ~ as @e[tag=sgrave.temp.chest.2,limit=1,sort=nearest,distance=..1] run function sgrave:on/interaction_with_grave/clear_temp_chest

## Give the player their experience using an experience orb
execute as @p[tag=sgrave.has_interacted_with_grave] at @s run function sgrave:on/interaction_with_grave/give_xp with entity @e[tag=sgrave.marker_on_use,limit=1,sort=nearest] data.sgrave.xp

## Remove the grave from lists in storages "players[].graves" and specify it as broken in "all_graves"
scoreboard players set %loop_count sgrave.dummy 0

function sgrave:player_management/rotate_data/players_by_stored_id
execute store result score %check.grave_id sgrave.dummy run data get entity @s data.sgrave.id
function sgrave:player_management/rotate_data/graves
data modify storage sgrave players[-1].graves[-1].to_be_removed set value 1b
function sgrave:player_management/rotate_data/graves_reverse
data remove storage sgrave players[-1].graves[{to_be_removed:1b}]

scoreboard players set %loop_count sgrave.dummy 0

execute store result score %check.grave_id sgrave.dummy run data get entity @s data.sgrave.id
function sgrave:player_management/rotate_data/all_graves
data modify storage sgrave all_graves[-1].broken.status set value "opened"
data modify storage sgrave all_graves[-1].active set value 0b

data modify storage sgrave all_graves[-1].broken.executor.sgrave_id set from storage sgrave players[-1].id
data modify storage sgrave all_graves[-1].broken.executor.uuid set from storage sgrave players[-1].UUID
data modify storage sgrave all_graves[-1].broken.executor.name set from storage sgrave players[-1].name

execute if score %loop_count sgrave.dummy matches 1.. run function sgrave:player_management/rotate_data/all_graves_reverse

scoreboard players set %loop_count sgrave.dummy 0

## Stop the player xp levelup sound
stopsound @p[tag=sgrave.has_interacted_with_grave] * minecraft:entity.player.levelup

## If there are any items that could not be inserted into the player's inventory, drop them instead.
execute if data entity @s data.sgrave.Items[0] run function sgrave:drop_items

## Delete the grave
function sgrave:delete_grave

## Remove unnessecary tags
tag @e[tag=sgrave.marker_on_use] remove sgrave.marker_on_use
tag @e[tag=sgrave.has_interacted_with_grave] remove sgrave.has_interacted_with_grave
