/*
 * Decompiled with CFR 0.152.
 */
package dev.soncresityindustries.deathbolt;

import com.mojang.logging.LogUtils;
import dev.soncresityindustries.deathbolt.Config;
import dev.soncresityindustries.deathbolt.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.slf4j.Logger;

@Mod(value="sideathbolt")
public class SIDeathBolt {
    public static final String Version = "1.0.1-1.20.6-neoforge";
    public static final String MODID = "sideathbolt";
    private static final Logger LOGGER = LogUtils.getLogger();

    public SIDeathBolt(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Initializing Mod DeathBolt (Version: 1.0.1-1.20.6-neoforge) by Soncresity Industries");
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent deathEvent) {
        block29: {
            MinecraftServer server;
            block28: {
                String world;
                LivingEntity livingEntity = deathEvent.getEntity();
                if (!(livingEntity instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)livingEntity;
                ServerLevel level = (ServerLevel)player.level();
                server = level.getServer();
                String[] stringArray = Config.blacklistedWorlds;
                int n = stringArray.length;
                int n2 = 0;
                if (n2 < n && (world = stringArray[n2]).equals(level.dimension().location().toString())) {
                    return;
                }
                BlockPos pos = player.blockPosition();
                LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)level);
                bolt.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                if (Config.boltVisual) {
                    bolt.setVisualOnly(true);
                } else {
                    bolt.setVisualOnly(false);
                }
                level.addFreshEntity((Entity)bolt);
                if (Config.soundGlobal) {
                    for (Player p : server.getPlayerList().getPlayers()) {
                        if (p.getDisplayName() == player.getDisplayName()) continue;
                        SoundEngine.playLightningSound(level, pos, p);
                    }
                }
                if (Config.configVersion != 1) break block28;
                switch (Config.deathAction) {
                    case "MSG": {
                        switch (Config.msgType) {
                            case "MSG_PRIVATE": {
                                server.execute(() -> player.sendSystemMessage((Component)Component.literal((String)Config.punishMessage.replace("{player}", player.getDisplayName().getString()))));
                                break;
                            }
                            case "MSG_BROADCAST": {
                                for (Player p : server.getPlayerList().getPlayers()) {
                                    p.sendSystemMessage((Component)Component.literal((String)Config.punishMessage.replace("{player}", player.getDisplayName().getString())));
                                }
                                break block29;
                            }
                            default: {
                                server.sendSystemMessage((Component)Component.literal((String)"\u00a7cThere is an issue with your DeathBolt configuration. Please check the msgType Value."));
                                break;
                            }
                        }
                        break block29;
                    }
                    case "KICK": {
                        server.execute(() -> player.connection.disconnect((Component)Component.literal((String)Config.punishMessage.replace("{player}", player.getDisplayName().getString()))));
                        break;
                    }
                    case "BAN": {
                        server.execute(() -> {
                            UserBanList banList = server.getPlayerList().getBans();
                            UserBanListEntry entry = new UserBanListEntry(player.getGameProfile(), null, null, null, Config.punishMessage.replace("{player}", player.getDisplayName().getString()));
                            banList.add((StoredUserEntry)entry);
                            player.connection.disconnect((Component)Component.literal((String)Config.punishMessage.replace("{player}", player.getDisplayName().getString())));
                        });
                        break;
                    }
                    case "NONE": {
                        break;
                    }
                    default: {
                        server.sendSystemMessage((Component)Component.literal((String)"\u00a7cThere is an issue with your DeathBolt configuration. Please check the deathAction Value."));
                    }
                }
                break block29;
            }
            for (Player p : server.getPlayerList().getPlayers()) {
                p.sendSystemMessage((Component)Component.literal((String)"\u00a7cThere is an issue with your DeathBolt configuration. Please make sure that the configVersion hasn't been changed."));
            }
        }
    }
}

