/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.zombieapocalypse999;

import com.yourname.zombieapocalypse999.CommandHandler;
import com.yourname.zombieapocalypse999.Infected;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ZombieApocalypse999
extends JavaPlugin
implements Listener {
    private static final String BASE_SPEED = "zombie_stats.base_speed";
    private static final String BASE_DAMAGE = "zombie_stats.base_damage";
    private static final String BASE_MUTATION = "mutation_rates.base";
    private static final String MUTATION_INCREASE = "mutation_rates.daily_increase";
    private static final String SPAWN_TIME_MODE = "zombies.spawn_time_mode";
    private static final int TICKS_PER_DAY = 24000;
    private static final int SENSOR_RANGE = 50;
    private static final int BLOOD_MOON_FREQUENCY = 5;
    public final NamespacedKey zombieTypeKey = new NamespacedKey((Plugin)this, "zombie_type");
    public final NamespacedKey mutationDayKey = new NamespacedKey((Plugin)this, "mutation_day");
    private final NamespacedKey leaderKey = new NamespacedKey((Plugin)this, "leader");
    private final NamespacedKey followLeaderKey = new NamespacedKey((Plugin)this, "follow_leader");
    private final NamespacedKey breakingCooldownKey = new NamespacedKey((Plugin)this, "breaking_cooldown");
    private int currentDay = 0;
    private double currentMutationRate;
    private boolean isBloodMoon = false;
    private final Map<String, Integer> zombieChunkCount = new HashMap<String, Integer>();
    private final Random random = new Random();
    private boolean showMutationNamesAboveZombies;
    private Map<String, List<ItemStack>> mutationLootDrops = new HashMap<String, List<ItemStack>>();
    private Infected infected;
    private CommandHandler commandHandler;
    private String spawnTimeMode = "both";
    private long memoryDurationMs = 5000L;
    private final Map<UUID, Map<UUID, Long>> zombieTargetMemory = new HashMap<UUID, Map<UUID, Long>>();
    private int sprintNoiseRange = 20;
    private int eatingNoiseRange = 12;
    private int bowNoiseRange = 25;
    private int torchNoiseRange = 30;
    private double leaderChance = 0.3;
    private int packRadius = 15;
    private int followRadius = 10;
    private final Set<Material> breakableBlocks = new HashSet<Material>();
    private final Map<Material, Integer> breakableBlocksCooldown = new HashMap<Material, Integer>();
    private int defaultBreakingCooldownTicks = 60;
    private int breakingRadius = 2;
    private boolean breakingEnabled = true;
    private double maxSpeed;
    private double maxDamage;
    private int maxZombiesPerChunk = 20;
    private int maxZombiesWorldwide = 100;
    private boolean bloodmoonEnabled = true;
    private List<String> whitelistedWorlds;

    public void onEnable() {
        this.saveDefaultConfig();
        this.whitelistedWorlds = this.getConfig().getStringList("world-whitelist");
        if (this.whitelistedWorlds.isEmpty()) {
            this.getLogger().warning("No worlds specified in 'world-whitelist' in config.yml. Plugin will be active in all worlds.");
        } else {
            this.getLogger().info("Plugin active in whitelisted worlds: " + String.join((CharSequence)", ", this.whitelistedWorlds));
        }
        this.loadMutationConfig();
        this.loadLootDropsConfig();
        this.loadSpawnTimeModeConfig();
        this.loadSmarterTargetingConfig();
        this.loadGroupBehaviorConfig();
        this.loadBlockBreakingConfig();
        this.loadZombieStatCaps();
        this.loadZombieLimitsConfig();
        this.loadBloodmoonConfig();
        this.infected = new Infected(this);
        this.infected.loadInfectionConfig();
        this.infected.loadPlayersData();
        this.infected.restoreInfectedPlayers();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.infected, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SunlightProtectionListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NoiseLightListener(), (Plugin)this);
        this.startDayCycle();
        this.startSpawningSystem();
        this.startAIUpdateSystem();
        new BukkitRunnable(){

            public void run() {
                for (World world : Bukkit.getWorlds()) {
                    for (Zombie zombie : world.getEntitiesByClass(Zombie.class)) {
                        if (!"leech".equals(zombie.getPersistentDataContainer().get(ZombieApocalypse999.this.zombieTypeKey, PersistentDataType.STRING))) continue;
                        ConfigurationSection cfg = ZombieApocalypse999.this.getConfig().getConfigurationSection("mutation_types.leech");
                        double auraRadius = cfg.getDouble("leech_aura_radius", 5.0);
                        double auraDamage = cfg.getDouble("leech_aura_damage", 1.0);
                        for (Entity entity : zombie.getNearbyEntities(auraRadius, auraRadius, auraRadius)) {
                            LivingEntity livingEntity;
                            if (!(entity instanceof LivingEntity) || entity.equals((Object)zombie) || !((livingEntity = (LivingEntity)entity) instanceof Player) && !(livingEntity instanceof Zombie)) continue;
                            livingEntity.damage(auraDamage, (Entity)zombie);
                            double currentHealth = zombie.getHealth();
                            double maxHealth = zombie.getAttribute(Attribute.MAX_HEALTH).getValue();
                            zombie.setHealth(Math.min(maxHealth, currentHealth + auraDamage));
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
        this.currentMutationRate = this.getConfig().getDouble(BASE_MUTATION, 10.0);
        this.currentDay = this.getConfig().getInt("data.current_day", 0);
        this.commandHandler = new CommandHandler(this, this.infected);
        this.getLogger().info("Zombie Apocalypse 999 initialized! Day " + this.currentDay + ", Spawn Time Mode: " + this.spawnTimeMode);
    }

    public void onDisable() {
        this.infected.savePlayersData();
        this.infected.removeAllBossBars();
        this.getLogger().info("Zombie Apocalypse 999 shut down safely. All runtime config changes saved.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.commandHandler.onCommand(sender, command, label, args);
    }

    public void loadMutationConfig() {
        FileConfiguration cfg = this.getConfig();
        this.showMutationNamesAboveZombies = cfg.getBoolean("mutation_system.show_mutation_names_above_zombies", true);
    }

    public void loadLootDropsConfig() {
        this.mutationLootDrops.clear();
        ConfigurationSection lootSection = this.getConfig().getConfigurationSection("loot_drops");
        if (lootSection == null) {
            return;
        }
        for (String mutationType : lootSection.getKeys(false)) {
            boolean enabled;
            ConfigurationSection typeSection = lootSection.getConfigurationSection(mutationType);
            if (typeSection == null || !(enabled = typeSection.getBoolean("enabled", true))) continue;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            List itemNames = typeSection.getStringList("items");
            for (String itemName : itemNames) {
                Material mat = Material.getMaterial((String)itemName.toUpperCase());
                if (mat != null) {
                    items.add(new ItemStack(mat));
                    continue;
                }
                this.getLogger().warning("Invalid material in loot_drops for " + mutationType + ": " + itemName);
            }
            this.mutationLootDrops.put(mutationType.toLowerCase(), items);
        }
    }

    public void loadSpawnTimeModeConfig() {
        FileConfiguration cfg = this.getConfig();
        this.getLogger().info("Attempting to load spawn_time_mode from config...");
        String mode = cfg.getString(SPAWN_TIME_MODE, "both").toLowerCase(Locale.ROOT);
        this.getLogger().info("Found spawn_time_mode in config: " + mode);
        if (!(mode.equals("day") || mode.equals("night") || mode.equals("both"))) {
            this.getLogger().warning("Invalid spawn_time_mode in config: " + mode + ". Defaulting to 'both'.");
            this.spawnTimeMode = "both";
        } else {
            this.spawnTimeMode = mode;
            this.getLogger().info("Successfully loaded spawn_time_mode: " + this.spawnTimeMode);
        }
    }

    public void loadSmarterTargetingConfig() {
        FileConfiguration cfg = this.getConfig();
        this.memoryDurationMs = cfg.getLong("ai.memory_duration", 5000L);
        this.sprintNoiseRange = cfg.getInt("ai.noise.sprint_range", 20);
        this.eatingNoiseRange = cfg.getInt("ai.noise.eating_range", 12);
        this.bowNoiseRange = cfg.getInt("ai.noise.bow_range", 25);
        this.torchNoiseRange = cfg.getInt("ai.noise.torch_range", 30);
    }

    public void loadGroupBehaviorConfig() {
        FileConfiguration cfg = this.getConfig();
        this.leaderChance = cfg.getDouble("ai.group.leader_chance", 0.3);
        this.packRadius = cfg.getInt("ai.pack.radius", 15);
        this.followRadius = cfg.getInt("ai.group.follow_radius", 10);
    }

    public void loadBlockBreakingConfig() {
        FileConfiguration cfg = this.getConfig();
        this.breakingEnabled = cfg.getBoolean("ai.breaking.enabled", true);
        this.breakingRadius = cfg.getInt("ai.breaking.radius", 2);
        this.defaultBreakingCooldownTicks = cfg.getInt("ai.breaking.default_cooldown_ticks", 60);
        this.breakableBlocks.clear();
        this.breakableBlocksCooldown.clear();
        ConfigurationSection blocksSection = cfg.getConfigurationSection("ai.breaking.blocks");
        if (blocksSection != null) {
            for (String blockName : blocksSection.getKeys(false)) {
                Material mat = Material.getMaterial((String)blockName.toUpperCase());
                if (mat != null) {
                    this.breakableBlocks.add(mat);
                    ConfigurationSection blockCfg = blocksSection.getConfigurationSection(blockName);
                    int cooldown = this.defaultBreakingCooldownTicks;
                    if (blockCfg != null) {
                        cooldown = blockCfg.getInt("cooldown_ticks", this.defaultBreakingCooldownTicks);
                    }
                    this.breakableBlocksCooldown.put(mat, cooldown);
                    continue;
                }
                this.getLogger().warning("Invalid breakable block in config: " + blockName);
            }
        }
    }

    public void loadZombieStatCaps() {
        FileConfiguration cfg = this.getConfig();
        this.maxSpeed = cfg.getDouble("zombie_stats.max_speed", 0.35);
        this.maxDamage = cfg.getDouble("zombie_stats.max_damage", 40.0);
    }

    public void loadZombieLimitsConfig() {
        FileConfiguration cfg = this.getConfig();
        this.maxZombiesPerChunk = cfg.getInt("zombies.max_per_chunk", 20);
        this.maxZombiesWorldwide = cfg.getInt("zombies.max_worldwide", 100);
    }

    public void loadBloodmoonConfig() {
        FileConfiguration cfg = this.getConfig();
        this.bloodmoonEnabled = cfg.getBoolean("zombies.bloodmoon_enabled", true);
    }

    private void startDayCycle() {
        new BukkitRunnable(){

            public void run() {
                if (Bukkit.getOnlinePlayers().isEmpty()) {
                    return;
                }
                ++ZombieApocalypse999.this.currentDay;
                ZombieApocalypse999.this.currentMutationRate = ZombieApocalypse999.this.getConfig().getDouble(ZombieApocalypse999.BASE_MUTATION) + (double)ZombieApocalypse999.this.currentDay * ZombieApocalypse999.this.getConfig().getDouble(ZombieApocalypse999.MUTATION_INCREASE);
                if (ZombieApocalypse999.this.bloodmoonEnabled && ZombieApocalypse999.this.currentDay % 5 == 0) {
                    ZombieApocalypse999.this.triggerBloodMoon();
                } else {
                    ZombieApocalypse999.this.isBloodMoon = false;
                }
                ZombieApocalypse999.this.getLogger().info("Day " + ZombieApocalypse999.this.currentDay + " - Mutation: " + ZombieApocalypse999.this.currentMutationRate + "%");
            }
        }.runTaskTimer((Plugin)this, 0L, 24000L);
    }

    public void triggerBloodMoon() {
        this.isBloodMoon = true;
        this.currentMutationRate = 100.0;
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.DARK_RED) + "\u2726 BLOOD MOON RISING \u2726"));
        Bukkit.getOnlinePlayers().forEach(p -> {
            p.playSound(p.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.5f, 0.7f);
            p.spawnParticle(Particle.LAVA, p.getLocation().add(0.0, 2.0, 0.0), 50);
        });
    }

    private void startSpawningSystem() {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getOnlinePlayers().forEach(player -> {
                    if (ZombieApocalypse999.this.random.nextInt(5) < 2 && ZombieApocalypse999.this.canSpawnZombiesAt(player.getWorld(), player.getLocation())) {
                        ZombieApocalypse999.this.spawnZombieGroup((Player)player);
                    }
                });
            }
        }.runTaskTimer((Plugin)this, 0L, 100L);
    }

    private boolean canSpawnZombiesAt(World world, Location loc) {
        long time = world.getTime();
        switch (this.spawnTimeMode) {
            case "day": {
                if (time >= 0L && time <= 12299L) break;
                return false;
            }
            case "night": {
                if (time >= 12300L && time <= 23999L) break;
                return false;
            }
        }
        FileConfiguration cfg = this.getConfig();
        boolean requireDarkness = cfg.getBoolean("zombies.require_darkness", true);
        int maxLight = cfg.getInt("zombies.max_light_level", 7);
        boolean bloodMoonIgnoresDarkness = cfg.getBoolean("zombies.bloodmoon_ignores_darkness", true);
        if (!requireDarkness) {
            return true;
        }
        if (this.isBloodMoon && bloodMoonIgnoresDarkness) {
            return true;
        }
        byte light = loc.getBlock().getLightLevel();
        return light <= maxLight;
    }

    private void spawnZombieGroup(Player player) {
        World world = player.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return;
        }
        long time = world.getTime();
        if (!this.canSpawnZombiesAt(world, player.getLocation())) {
            return;
        }
        int totalZombies = 0;
        for (World w : Bukkit.getWorlds()) {
            totalZombies += w.getEntitiesByClass(Zombie.class).size();
        }
        if (totalZombies >= this.maxZombiesWorldwide) {
            return;
        }
        int minZombies = 2;
        int maxZombies = Math.min(6 + this.currentDay, 15);
        int zombieCount = this.random.nextInt(maxZombies - minZombies + 1) + minZombies;
        if (this.isBloodMoon) {
            zombieCount *= 2;
        }
        UUID leaderUUID = null;
        boolean hasLeader = this.random.nextDouble() < this.leaderChance;
        for (int i = 0; i < zombieCount; ++i) {
            String chunkKey;
            Location spawnLoc = this.findSafeSpawnLocation(player.getLocation());
            if (spawnLoc == null || this.zombieChunkCount.getOrDefault(chunkKey = spawnLoc.getChunk().getX() + "," + spawnLoc.getChunk().getZ(), 0) >= this.maxZombiesPerChunk) continue;
            Zombie zombie = (Zombie)world.spawnEntity(spawnLoc, EntityType.ZOMBIE);
            this.initializeZombie(zombie);
            if (hasLeader) {
                if (i == 0) {
                    zombie.getPersistentDataContainer().set(this.leaderKey, PersistentDataType.INTEGER, (Object)1);
                    leaderUUID = zombie.getUniqueId();
                } else if (leaderUUID != null) {
                    zombie.getPersistentDataContainer().set(this.followLeaderKey, PersistentDataType.STRING, (Object)leaderUUID.toString());
                }
            }
            this.trackChunkDensity(spawnLoc);
        }
    }

    private Location findSafeSpawnLocation(Location center) {
        for (int i = 0; i < 10; ++i) {
            Location attempt = center.clone().add((double)(this.random.nextInt(30) - 15), 0.0, (double)(this.random.nextInt(30) - 15));
            attempt.setY((double)(center.getWorld().getHighestBlockYAt(attempt) + 1));
            if (!this.isValidSpawnPoint(attempt)) continue;
            return attempt;
        }
        return null;
    }

    private boolean isValidSpawnPoint(Location loc) {
        return loc.getBlock().getType().isAir() && loc.clone().add(0.0, 1.0, 0.0).getBlock().getType().isAir() && loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().isSolid() && !loc.getBlock().isLiquid() && loc.getY() > 0.0;
    }

    private void trackChunkDensity(Location loc) {
        String chunkKey = loc.getChunk().getX() + "," + loc.getChunk().getZ();
        int count = this.zombieChunkCount.getOrDefault(chunkKey, 0) + 1;
        this.zombieChunkCount.put(chunkKey, count);
        if (count >= 20) {
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.DARK_RED) + "\u2726 MUTATION SURGE IN AREA [" + chunkKey + "] \u2726"));
        }
    }

    private void handleCryoTrail(final Zombie zombie) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.cryo");
        final int trailDuration = cfg.getInt("frozen_trail_duration", 5);
        new BukkitRunnable(){

            public void run() {
                Location loc;
                if (!zombie.isDead() && zombie.isValid() && (loc = zombie.getLocation()).getBlock().getType().isAir() && loc.clone().subtract(0.0, 1.0, 0.0).getBlock().getType().isSolid()) {
                    loc.getBlock().setType(Material.SNOW);
                    new BukkitRunnable(){

                        public void run() {
                            if (loc.getBlock().getType() == Material.SNOW) {
                                loc.getBlock().setType(Material.AIR);
                            }
                        }
                    }.runTaskLater((Plugin)ZombieApocalypse999.this, (long)(trailDuration * 20));
                }
            }
        }.runTask((Plugin)this);
    }

    private void handleInfernoTrail(final Zombie zombie) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.inferno");
        final int trailDuration = cfg.getInt("scorched_earth_duration", 5);
        new BukkitRunnable(){

            public void run() {
                Material below;
                Location loc;
                if (!zombie.isDead() && zombie.isValid() && (loc = zombie.getLocation()).getBlock().getType().isAir() && (below = loc.clone().subtract(0.0, 1.0, 0.0).getBlock().getType()).isFlammable()) {
                    loc.getBlock().setType(Material.FIRE);
                    new BukkitRunnable(){

                        public void run() {
                            if (loc.getBlock().getType() == Material.FIRE) {
                                loc.getBlock().setType(Material.AIR);
                            }
                        }
                    }.runTaskLater((Plugin)ZombieApocalypse999.this, (long)(trailDuration * 20));
                }
            }
        }.runTask((Plugin)this);
    }

    private void startAIUpdateSystem() {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getWorlds().forEach(world -> {
                    for (Entity entity : world.getEntities()) {
                        if (!(entity instanceof Zombie) || !entity.isValid()) continue;
                        Zombie zombie = (Zombie)entity;
                        ZombieApocalypse999.this.updateZombieAI(zombie);
                        String zombieType = (String)zombie.getPersistentDataContainer().get(ZombieApocalypse999.this.zombieTypeKey, PersistentDataType.STRING);
                        if (zombieType == null) continue;
                        switch (zombieType) {
                            case "cryo": {
                                ZombieApocalypse999.this.handleCryoTrail(zombie);
                                break;
                            }
                            case "inferno": {
                                ZombieApocalypse999.this.handleInfernoTrail(zombie);
                            }
                        }
                    }
                });
            }
        }.runTaskTimer((Plugin)this, 0L, 10L);
    }

    private void initializeZombie(Zombie zombie) {
        zombie.setCanPickupItems(false);
        zombie.setPersistent(true);
        double dayScale = 1.0 + 0.05 * (double)this.currentDay;
        double speed = this.getConfig().getDouble(BASE_SPEED, 0.23) * dayScale;
        double damage = this.getConfig().getDouble(BASE_DAMAGE, 2.0) * dayScale;
        if (speed > this.maxSpeed) {
            speed = this.maxSpeed;
        }
        if (damage > this.maxDamage) {
            damage = this.maxDamage;
        }
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, speed);
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, damage);
        if (this.random.nextDouble() * 100.0 < this.currentMutationRate || this.isBloodMoon) {
            this.applyRandomMutation(zombie, speed, damage);
        } else {
            this.setupNormalZombie(zombie);
        }
        if (this.isBloodMoon) {
            zombie.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, Integer.MAX_VALUE, 0, false, false));
        }
    }

    private void setAttribute(Zombie zombie, Attribute attribute, double value) {
        if (zombie.getAttribute(attribute) != null) {
            zombie.getAttribute(attribute).setBaseValue(value);
        }
    }

    private void applyRandomMutation(Zombie zombie, double baseSpeed, double baseDamage) {
        double roll = this.random.nextDouble() * 100.0;
        ConfigurationSection mutations = this.getConfig().getConfigurationSection("mutation_types");
        if (mutations == null) {
            return;
        }
        double cumulativeChance = 0.0;
        for (String key : mutations.getKeys(false)) {
            ConfigurationSection mutationSection = mutations.getConfigurationSection(key);
            if (mutationSection == null) continue;
            double spawnChance = mutationSection.getDouble("spawn_chance", 0.0);
            if (spawnChance == 0.0) {
                this.getLogger().warning("Mutation '" + key + "' has a spawn chance of 0. If you did this purposely, ignore this message.");
                continue;
            }
            if (roll < cumulativeChance + spawnChance) {
                switch (key) {
                    case "tank": {
                        this.createTank(zombie, baseSpeed, baseDamage);
                        break;
                    }
                    case "charger": {
                        this.createCharger(zombie, baseSpeed, baseDamage);
                        break;
                    }
                    case "assassin": {
                        this.createAssassin(zombie, baseDamage);
                        break;
                    }
                    case "blight": {
                        this.createBlightZombie(zombie, baseDamage);
                        break;
                    }
                    case "burster": {
                        this.createBurster(zombie, baseSpeed, baseDamage);
                        break;
                    }
                    case "spitter": {
                        this.createSpitter(zombie, baseSpeed, baseDamage);
                        break;
                    }
                    case "frost": {
                        this.createFrostZombie(zombie, baseDamage);
                        break;
                    }
                    case "shrieker": {
                        this.createShrieker(zombie, baseSpeed);
                        break;
                    }
                    case "cryo": {
                        this.createCryoZombie(zombie, baseSpeed, baseDamage);
                        break;
                    }
                    case "inferno": {
                        this.createInfernoZombie(zombie, baseSpeed, baseDamage);
                        break;
                    }
                    case "leech": {
                        this.createLeech(zombie, baseSpeed, baseDamage);
                    }
                }
                zombie.getPersistentDataContainer().set(this.mutationDayKey, PersistentDataType.INTEGER, (Object)this.currentDay);
                return;
            }
            cumulativeChance += spawnChance;
        }
    }

    private void setupNormalZombie(Zombie zombie) {
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"normal");
        zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        zombie.setCustomNameVisible(true);
    }

    private void createTank(Zombie zombie, double speed, double damage) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.tank");
        double health = 40.0 * cfg.getDouble("health_multiplier", 3.0);
        this.setAttribute(zombie, Attribute.MAX_HEALTH, health);
        zombie.setHealth(health);
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, speed * cfg.getDouble("speed_multiplier", 0.6));
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, damage * cfg.getDouble("damage_multiplier", 1.5));
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"tank");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.DARK_GREEN) + "TANK [" + (int)health + "\u2764]");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, Integer.MAX_VALUE, 1, false, false));
    }

    private void createCharger(Zombie zombie, double speed, double damage) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.charger");
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 20.0 * cfg.getDouble("health_multiplier", 0.8));
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, speed * cfg.getDouble("speed_multiplier", 2.2));
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, damage + cfg.getDouble("damage_bonus", 1.5));
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"charger");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.RED) + "\u26a1 CHARGER");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, false, false));
    }

    private void createAssassin(final Zombie zombie, double damage) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.assassin");
        this.setAttribute(zombie, Attribute.MAX_HEALTH, cfg.getDouble("base_health", 8.0));
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, damage * cfg.getDouble("damage_multiplier", 2.5));
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"assassin");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.DARK_PURPLE) + "ASSASSIN");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false));
        new BukkitRunnable(){

            public void run() {
                if (zombie.isDead() || !zombie.isValid()) {
                    this.cancel();
                    return;
                }
                zombie.getWorld().spawnParticle(Particle.WITCH, zombie.getLocation().add(0.0, 1.5, 0.0), 3, 0.2, 0.2, 0.2, 0.1);
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void createBlightZombie(final Zombie zombie, double baseDamage) {
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 20.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"blight");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.GREEN) + "BLIGHT ZOMBIE");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.POISON, Integer.MAX_VALUE, 1, false, false));
        new BukkitRunnable(){

            public void run() {
                if (zombie.isDead() || !zombie.isValid()) {
                    this.cancel();
                    return;
                }
                zombie.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, zombie.getLocation(), 5);
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void createBurster(Zombie zombie, double baseSpeed, double baseDamage) {
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 10.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, baseSpeed * 1.2);
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"burster");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.YELLOW) + "BURSTER");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.setMetadata("burster", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
    }

    private void createSpitter(Zombie zombie, double baseSpeed, double baseDamage) {
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 16.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, baseSpeed * 0.5);
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage * 0.5);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"spitter");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.BLUE) + "SPITTER");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
    }

    private void createFrostZombie(Zombie zombie, double baseDamage) {
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 20.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"frost");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.AQUA) + "FROST ZOMBIE");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 1, false, false));
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 1, false, false));
    }

    private void createShrieker(Zombie zombie, double baseSpeed) {
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 10.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, baseSpeed * 1.5);
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, 0.0);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"shrieker");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.LIGHT_PURPLE) + "SHRIEKER");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
    }

    private void createCryoZombie(Zombie zombie, double baseSpeed, double baseDamage) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.cryo");
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 20.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, baseSpeed * 0.8);
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"cryo");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.AQUA) + "Cryo Zombie");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 0, false, false));
    }

    private void createInfernoZombie(Zombie zombie, double baseSpeed, double baseDamage) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.inferno");
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 20.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, baseSpeed);
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage);
        zombie.setFireTicks(0);
        zombie.setVisualFire(false);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"inferno");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.GOLD) + "Inferno Zombie");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
    }

    private void createLeech(Zombie zombie, double baseSpeed, double baseDamage) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.leech");
        double healthMultiplier = cfg.getDouble("health_multiplier", 1.2);
        double damageMultiplier = cfg.getDouble("damage_multiplier", 0.8);
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 20.0 * healthMultiplier);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, baseSpeed * 0.9);
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage * damageMultiplier);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"leech");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.DARK_RED) + "Leech");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
    }

    private void handleBursterDeath(Zombie zombie) {
        Location location = zombie.getLocation();
        zombie.getWorld().createExplosion(location.getX(), location.getY(), location.getZ(), 3.0f, false, false);
        for (Entity entity : zombie.getWorld().getNearbyEntities(location, 5.0, 3.0, 5.0)) {
            if (!(entity instanceof LivingEntity) || entity instanceof Zombie) continue;
            ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.POISON, 100, 1));
        }
        zombie.getWorld().spawnParticle(Particle.CLOUD, location, 30, 2.0, 2.0, 2.0, 0.1);
        zombie.getWorld().playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 0.8f);
    }

    private void handleCryoDeath(Zombie zombie) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.cryo");
        double shatterDamage = cfg.getDouble("shatter_damage", 5.0);
        Location loc = zombie.getLocation();
        loc.getWorld().spawnParticle(Particle.SNOWFLAKE, loc, 100, 1.0, 1.0, 1.0, 0.1);
        loc.getWorld().playSound(loc, Sound.BLOCK_GLASS_BREAK, 1.0f, 1.0f);
        for (Entity entity : loc.getWorld().getNearbyEntities(loc, 5.0, 5.0, 5.0)) {
            if (!(entity instanceof LivingEntity) || entity instanceof Zombie) continue;
            ((LivingEntity)entity).damage(shatterDamage);
            ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 100, 1));
        }
    }

    private void handleInfernoDeath(Zombie zombie) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.inferno");
        boolean meltdownEnabled = cfg.getBoolean("meltdown_enabled", true);
        if (meltdownEnabled) {
            Location loc = zombie.getLocation();
            loc.getBlock().setType(Material.LAVA);
            loc.clone().subtract(0.0, 1.0, 0.0).getBlock().setType(Material.LAVA);
        }
    }

    @EventHandler
    public void onZombieDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof Zombie) {
            List<ItemStack> drops;
            String type;
            Zombie zombie = (Zombie)event.getEntity();
            String chunkKey = zombie.getLocation().getChunk().getX() + "," + zombie.getLocation().getChunk().getZ();
            this.zombieChunkCount.put(chunkKey, this.zombieChunkCount.getOrDefault(chunkKey, 1) - 1);
            String zombieType = (String)zombie.getPersistentDataContainer().get(this.zombieTypeKey, PersistentDataType.STRING);
            if (zombieType != null) {
                switch (zombieType) {
                    case "burster": {
                        this.handleBursterDeath(zombie);
                        break;
                    }
                    case "cryo": {
                        this.handleCryoDeath(zombie);
                        break;
                    }
                    case "inferno": {
                        this.handleInfernoDeath(zombie);
                        break;
                    }
                    case "leech": {
                        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.leech");
                        double healAmount = cfg.getDouble("death_heal_amount", 10.0);
                        double healRadius = cfg.getDouble("death_heal_radius", 8.0);
                        for (Entity entity : zombie.getNearbyEntities(healRadius, healRadius, healRadius)) {
                            if (!(entity instanceof Zombie)) continue;
                            Zombie nearbyZombie = (Zombie)entity;
                            double currentHealth = nearbyZombie.getHealth();
                            double maxHealth = nearbyZombie.getAttribute(Attribute.MAX_HEALTH).getValue();
                            nearbyZombie.setHealth(Math.min(maxHealth, currentHealth + healAmount));
                        }
                        break;
                    }
                }
            }
            if ((type = (String)zombie.getPersistentDataContainer().get(this.zombieTypeKey, PersistentDataType.STRING)) != null && this.mutationLootDrops.containsKey(type) && (drops = this.mutationLootDrops.get(type)) != null) {
                for (ItemStack item : drops) {
                    event.getDrops().add(item.clone());
                }
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Zombie && event.getEntity() instanceof Player) {
            Zombie zombie = (Zombie)event.getDamager();
            Player player = (Player)event.getEntity();
            String zombieType = (String)zombie.getPersistentDataContainer().get(this.zombieTypeKey, PersistentDataType.STRING);
            if (zombieType != null) {
                if (zombieType.equals("cryo")) {
                    ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.cryo");
                    double flashFreezeChance = cfg.getDouble("flash_freeze_chance", 25.0);
                    if (this.random.nextDouble() * 100.0 < flashFreezeChance) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 40, 4));
                    }
                } else if (zombieType.equals("leech")) {
                    ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.leech");
                    double healMultiplier = cfg.getDouble("leech_on_hit_heal_multiplier", 0.5);
                    double damage = event.getDamage();
                    double currentHealth = zombie.getHealth();
                    double maxHealth = zombie.getAttribute(Attribute.MAX_HEALTH).getValue();
                    zombie.setHealth(Math.min(maxHealth, currentHealth + damage * healMultiplier));
                }
            }
        }
    }

    private void updateZombieAI(Zombie zombie) {
        long now;
        Map<UUID, Long> memory;
        Player target = this.findPriorityTarget(zombie);
        if (target == null && (memory = this.zombieTargetMemory.get(zombie.getUniqueId())) != null) {
            now = System.currentTimeMillis();
            UUID rememberedPlayerUUID = null;
            long closestExpiry = Long.MIN_VALUE;
            for (Map.Entry<UUID, Long> entry : memory.entrySet()) {
                if (entry.getValue() <= now || entry.getValue() <= closestExpiry) continue;
                closestExpiry = entry.getValue();
                rememberedPlayerUUID = entry.getKey();
            }
            if (rememberedPlayerUUID != null) {
                Player rememberedPlayer = Bukkit.getPlayer(rememberedPlayerUUID);
                if (rememberedPlayer != null && rememberedPlayer.isOnline() && !this.infected.isPlayerFullyInfected(rememberedPlayer)) {
                    target = rememberedPlayer;
                } else {
                    memory.remove(rememberedPlayerUUID);
                }
            }
        }
        if (target != null) {
            if (this.infected.isPlayerFullyInfected(target)) {
                zombie.setTarget(null);
                return;
            }
            if (zombie.getTarget() == null || !zombie.getTarget().equals((Object)target)) {
                zombie.setTarget((LivingEntity)target);
            }
            this.zombieTargetMemory.computeIfAbsent(zombie.getUniqueId(), k -> new HashMap()).put(target.getUniqueId(), System.currentTimeMillis() + this.memoryDurationMs);
            String zombieType = (String)zombie.getPersistentDataContainer().get(this.zombieTypeKey, PersistentDataType.STRING);
            if (zombieType != null) {
                switch (zombieType) {
                    case "spitter": {
                        this.handleSpitterAbility(zombie, target);
                        break;
                    }
                    case "burster": {
                        this.handleBursterAbility(zombie, target);
                        break;
                    }
                    case "shrieker": {
                        this.handleShriekerAbility(zombie, target);
                        break;
                    }
                    case "inferno": {
                        this.handleInfernoAbility(zombie, target);
                    }
                }
            }
            this.aggroNearbyZombies(zombie, target, this.packRadius);
            this.handleLeaderFollow(zombie, target);
            if (this.breakingEnabled) {
                this.handleBlockBreaking(zombie, target);
            }
        } else {
            String leaderUUIDStr;
            zombie.setTarget(null);
            memory = this.zombieTargetMemory.get(zombie.getUniqueId());
            if (memory != null) {
                now = System.currentTimeMillis();
                memory.entrySet().removeIf(e -> (Long)e.getValue() < now);
                if (memory.isEmpty()) {
                    this.zombieTargetMemory.remove(zombie.getUniqueId());
                }
            }
            if (zombie.getPersistentDataContainer().has(this.followLeaderKey, PersistentDataType.STRING) && (leaderUUIDStr = (String)zombie.getPersistentDataContainer().get(this.followLeaderKey, PersistentDataType.STRING)) != null) {
                try {
                    UUID leaderUUID = UUID.fromString(leaderUUIDStr);
                    Entity leader = Bukkit.getEntity((UUID)leaderUUID);
                    if (leader instanceof Zombie && leader.isValid()) {
                        zombie.getPathfinder().moveTo(leader.getLocation());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private Player findPriorityTarget(Zombie zombie) {
        Location zLoc = zombie.getLocation();
        double closestDistanceSq = 2500.0;
        Player closest = null;
        for (Player player : Bukkit.getOnlinePlayers()) {
            double distanceSq;
            if (!player.getWorld().equals((Object)zombie.getWorld()) || this.infected.isPlayerFullyInfected(player) || !((distanceSq = player.getLocation().distanceSquared(zLoc)) < closestDistanceSq)) continue;
            closestDistanceSq = distanceSq;
            closest = player;
        }
        return closest;
    }

    private void handleSpitterAbility(final Zombie spitter, Player target) {
        Location targetLoc;
        if (spitter.hasMetadata("spitter_cooldown")) {
            return;
        }
        Location spitterLoc = spitter.getLocation();
        if (spitterLoc.distance(targetLoc = target.getLocation()) <= 15.0) {
            ThrownPotion potion = (ThrownPotion)spitter.launchProjectile(ThrownPotion.class);
            potion.setItem(new ItemStack(Material.SPLASH_POTION));
            PotionMeta meta = (PotionMeta)potion.getItem().getItemMeta();
            if (meta != null) {
                meta.addCustomEffect(new PotionEffect(PotionEffectType.POISON, 100, 1), true);
                potion.getItem().setItemMeta((ItemMeta)meta);
            }
            Vector direction = targetLoc.toVector().subtract(spitterLoc.toVector()).normalize().multiply(1.2);
            potion.setVelocity(direction);
            spitter.setMetadata("spitter_cooldown", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
            new BukkitRunnable(){

                public void run() {
                    spitter.removeMetadata("spitter_cooldown", (Plugin)ZombieApocalypse999.this);
                }
            }.runTaskLater((Plugin)this, 100L);
        }
    }

    private void handleBursterAbility(Zombie burster, Player target) {
        double distance;
        if (!burster.isDead() && burster.isValid() && (distance = burster.getLocation().distance(target.getLocation())) <= 5.0) {
            burster.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 40, 1, false, false));
        }
    }

    private void handleShriekerAbility(final Zombie shrieker, Player target) {
        if (shrieker.hasMetadata("shrieker_cooldown")) {
            return;
        }
        shrieker.getWorld().playSound(shrieker.getLocation(), Sound.ENTITY_GHAST_SCREAM, 2.0f, 0.5f);
        shrieker.getWorld().spawnParticle(Particle.SONIC_BOOM, shrieker.getLocation(), 1);
        this.aggroNearbyZombies(shrieker, target, 50);
        shrieker.setMetadata("shrieker_cooldown", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
        new BukkitRunnable(){

            public void run() {
                shrieker.removeMetadata("shrieker_cooldown", (Plugin)ZombieApocalypse999.this);
            }
        }.runTaskLater((Plugin)this, 200L);
    }

    private void handleInfernoAbility(final Zombie zombie, Player target) {
        Location targetLoc;
        if (zombie.hasMetadata("inferno_cooldown")) {
            return;
        }
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.inferno");
        int fireballCooldown = cfg.getInt("fireball_cooldown", 5);
        Location zombieLoc = zombie.getLocation();
        if (zombieLoc.distance(targetLoc = target.getLocation()) <= 20.0) {
            zombie.launchProjectile(SmallFireball.class, targetLoc.toVector().subtract(zombieLoc.toVector()).normalize());
            zombie.setMetadata("inferno_cooldown", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
            new BukkitRunnable(){

                public void run() {
                    zombie.removeMetadata("inferno_cooldown", (Plugin)ZombieApocalypse999.this);
                }
            }.runTaskLater((Plugin)this, (long)(fireballCooldown * 20));
        }
    }

    private void aggroNearbyZombies(Zombie sourceZombie, Player target, int radius) {
        if (target == null) {
            return;
        }
        Location loc = sourceZombie.getLocation();
        for (Entity entity : loc.getWorld().getNearbyEntities(loc, (double)radius, (double)radius, (double)radius)) {
            Zombie z;
            if (!(entity instanceof Zombie) || (z = (Zombie)entity).getTarget() != null && z.getTarget().equals((Object)target)) continue;
            z.setTarget((LivingEntity)target);
            this.zombieTargetMemory.computeIfAbsent(z.getUniqueId(), k -> new HashMap()).put(target.getUniqueId(), System.currentTimeMillis() + this.memoryDurationMs);
        }
    }

    private void handleLeaderFollow(Zombie zombie, Player target) {
        String leaderUUIDStr;
        if (zombie.getPersistentDataContainer().has(this.leaderKey, PersistentDataType.INTEGER)) {
            return;
        }
        if (zombie.getPersistentDataContainer().has(this.followLeaderKey, PersistentDataType.STRING) && (leaderUUIDStr = (String)zombie.getPersistentDataContainer().get(this.followLeaderKey, PersistentDataType.STRING)) != null) {
            try {
                UUID leaderUUID = UUID.fromString(leaderUUIDStr);
                Entity leader = Bukkit.getEntity((UUID)leaderUUID);
                if (leader instanceof Zombie && leader.isValid()) {
                    Zombie leaderZombie = (Zombie)leader;
                    if (leaderZombie.getTarget() != null) {
                        if (zombie.getTarget() == null || !zombie.getTarget().equals((Object)leaderZombie.getTarget())) {
                            zombie.setTarget(leaderZombie.getTarget());
                        }
                    } else if (zombie.getLocation().distance(leader.getLocation()) > (double)this.followRadius) {
                        zombie.getPathfinder().moveTo(leader.getLocation());
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void handleBlockBreaking(Zombie zombie, Player target) {
        Location targetLoc;
        if (!this.whitelistedWorlds.isEmpty() && !this.whitelistedWorlds.contains(zombie.getWorld().getName())) {
            return;
        }
        if (target == null || !target.isOnline()) {
            return;
        }
        if (!this.breakingEnabled) {
            return;
        }
        if (zombie.getPersistentDataContainer().has(this.breakingCooldownKey, PersistentDataType.LONG)) {
            long cooldownEnd = (Long)zombie.getPersistentDataContainer().get(this.breakingCooldownKey, PersistentDataType.LONG);
            if (System.currentTimeMillis() < cooldownEnd) {
                return;
            }
        }
        if (!zombie.getWorld().equals((Object)target.getWorld())) {
            return;
        }
        Location zombieLoc = zombie.getLocation();
        if (zombieLoc.distance(targetLoc = target.getLocation()) > (double)this.breakingRadius) {
            return;
        }
        Vector direction = targetLoc.toVector().subtract(zombieLoc.toVector()).normalize();
        Location checkLoc = zombieLoc.clone().add(direction);
        for (int i = 0; i <= 2; ++i) {
            final Location blockLoc = checkLoc.clone().add(direction.clone().multiply(i));
            blockLoc.setY((double)zombieLoc.getBlockY());
            Material blockType = blockLoc.getBlock().getType();
            if (!this.breakableBlocks.contains(blockType)) continue;
            zombie.getWorld().playSound(blockLoc, Sound.BLOCK_WOOD_BREAK, 1.0f, 1.0f);
            this.showZombieBlockDamage(zombie, blockLoc, 0.5f);
            final int blockCooldownTicks = this.breakableBlocksCooldown.getOrDefault(blockType, this.defaultBreakingCooldownTicks);
            new BukkitRunnable(){
                int ticksPassed = 0;

                public void run() {
                    if (this.ticksPassed >= blockCooldownTicks) {
                        blockLoc.getBlock().breakNaturally();
                        this.cancel();
                    } else {
                        ++this.ticksPassed;
                    }
                }
            }.runTaskTimer((Plugin)this, 0L, 1L);
            zombie.getPersistentDataContainer().set(this.breakingCooldownKey, PersistentDataType.LONG, (Object)(System.currentTimeMillis() + (long)blockCooldownTicks * 50L));
            break;
        }
    }

    @EventHandler
    public void onCreatureTarget(EntityTargetEvent event) {
        Creature creature;
        Player player;
        if (!this.infected.isInfectionEnabled()) {
            return;
        }
        Entity target = event.getTarget();
        Entity entity = event.getEntity();
        if (target instanceof Player && this.infected.isPlayerFullyInfected(player = (Player)target) && entity instanceof Creature && ((creature = (Creature)entity).getType() == EntityType.VILLAGER || creature.getType() == EntityType.COW || creature.getType() == EntityType.SHEEP)) {
            event.setCancelled(true);
        }
    }

    public void stopBloodMoon() {
        this.isBloodMoon = false;
        this.currentMutationRate = this.getConfig().getDouble(BASE_MUTATION, 10.0);
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GREEN) + "\u2726 Blood Moon has ended \u2726"));
        Bukkit.getOnlinePlayers().forEach(p -> p.playSound(p.getLocation(), Sound.ENTITY_ENDER_DRAGON_DEATH, 1.5f, 0.7f));
    }

    void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Zombie Apocalypse Commands:");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/za reload " + String.valueOf(ChatColor.GRAY) + "- Reload config");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/za info " + String.valueOf(ChatColor.GRAY) + "- Show current status");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/za spawn <type> " + String.valueOf(ChatColor.GRAY) + "- Spawn a zombie");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/za killzombies " + String.valueOf(ChatColor.GRAY) + "- Kills all custom zombies");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/za forcebloodmoon " + String.valueOf(ChatColor.GRAY) + "- Force blood moon");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/za forcestopbloodmoon " + String.valueOf(ChatColor.GRAY) + "- Deactivate blood moon");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Available types: normal, tank, charger, assassin, blight, burster, spitter, frost, shrieker, cryo, inferno");
    }

    void sendStatusInfo(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2726 Zombie Apocalypse Status \u2726");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current Day: " + String.valueOf(ChatColor.WHITE) + this.currentDay);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Mutation Rate: " + String.valueOf(ChatColor.WHITE) + this.currentMutationRate + "%");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Blood Moon: " + (this.isBloodMoon ? String.valueOf(ChatColor.DARK_RED) + "ACTIVE" : String.valueOf(ChatColor.GREEN) + "inactive"));
        int totalZombies = 0;
        HashMap<String, Integer> typeCounts = new HashMap<String, Integer>();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Zombie)) continue;
                ++totalZombies;
                String type = (String)((Zombie)entity).getPersistentDataContainer().get(this.zombieTypeKey, PersistentDataType.STRING);
                if (type != null) {
                    typeCounts.put(type, typeCounts.getOrDefault(type, 0) + 1);
                    continue;
                }
                typeCounts.put("normal", typeCounts.getOrDefault("normal", 0) + 1);
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Active Zombies: " + String.valueOf(ChatColor.WHITE) + totalZombies);
        for (Map.Entry entry : typeCounts.entrySet()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  " + (String)entry.getKey() + ": " + String.valueOf(ChatColor.WHITE) + String.valueOf(entry.getValue()));
        }
    }

    public void handleZombieSpawn(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Specify type: normal, tank, charger, assassin, blight, burster, spitter, frost, shrieker, cryo, inferno");
            return;
        }
        if (!this.canSpawnZombiesAt(player.getWorld(), player.getLocation())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Zombies cannot be spawned at this time or location due to plugin configuration.");
            return;
        }
        String type = args[1].toLowerCase();
        double speed = this.getConfig().getDouble(BASE_SPEED) * (1.0 + 0.05 * (double)this.currentDay);
        double damage = this.getConfig().getDouble(BASE_DAMAGE) * (1.0 + 0.05 * (double)this.currentDay);
        Zombie zombie = (Zombie)player.getWorld().spawnEntity(player.getLocation().add(3.0, 0.0, 3.0), EntityType.ZOMBIE);
        zombie.setCanPickupItems(false);
        switch (type) {
            case "tank": {
                this.createTank(zombie, speed, damage);
                break;
            }
            case "charger": {
                this.createCharger(zombie, speed, damage);
                break;
            }
            case "assassin": {
                this.createAssassin(zombie, damage);
                break;
            }
            case "blight": {
                this.createBlightZombie(zombie, damage);
                break;
            }
            case "burster": {
                this.createBurster(zombie, speed, damage);
                break;
            }
            case "spitter": {
                this.createSpitter(zombie, speed, damage);
                break;
            }
            case "frost": {
                this.createFrostZombie(zombie, damage);
                break;
            }
            case "shrieker": {
                this.createShrieker(zombie, speed);
                break;
            }
            case "cryo": {
                this.createCryoZombie(zombie, speed, damage);
                break;
            }
            case "inferno": {
                this.createInfernoZombie(zombie, speed, damage);
                break;
            }
            default: {
                this.setupNormalZombie(zombie);
            }
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Spawned " + type + " zombie!");
        player.playSound(player.getLocation(), Sound.ENTITY_ZOMBIE_AMBIENT, 1.0f, 0.8f);
    }

    public void killCustomZombies() {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Zombie) || !entity.getPersistentDataContainer().has(this.zombieTypeKey, PersistentDataType.STRING)) continue;
                entity.remove();
            }
        }
    }

    public NamespacedKey getNamespacedKey(String keyName) {
        return new NamespacedKey((Plugin)this, keyName);
    }

    private void showZombieBlockDamage(Zombie zombie, Location blockLoc, float progress) {
        float clamped = Math.max(0.0f, Math.min(progress, 1.0f));
        try {
            for (Player viewer : zombie.getWorld().getPlayers()) {
                if (!(viewer.getLocation().distanceSquared(blockLoc) < 400.0)) continue;
                viewer.sendBlockDamage(blockLoc, clamped);
            }
        }
        catch (NoSuchMethodError e) {
            zombie.getWorld().playSound(blockLoc, Sound.BLOCK_WOOD_HIT, 1.0f, 1.0f);
            zombie.getWorld().spawnParticle(Particle.BLOCK_CRUMBLE, blockLoc.clone().add(0.5, 0.5, 0.5), 10, 0.3, 0.3, 0.3, (Object)blockLoc.getBlock().getBlockData());
        }
    }

    private class SunlightProtectionListener
    implements Listener {
        private SunlightProtectionListener() {
        }

        @EventHandler
        public void onEntityCombust(EntityCombustEvent event) {
            if (event.getEntityType() == EntityType.ZOMBIE && !(event instanceof EntityCombustByBlockEvent) && !(event instanceof EntityCombustByEntityEvent)) {
                event.setCancelled(true);
            }
        }
    }

    private class NoiseLightListener
    implements Listener {
        private NoiseLightListener() {
        }

        private void aggroNearbyZombies(Player player, int range) {
            Location loc = player.getLocation();
            for (Entity entity : loc.getWorld().getNearbyEntities(loc, (double)range, (double)range, (double)range)) {
                Zombie zombie;
                if (!(entity instanceof Zombie) || (zombie = (Zombie)entity).getTarget() != null && zombie.getTarget().equals((Object)player)) continue;
                zombie.setTarget((LivingEntity)player);
                ZombieApocalypse999.this.zombieTargetMemory.computeIfAbsent(zombie.getUniqueId(), k -> new HashMap()).put(player.getUniqueId(), System.currentTimeMillis() + ZombieApocalypse999.this.memoryDurationMs);
            }
        }

        @EventHandler
        public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
            if (event.isSprinting()) {
                this.aggroNearbyZombies(event.getPlayer(), ZombieApocalypse999.this.sprintNoiseRange);
            }
        }

        @EventHandler
        public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
            this.aggroNearbyZombies(event.getPlayer(), ZombieApocalypse999.this.eatingNoiseRange);
        }

        @EventHandler
        public void onEntityShootBow(EntityShootBowEvent event) {
            if (event.getEntity() instanceof Player) {
                this.aggroNearbyZombies((Player)event.getEntity(), ZombieApocalypse999.this.bowNoiseRange);
            }
        }

        @EventHandler
        public void onBlockPlace(BlockPlaceEvent event) {
            Material placed = event.getBlockPlaced().getType();
            if (placed == Material.TORCH || placed == Material.LANTERN || placed == Material.SOUL_TORCH || placed == Material.SOUL_LANTERN || placed == Material.FIRE) {
                this.aggroNearbyZombies(event.getPlayer(), ZombieApocalypse999.this.torchNoiseRange);
            }
        }
    }
}

