/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.zombieapocalypse999;

import com.yourname.zombieapocalypse999.ZombieApocalypse999;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Infected
implements Listener {
    private final ZombieApocalypse999 plugin;
    private final NamespacedKey infectedKey;
    private final NamespacedKey infectedMutationKey;
    private final NamespacedKey infectedKillerKey;
    private boolean infectionEnabled;
    private double infectionChanceOnHit;
    private double infectionIncreasePercent;
    private double maxInfectionPercent;
    private boolean showInfectionBar;
    private boolean allowGoldenAppleCure;
    private double goldenAppleCurePercent;
    private double enchantedGoldenAppleCurePercent;
    private File playersFile;
    private YamlConfiguration playersConfig;
    private final Map<UUID, Double> infectionMap = new HashMap<UUID, Double>();
    private final Map<UUID, BossBar> infectionBossBars = new HashMap<UUID, BossBar>();
    private final Random random = new Random();

    public Infected(ZombieApocalypse999 plugin) {
        this.plugin = plugin;
        this.infectedKey = plugin.getNamespacedKey("infected");
        this.infectedMutationKey = plugin.getNamespacedKey("infected_mutation");
        this.infectedKillerKey = plugin.getNamespacedKey("infected_killer");
    }

    public void loadInfectionConfig() {
        FileConfiguration cfg = this.plugin.getConfig();
        this.infectionEnabled = cfg.getBoolean("infection_system.enabled", true);
        this.infectionChanceOnHit = cfg.getDouble("infection_system.chance_on_hit", 5.0);
        this.infectionIncreasePercent = cfg.getDouble("infection_system.infection_increase", 10.0);
        this.maxInfectionPercent = cfg.getDouble("infection_system.max_infection", 100.0);
        this.showInfectionBar = cfg.getBoolean("infection_system.show_infection_bar", true);
        this.allowGoldenAppleCure = cfg.getBoolean("infection_system.allow_golden_apple_cure", true);
        this.goldenAppleCurePercent = cfg.getDouble("infection_system.golden_apple_cure_percent", 20.0);
        this.enchantedGoldenAppleCurePercent = cfg.getDouble("infection_system.enchanted_golden_apple_cure_percent", 50.0);
    }

    public void loadPlayersData() {
        this.playersFile = new File(this.plugin.getDataFolder(), "players.yml");
        if (!this.playersFile.exists()) {
            this.playersFile.getParentFile().mkdirs();
            this.plugin.saveResource("players.yml", false);
        }
        this.playersConfig = YamlConfiguration.loadConfiguration((File)this.playersFile);
    }

    public void savePlayersData() {
        for (UUID uuid : this.infectionMap.keySet()) {
            double infection = this.infectionMap.get(uuid);
            this.playersConfig.set(uuid.toString() + ".infection", (Object)infection);
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null || !this.isPlayerFullyInfected(p)) continue;
            String mutation = (String)p.getPersistentDataContainer().get(this.infectedMutationKey, PersistentDataType.STRING);
            this.playersConfig.set(uuid.toString() + ".mutation", (Object)mutation);
        }
        try {
            this.playersConfig.save(this.playersFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save players.yml: " + e.getMessage());
        }
    }

    public void restoreInfectedPlayers() {
        for (String key : this.playersConfig.getKeys(false)) {
            UUID uuid;
            try {
                uuid = UUID.fromString(key);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            double infection = this.playersConfig.getDouble(key + ".infection", 0.0);
            if (infection >= this.maxInfectionPercent) {
                infection = this.maxInfectionPercent;
            }
            this.infectionMap.put(uuid, infection);
            String mutation = this.playersConfig.getString(key + ".mutation", null);
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null || !(infection >= this.maxInfectionPercent) || mutation == null) continue;
            this.applyMutationToPlayer(p, mutation);
            this.setupInfectedPlayerVisuals(p, mutation);
            this.setupInfectionBossBar(p);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!this.infectionEnabled) {
            return;
        }
        if (event.getDamager() instanceof Zombie && event.getEntity() instanceof Player) {
            String zombieType;
            Zombie zombie = (Zombie)event.getDamager();
            Player player = (Player)event.getEntity();
            if (this.isPlayerFullyInfected(player)) {
                event.setCancelled(true);
                return;
            }
            if (this.random.nextDouble() * 100.0 < this.infectionChanceOnHit) {
                this.increasePlayerInfection(player, this.infectionIncreasePercent);
            }
            if ((zombieType = (String)zombie.getPersistentDataContainer().get(this.plugin.zombieTypeKey, PersistentDataType.STRING)) != null) {
                switch (zombieType) {
                    case "blight": {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 100, 1));
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You've been infected with blight!");
                        break;
                    }
                    case "frost": {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 100, 1));
                        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 100, 1));
                        player.sendMessage(String.valueOf(ChatColor.AQUA) + "You feel chilled to the bone!");
                    }
                }
            }
        }
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (!this.infectionEnabled) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.infectionMap.containsKey(player.getUniqueId())) {
            return;
        }
        ItemStack item = event.getItem();
        if (!this.allowGoldenAppleCure) {
            return;
        }
        switch (item.getType()) {
            case GOLDEN_APPLE: {
                if (this.isPlayerFullyInfected(player)) break;
                this.decreasePlayerInfection(player, this.goldenAppleCurePercent);
                break;
            }
            case ENCHANTED_GOLDEN_APPLE: {
                if (this.isPlayerFullyInfected(player)) break;
                this.decreasePlayerInfection(player, this.enchantedGoldenAppleCurePercent);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.infectionEnabled) {
            return;
        }
        if (this.infectionMap.containsKey(player.getUniqueId())) {
            this.setupInfectionBossBar(player);
            this.updateInfectionBossBar(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.removeInfectionBossBar(player);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!this.infectionEnabled) {
            return;
        }
        if (this.infectionMap.containsKey(player.getUniqueId())) {
            this.setupInfectionBossBar(player);
            this.updateInfectionBossBar(player);
        }
    }

    @EventHandler
    public void onEntityDeathInfectionSpread(EntityDeathEvent event) {
        if (!this.infectionEnabled) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Player dead = (Player)event.getEntity();
            Player killerEntity = dead.getKiller();
            if (killerEntity == null) {
                return;
            }
            if (killerEntity instanceof Player) {
                Player killer = killerEntity;
                if (this.isPlayerInfected(killer)) {
                    dead.getPersistentDataContainer().set(this.infectedKillerKey, PersistentDataType.STRING, (Object)killer.getUniqueId().toString());
                    this.infectPlayer(dead);
                    double maxHealth = killer.getAttribute(Attribute.MAX_HEALTH).getBaseValue();
                    killer.getAttribute(Attribute.MAX_HEALTH).setBaseValue(maxHealth + 2.0);
                    killer.setHealth(Math.min(killer.getHealth() + 2.0, killer.getAttribute(Attribute.MAX_HEALTH).getBaseValue()));
                    killer.sendMessage(String.valueOf(ChatColor.GREEN) + "You gained +1 max heart for infecting a player!");
                }
            } else if (killerEntity instanceof Zombie) {
                dead.getPersistentDataContainer().remove(this.infectedKillerKey);
                this.infectPlayer(dead);
            }
        }
    }

    public void increasePlayerInfection(Player player, double amount) {
        UUID uuid = player.getUniqueId();
        double current = this.infectionMap.getOrDefault(uuid, 0.0);
        if (current >= this.maxInfectionPercent) {
            return;
        }
        if ((current += amount) > this.maxInfectionPercent) {
            current = this.maxInfectionPercent;
        }
        this.infectionMap.put(uuid, current);
        this.updateInfectionBossBar(player);
        if (current >= this.maxInfectionPercent) {
            this.infectPlayer(player);
        }
    }

    public void decreasePlayerInfection(Player player, double amount) {
        UUID uuid = player.getUniqueId();
        double current = this.infectionMap.getOrDefault(uuid, 0.0);
        if (current >= this.maxInfectionPercent) {
            return;
        }
        if ((current -= amount) < 0.0) {
            current = 0.0;
        }
        this.infectionMap.put(uuid, current);
        this.updateInfectionBossBar(player);
    }

    public void infectPlayer(Player player) {
        UUID uuid = player.getUniqueId();
        this.infectionMap.put(uuid, this.maxInfectionPercent);
        String mutation = this.getRandomMutationType();
        this.applyMutationToPlayer(player, mutation);
        this.setupInfectedPlayerVisuals(player, mutation);
        player.sendTitle(String.valueOf(ChatColor.RED) + "You are now a zombie!", String.valueOf(ChatColor.GRAY) + "Your mutation is " + mutation.toUpperCase() + ". Hunt down players to get stronger!", 10, 70, 20);
        this.setupInfectionBossBar(player);
        this.updateInfectionBossBar(player);
        this.playersConfig.set(uuid.toString() + ".infection", (Object)this.maxInfectionPercent);
        this.playersConfig.set(uuid.toString() + ".mutation", (Object)mutation);
        try {
            this.playersConfig.save(this.playersFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save players.yml: " + e.getMessage());
        }
    }

    private String getRandomMutationType() {
        ConfigurationSection mutations = this.plugin.getConfig().getConfigurationSection("mutation_types");
        if (mutations == null) {
            return "tank";
        }
        ArrayList keys = new ArrayList(mutations.getKeys(false));
        if (keys.isEmpty()) {
            return "tank";
        }
        return (String)keys.get(this.random.nextInt(keys.size()));
    }

    public void applyMutationToPlayer(Player player, String mutation) {
        player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
        switch (mutation.toLowerCase()) {
            case "tank": {
                player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(40.0);
                player.setHealth(40.0);
                player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, Integer.MAX_VALUE, 1, false, false));
                break;
            }
            case "charger": {
                player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(20.0);
                player.setHealth(20.0);
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, false, false));
                break;
            }
            case "assassin": {
                player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(8.0);
                player.setHealth(8.0);
                player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false));
                break;
            }
            case "blight": {
                player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(20.0);
                player.setHealth(20.0);
                player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, Integer.MAX_VALUE, 1, false, false));
                break;
            }
            case "burster": {
                player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(10.0);
                player.setHealth(10.0);
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, false, false));
                break;
            }
            case "spitter": {
                player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(16.0);
                player.setHealth(16.0);
                break;
            }
            case "frost": {
                player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(20.0);
                player.setHealth(20.0);
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 1, false, false));
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 1, false, false));
                break;
            }
            default: {
                player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(20.0);
                player.setHealth(20.0);
            }
        }
        player.getPersistentDataContainer().set(this.infectedMutationKey, PersistentDataType.STRING, (Object)mutation.toLowerCase());
        player.getPersistentDataContainer().set(this.infectedKey, PersistentDataType.INTEGER, (Object)1);
    }

    public void setupInfectedPlayerVisuals(Player player, String mutation) {
        player.setCustomName(String.valueOf(ChatColor.DARK_RED) + "(Infected " + player.getName() + ")");
        player.setCustomNameVisible(true);
        player.setMetadata("infected_player", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
    }

    public boolean isPlayerInfected(Player player) {
        return this.infectionMap.getOrDefault(player.getUniqueId(), 0.0) >= 1.0;
    }

    public boolean isPlayerFullyInfected(Player player) {
        return this.infectionMap.getOrDefault(player.getUniqueId(), 0.0) >= this.maxInfectionPercent;
    }

    public void setupInfectionBossBar(Player player) {
        if (!this.showInfectionBar) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (this.infectionBossBars.containsKey(uuid)) {
            return;
        }
        BossBar bar = Bukkit.createBossBar((String)(String.valueOf(ChatColor.RED) + "Infection: 0%"), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        bar.addPlayer(player);
        this.infectionBossBars.put(uuid, bar);
    }

    public void updateInfectionBossBar(Player player) {
        double infection;
        double progress;
        if (!this.showInfectionBar) {
            return;
        }
        UUID uuid = player.getUniqueId();
        BossBar bar = this.infectionBossBars.get(uuid);
        if (bar == null) {
            this.setupInfectionBossBar(player);
            bar = this.infectionBossBars.get(uuid);
        }
        if ((progress = (infection = this.infectionMap.getOrDefault(uuid, 0.0).doubleValue()) / this.maxInfectionPercent) > 1.0) {
            progress = 1.0;
        }
        bar.setProgress(progress);
        bar.setTitle(String.valueOf(ChatColor.RED) + "Infection: " + (int)infection + "% / " + (int)this.maxInfectionPercent + "%");
        if (infection >= this.maxInfectionPercent) {
            bar.setColor(BarColor.PURPLE);
        } else {
            bar.setColor(BarColor.RED);
        }
    }

    public void removeInfectionBossBar(Player player) {
        UUID uuid = player.getUniqueId();
        BossBar bar = this.infectionBossBars.remove(uuid);
        if (bar != null) {
            bar.removeAll();
        }
    }

    public boolean isInfectionEnabled() {
        return this.infectionEnabled;
    }
}

