/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.zombieapocalypse999;

import com.yourname.zombieapocalypse999.CommandHandler;
import com.yourname.zombieapocalypse999.Infected;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ZombieApocalypse999
extends JavaPlugin
implements Listener {
    private static final String BASE_SPEED = "zombie_stats.base_speed";
    private static final String BASE_DAMAGE = "zombie_stats.base_damage";
    private static final String BASE_MUTATION = "mutation_rates.base";
    private static final String MUTATION_INCREASE = "mutation_rates.daily_increase";
    private static final String SPAWN_TIME_MODE = "spawning.spawn_time_mode";
    private static final int TICKS_PER_DAY = 24000;
    private static final int SENSOR_RANGE = 50;
    private static final int BLOOD_MOON_FREQUENCY = 5;
    private static final int LEADER_CHANCE = 20;
    private static final int LEADER_RADIUS = 10;
    private static final int MEMORY_DURATION_TICKS = 200;
    private static final int OBSTACLE_BREAK_DELAY_TICKS = 20;
    public final NamespacedKey zombieTypeKey = new NamespacedKey((Plugin)this, "zombie_type");
    public final NamespacedKey mutationDayKey = new NamespacedKey((Plugin)this, "mutation_day");
    public final NamespacedKey leaderKey = new NamespacedKey((Plugin)this, "zombie_leader");
    public final NamespacedKey infectedKey = new NamespacedKey((Plugin)this, "infected");
    private int currentDay = 0;
    private double currentMutationRate;
    private boolean isBloodMoon = false;
    private final Map<String, Integer> zombieChunkCount = new HashMap<String, Integer>();
    private final Random random = new Random();
    private boolean showMutationNamesAboveZombies;
    private Map<String, List<ItemStack>> mutationLootDrops = new HashMap<String, List<ItemStack>>();
    private Infected infected;
    private CommandHandler commandHandler;
    private String spawnTimeMode = "both";
    private final Map<UUID, PlayerMemory> zombieMemory = new HashMap<UUID, PlayerMemory>();
    private File locationsFile;
    private YamlConfiguration locationsConfig;
    private final Map<UUID, Long> lastFlankNudge = new HashMap<UUID, Long>();
    private final Map<UUID, Long> stuckCheckTimestamps = new HashMap<UUID, Long>();
    private final Map<UUID, Location> lastPositions = new HashMap<UUID, Location>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.loadMutationConfig();
        this.loadLootDropsConfig();
        this.loadSpawnTimeModeConfig();
        this.locationsFile = new File(this.getDataFolder(), "locations.yml");
        if (!this.locationsFile.exists()) {
            this.locationsFile.getParentFile().mkdirs();
            this.saveResource("locations.yml", false);
        }
        this.locationsConfig = YamlConfiguration.loadConfiguration((File)this.locationsFile);
        this.infected = new Infected(this);
        this.infected.loadInfectionConfig();
        this.infected.loadPlayersData();
        this.infected.restoreInfectedPlayers();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.infected, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SunlightProtectionListener(), (Plugin)this);
        this.startDayCycle();
        this.startSpawningSystem();
        this.startAIUpdateSystem();
        this.currentMutationRate = this.getConfig().getDouble(BASE_MUTATION, 10.0);
        this.currentDay = this.getConfig().getInt("data.current_day", 0);
        this.commandHandler = new CommandHandler(this, this.infected);
        this.getLogger().info("Zombie Apocalypse 999 initialized! Day " + this.currentDay + ", Spawn Time Mode: " + this.spawnTimeMode);
    }

    public void onDisable() {
        this.getConfig().set("data.current_day", (Object)this.currentDay);
        this.saveConfig();
        this.infected.savePlayersData();
        try {
            this.locationsConfig.save(this.locationsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save locations.yml: " + e.getMessage());
        }
        this.getLogger().info("Zombie Apocalypse shut down safely.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.commandHandler.onCommand(sender, command, label, args);
    }

    public void loadMutationConfig() {
        FileConfiguration cfg = this.getConfig();
        this.showMutationNamesAboveZombies = cfg.getBoolean("mutation_system.show_mutation_names_above_zombies", true);
    }

    public void loadLootDropsConfig() {
        this.mutationLootDrops.clear();
        ConfigurationSection lootSection = this.getConfig().getConfigurationSection("loot_drops");
        if (lootSection == null) {
            return;
        }
        for (String mutationType : lootSection.getKeys(false)) {
            boolean enabled;
            ConfigurationSection typeSection = lootSection.getConfigurationSection(mutationType);
            if (typeSection == null || !(enabled = typeSection.getBoolean("enabled", true))) continue;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            List itemNames = typeSection.getStringList("items");
            for (String itemName : itemNames) {
                Material mat = Material.getMaterial((String)itemName.toUpperCase());
                if (mat != null) {
                    items.add(new ItemStack(mat));
                    continue;
                }
                this.getLogger().warning("Invalid material in loot_drops for " + mutationType + ": " + itemName);
            }
            this.mutationLootDrops.put(mutationType.toLowerCase(), items);
        }
    }

    public void loadSpawnTimeModeConfig() {
        FileConfiguration cfg = this.getConfig();
        String mode = cfg.getString(SPAWN_TIME_MODE, "both").toLowerCase(Locale.ROOT);
        if (!(mode.equals("day") || mode.equals("night") || mode.equals("both"))) {
            this.getLogger().warning("Invalid spawn_time_mode in config: " + mode + ". Defaulting to 'both'.");
            this.spawnTimeMode = "both";
        } else {
            this.spawnTimeMode = mode;
        }
    }

    private void startDayCycle() {
        new BukkitRunnable(){

            public void run() {
                ++ZombieApocalypse999.this.currentDay;
                ZombieApocalypse999.this.currentMutationRate = ZombieApocalypse999.this.getConfig().getDouble(ZombieApocalypse999.BASE_MUTATION) + (double)ZombieApocalypse999.this.currentDay * ZombieApocalypse999.this.getConfig().getDouble(ZombieApocalypse999.MUTATION_INCREASE);
                if (ZombieApocalypse999.this.currentDay % 5 == 0) {
                    ZombieApocalypse999.this.triggerBloodMoon();
                } else {
                    ZombieApocalypse999.this.isBloodMoon = false;
                }
                ZombieApocalypse999.this.getLogger().info("Day " + ZombieApocalypse999.this.currentDay + " - Mutation: " + ZombieApocalypse999.this.currentMutationRate + "%");
            }
        }.runTaskTimer((Plugin)this, 0L, 24000L);
    }

    public void triggerBloodMoon() {
        this.isBloodMoon = true;
        this.currentMutationRate = 100.0;
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.DARK_RED) + "\u2726 BLOOD MOON RISING \u2726"));
        Bukkit.getOnlinePlayers().forEach(p -> {
            p.playSound(p.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.5f, 0.7f);
            p.spawnParticle(Particle.LAVA, p.getLocation().add(0.0, 2.0, 0.0), 50);
        });
    }

    private void startSpawningSystem() {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getOnlinePlayers().forEach(player -> {
                    if (ZombieApocalypse999.this.random.nextInt(5) < 2 && ZombieApocalypse999.this.canSpawnZombiesAt(player.getWorld().getTime())) {
                        ZombieApocalypse999.this.spawnZombieGroup((Player)player);
                    }
                });
            }
        }.runTaskTimer((Plugin)this, 0L, 100L);
    }

    private boolean canSpawnZombiesAt(long time) {
        switch (this.spawnTimeMode) {
            case "day": {
                return time >= 0L && time <= 12299L;
            }
            case "night": {
                return time >= 12300L && time <= 23999L;
            }
        }
        return true;
    }

    private void spawnZombieGroup(Player player) {
        World world = player.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return;
        }
        int minZombies = 2;
        int maxZombies = Math.min(6 + this.currentDay, 15);
        int zombieCount = this.random.nextInt(maxZombies - minZombies + 1) + minZombies;
        if (this.isBloodMoon) {
            zombieCount *= 2;
        }
        for (int i = 0; i < zombieCount; ++i) {
            Location spawnLoc = this.findSafeSpawnLocation(player.getLocation());
            if (spawnLoc == null) continue;
            Zombie zombie = (Zombie)world.spawnEntity(spawnLoc, EntityType.ZOMBIE);
            this.initializeZombie(zombie);
            this.trackChunkDensity(spawnLoc);
        }
    }

    private Location findSafeSpawnLocation(Location center) {
        for (int i = 0; i < 10; ++i) {
            Location attempt = center.clone().add((double)(this.random.nextInt(30) - 15), 0.0, (double)(this.random.nextInt(30) - 15));
            attempt.setY((double)(center.getWorld().getHighestBlockYAt(attempt) + 1));
            if (!this.isValidSpawnPoint(attempt)) continue;
            return attempt;
        }
        return null;
    }

    private boolean isValidSpawnPoint(Location loc) {
        return loc.getBlock().getType().isAir() && loc.clone().add(0.0, 1.0, 0.0).getBlock().getType().isAir() && loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().isSolid() && !loc.getBlock().isLiquid() && loc.getY() > 0.0;
    }

    private void trackChunkDensity(Location loc) {
        String chunkKey = loc.getChunk().getX() + "," + loc.getChunk().getZ();
        int count = this.zombieChunkCount.getOrDefault(chunkKey, 0) + 1;
        this.zombieChunkCount.put(chunkKey, count);
        if (count >= 20) {
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.DARK_RED) + "\u2726 MUTATION SURGE IN AREA [" + chunkKey + "] \u2726"));
        }
    }

    private void startAIUpdateSystem() {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getWorlds().forEach(world -> {
                    for (Entity entity : world.getEntities()) {
                        if (!(entity instanceof Zombie) || !entity.isValid()) continue;
                        ZombieApocalypse999.this.updateZombieAI((Zombie)entity);
                    }
                });
            }
        }.runTaskTimer((Plugin)this, 0L, 10L);
    }

    private void initializeZombie(Zombie zombie) {
        zombie.setCanPickupItems(false);
        zombie.setPersistent(true);
        double dayScale = 1.0 + 0.05 * (double)this.currentDay;
        double speed = this.getConfig().getDouble(BASE_SPEED, 0.23) * dayScale;
        double damage = this.getConfig().getDouble(BASE_DAMAGE, 2.0) * dayScale;
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, speed);
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, damage);
        if (this.random.nextInt(20) == 0) {
            zombie.getPersistentDataContainer().set(this.leaderKey, PersistentDataType.INTEGER, (Object)1);
            zombie.setCustomName(String.valueOf(ChatColor.GOLD) + "Leader Zombie");
            zombie.setCustomNameVisible(true);
        }
        if (this.random.nextDouble() * 100.0 < this.currentMutationRate || this.isBloodMoon) {
            this.applyRandomMutation(zombie, speed, damage);
        } else {
            this.setupNormalZombie(zombie);
        }
        if (this.isBloodMoon) {
            zombie.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, Integer.MAX_VALUE, 0, false, false));
        }
    }

    private void setAttribute(Zombie zombie, Attribute attribute, double value) {
        if (zombie.getAttribute(attribute) != null) {
            zombie.getAttribute(attribute).setBaseValue(value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateZombieAI(Zombie zombie) {
        block14: {
            boolean isLeader = zombie.getPersistentDataContainer().has(this.leaderKey, PersistentDataType.INTEGER);
            Player target = this.findPriorityTarget(zombie);
            if (target == null) {
                target = this.findHiveMindTarget(zombie);
            }
            if (target == null) {
                PlayerMemory memory = this.zombieMemory.get(zombie.getUniqueId());
                if (memory != null && !memory.isExpired()) {
                    this.moveZombieTowardLocation(zombie, memory.getLastKnownLocation());
                    break block14;
                } else {
                    this.wanderTowardNearbyZombies(zombie);
                    zombie.setTarget(null);
                    return;
                }
            }
            this.zombieMemory.put(zombie.getUniqueId(), new PlayerMemory(target.getLocation()));
            if (zombie.getTarget() == null || !zombie.getTarget().equals((Object)target)) {
                zombie.setTarget((LivingEntity)target);
            }
            this.simulateFlanking(zombie, target);
            String zombieType = (String)zombie.getPersistentDataContainer().get(this.zombieTypeKey, PersistentDataType.STRING);
            if (zombieType != null) {
                switch (zombieType) {
                    case "spitter": {
                        this.handleSpitterAbility(zombie, target);
                        break;
                    }
                    case "burster": {
                        this.handleBursterAbility(zombie, target);
                        break;
                    }
                }
            }
        }
        this.handleObstacleNavigation(zombie);
    }

    private Player findPriorityTarget(Zombie zombie) {
        Location zLoc = zombie.getLocation();
        double maxDistanceSq = 2500.0;
        Player bestTarget = null;
        double bestScore = Double.MAX_VALUE;
        for (Player player : Bukkit.getOnlinePlayers()) {
            double distanceSq;
            if (!player.getWorld().equals((Object)zombie.getWorld()) || this.infected.isPlayerFullyInfected(player) || (distanceSq = player.getLocation().distanceSquared(zLoc)) > maxDistanceSq) continue;
            double hp = player.getHealth();
            double armor = this.getArmorScore(player);
            boolean infectedStatus = this.infected.isPlayerInfected(player);
            double score = hp * 2.0 + armor * 5.0;
            if (infectedStatus) {
                score -= 10.0;
            }
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestTarget = player;
        }
        return bestTarget;
    }

    private Player findHiveMindTarget(Zombie zombie) {
        Location zLoc = zombie.getLocation();
        for (Entity entity : zombie.getWorld().getNearbyEntities(zLoc, 50.0, 50.0, 50.0)) {
            Player playerTarget;
            Zombie other;
            LivingEntity target;
            if (!(entity instanceof Zombie) || entity.equals((Object)zombie) || !((target = (other = (Zombie)entity).getTarget()) instanceof Player) || this.infected.isPlayerFullyInfected(playerTarget = (Player)target)) continue;
            return playerTarget;
        }
        return null;
    }

    private double getArmorScore(Player player) {
        double score = 0.0;
        for (ItemStack armor : player.getInventory().getArmorContents()) {
            if (armor == null) continue;
            score += armor.getType().getMaxDurability() > 0 ? 1.0 : 0.5;
        }
        return score;
    }

    private void moveZombieTowardLocation(Zombie zombie, Location targetLoc) {
        Location current = zombie.getLocation();
        if (current.distanceSquared(targetLoc) < 4.0) {
            this.zombieMemory.remove(zombie.getUniqueId());
            zombie.setTarget(null);
            return;
        }
        Vector direction = targetLoc.toVector().subtract(current.toVector()).normalize().multiply(0.5);
        Location newLoc = current.add(direction);
        newLoc.setYaw(current.getYaw());
        newLoc.setPitch(current.getPitch());
        zombie.teleport(newLoc);
    }

    private void simulateFlanking(Zombie zombie, Player target) {
        long now = System.currentTimeMillis();
        UUID id = zombie.getUniqueId();
        if (!this.lastFlankNudge.containsKey(id) || now - this.lastFlankNudge.get(id) > 1000L) {
            this.lastFlankNudge.put(id, now);
            Vector offset = this.getFlankOffset(zombie, target);
            Location targetLoc = target.getLocation().clone().add(offset);
            Location zombieLoc = zombie.getLocation();
            Location nudgeLoc = new Location(zombieLoc.getWorld(), targetLoc.getX(), zombieLoc.getY(), targetLoc.getZ(), zombieLoc.getYaw(), zombieLoc.getPitch());
            if (zombieLoc.distanceSquared(nudgeLoc) > 1.0) {
                zombie.teleport(nudgeLoc);
            }
        }
    }

    private void wanderTowardNearbyZombies(Zombie zombie) {
        Location loc = zombie.getLocation();
        Collection nearby = zombie.getWorld().getNearbyEntities(loc, 50.0, 50.0, 50.0);
        ArrayList<Zombie> nearbyZombies = new ArrayList<Zombie>();
        for (Object e : nearby) {
            if (!(e instanceof Zombie) || e.equals((Object)zombie)) continue;
            nearbyZombies.add((Zombie)e);
        }
        if (!nearbyZombies.isEmpty()) {
            Zombie leader = null;
            for (Zombie z : nearbyZombies) {
                if (!z.getPersistentDataContainer().has(this.leaderKey, PersistentDataType.INTEGER)) continue;
                leader = z;
                break;
            }
            if (leader != null) {
                zombie.setTarget(null);
                this.moveZombieTowardLocation(zombie, leader.getLocation());
            } else {
                double avgX = 0.0;
                double avgY = 0.0;
                double avgZ = 0.0;
                for (Zombie z : nearbyZombies) {
                    Location l = z.getLocation();
                    avgX += l.getX();
                    avgY += l.getY();
                    avgZ += l.getZ();
                }
                int count = nearbyZombies.size();
                Location avgLoc = new Location(zombie.getWorld(), avgX / (double)count, avgY / (double)count, avgZ / (double)count);
                zombie.setTarget(null);
                this.moveZombieTowardLocation(zombie, avgLoc);
            }
        } else {
            Location wanderLoc = zombie.getLocation().add((double)(this.random.nextInt(10) - 5), 0.0, (double)(this.random.nextInt(10) - 5));
            zombie.setTarget(null);
            zombie.teleport(wanderLoc);
        }
    }

    private Vector getFlankOffset(Zombie zombie, Player target) {
        int hash = zombie.getUniqueId().hashCode();
        double angle = (double)(hash % 360) * Math.PI / 180.0;
        double radius = 2.0 + (double)(hash % 3);
        double x = Math.cos(angle) * radius;
        double z = Math.sin(angle) * radius;
        return new Vector(x, 0.0, z);
    }

    private void handleObstacleNavigation(Zombie zombie) {
        UUID id = zombie.getUniqueId();
        Location currentPos = zombie.getLocation();
        Location lastPos = this.lastPositions.get(id);
        long now = System.currentTimeMillis();
        if (lastPos != null && lastPos.distanceSquared(currentPos) < 0.01) {
            Long stuckSince = this.stuckCheckTimestamps.get(id);
            if (stuckSince == null) {
                this.stuckCheckTimestamps.put(id, now);
            } else if (now - stuckSince > 1000L) {
                Location frontBlockLoc = currentPos.clone().add(zombie.getLocation().getDirection().normalize());
                Block block = frontBlockLoc.getBlock();
                if (block != null && !block.isEmpty() && !block.isLiquid()) {
                    Material mat = block.getType();
                    if (mat.getHardness() >= 0.0f && mat.getHardness() < 5.0f) {
                        block.breakNaturally();
                        this.stuckCheckTimestamps.remove(id);
                    } else {
                        Location newLoc = currentPos.clone().add((double)(this.random.nextInt(5) - 2), 0.0, (double)(this.random.nextInt(5) - 2));
                        zombie.teleport(newLoc);
                        this.stuckCheckTimestamps.remove(id);
                    }
                } else {
                    this.stuckCheckTimestamps.remove(id);
                }
            }
        } else {
            this.stuckCheckTimestamps.remove(id);
        }
        this.lastPositions.put(id, currentPos);
    }

    @EventHandler
    public void onPlayerSprint(PlayerToggleSprintEvent event) {
        if (event.isSprinting()) {
            this.alertNearbyZombies(event.getPlayer().getLocation(), 20.0);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        this.alertNearbyZombies(event.getBlock().getLocation(), 15.0);
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        this.alertNearbyZombies(event.getLocation(), 30.0);
    }

    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            this.alertNearbyZombies(event.getEntity().getLocation(), 25.0);
        }
    }

    private void alertNearbyZombies(Location location, double radius) {
        Collection nearby = location.getWorld().getNearbyEntities(location, radius, radius, radius);
        for (Entity entity : nearby) {
            if (!(entity instanceof Zombie)) continue;
            Zombie zombie = (Zombie)entity;
            Player nearestPlayer = this.findNearestPlayer(location, 50.0);
            if (nearestPlayer == null || zombie.getTarget() != null && zombie.getTarget().equals((Object)nearestPlayer)) continue;
            zombie.setTarget((LivingEntity)nearestPlayer);
            this.zombieMemory.put(zombie.getUniqueId(), new PlayerMemory(nearestPlayer.getLocation()));
        }
    }

    private Player findNearestPlayer(Location location, double maxDistance) {
        Player nearest = null;
        double closestDistSq = maxDistance * maxDistance;
        for (Player player : Bukkit.getOnlinePlayers()) {
            double distSq;
            if (!player.getWorld().equals((Object)location.getWorld()) || !((distSq = player.getLocation().distanceSquared(location)) < closestDistSq)) continue;
            closestDistSq = distSq;
            nearest = player;
        }
        return nearest;
    }

    @EventHandler
    public void onCreatureTarget(EntityTargetEvent event) {
        Creature creature;
        Player player;
        if (!this.infected.isInfectionEnabled()) {
            return;
        }
        Entity target = event.getTarget();
        Entity entity = event.getEntity();
        if (target instanceof Player && this.infected.isPlayerFullyInfected(player = (Player)target) && entity instanceof Creature && ((creature = (Creature)entity).getType() == EntityType.VILLAGER || creature.getType() == EntityType.COW || creature.getType() == EntityType.SHEEP || creature.getType() == EntityType.PIG)) {
            event.setCancelled(true);
        }
    }

    void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Zombie Apocalypse Commands:");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/za reload " + String.valueOf(ChatColor.GRAY) + "- Reload config");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/za info " + String.valueOf(ChatColor.GRAY) + "- Show current status");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/za spawn <type> " + String.valueOf(ChatColor.GRAY) + "- Spawn a zombie");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/za forcebloodmoon " + String.valueOf(ChatColor.GRAY) + "- Force blood moon");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Available types: normal, tank, charger, assassin, blight, burster, spitter, frost");
    }

    void sendStatusInfo(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "\u2726 Zombie Apocalypse Status \u2726");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current Day: " + String.valueOf(ChatColor.WHITE) + this.currentDay);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Mutation Rate: " + String.valueOf(ChatColor.WHITE) + this.currentMutationRate + "%");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Blood Moon: " + (this.isBloodMoon ? String.valueOf(ChatColor.DARK_RED) + "ACTIVE" : String.valueOf(ChatColor.GREEN) + "inactive"));
        int totalZombies = 0;
        HashMap<String, Integer> typeCounts = new HashMap<String, Integer>();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Zombie)) continue;
                ++totalZombies;
                String type = (String)((Zombie)entity).getPersistentDataContainer().get(this.zombieTypeKey, PersistentDataType.STRING);
                if (type != null) {
                    typeCounts.put(type, typeCounts.getOrDefault(type, 0) + 1);
                    continue;
                }
                typeCounts.put("normal", typeCounts.getOrDefault("normal", 0) + 1);
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Active Zombies: " + String.valueOf(ChatColor.WHITE) + totalZombies);
        for (Map.Entry entry : typeCounts.entrySet()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  " + (String)entry.getKey() + ": " + String.valueOf(ChatColor.WHITE) + String.valueOf(entry.getValue()));
        }
    }

    void handleZombieSpawn(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Specify type: normal, tank, charger, assassin, blight, burster, spitter, frost");
            return;
        }
        String type = args[1].toLowerCase();
        double speed = this.getConfig().getDouble(BASE_SPEED) * (1.0 + 0.05 * (double)this.currentDay);
        double damage = this.getConfig().getDouble(BASE_DAMAGE) * (1.0 + 0.05 * (double)this.currentDay);
        Zombie zombie = (Zombie)player.getWorld().spawnEntity(player.getLocation().add(3.0, 0.0, 3.0), EntityType.ZOMBIE);
        zombie.setCanPickupItems(false);
        switch (type) {
            case "tank": {
                this.createTank(zombie, speed, damage);
                break;
            }
            case "charger": {
                this.createCharger(zombie, speed, damage);
                break;
            }
            case "assassin": {
                this.createAssassin(zombie, damage);
                break;
            }
            case "blight": {
                this.createBlightZombie(zombie, damage);
                break;
            }
            case "burster": {
                this.createBurster(zombie, speed, damage);
                break;
            }
            case "spitter": {
                this.createSpitter(zombie, speed, damage);
                break;
            }
            case "frost": {
                this.createFrostZombie(zombie, damage);
                break;
            }
            default: {
                this.setupNormalZombie(zombie);
            }
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Spawned " + type + " zombie!");
        player.playSound(player.getLocation(), Sound.ENTITY_ZOMBIE_AMBIENT, 1.0f, 0.8f);
    }

    public NamespacedKey getNamespacedKey(String keyName) {
        return new NamespacedKey((Plugin)this, keyName);
    }

    private void setupNormalZombie(Zombie zombie) {
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"normal");
        zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        zombie.setCustomNameVisible(true);
    }

    private void createTank(Zombie zombie, double speed, double damage) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.tank");
        double health = 40.0 * cfg.getDouble("health_multiplier", 3.0);
        this.setAttribute(zombie, Attribute.MAX_HEALTH, health);
        zombie.setHealth(health);
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, speed * cfg.getDouble("speed_multiplier", 0.6));
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, damage * cfg.getDouble("damage_multiplier", 1.5));
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"tank");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.DARK_GREEN) + "TANK [" + (int)health + "\u2764]");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, Integer.MAX_VALUE, 1, false, false));
    }

    private void createCharger(Zombie zombie, double speed, double damage) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.charger");
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 20.0 * cfg.getDouble("health_multiplier", 0.8));
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, speed * cfg.getDouble("speed_multiplier", 2.2));
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, damage + cfg.getDouble("damage_bonus", 1.5));
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"charger");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.RED) + "\u26a1 CHARGER");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, false, false));
    }

    private void createAssassin(final Zombie zombie, double damage) {
        ConfigurationSection cfg = this.getConfig().getConfigurationSection("mutation_types.assassin");
        this.setAttribute(zombie, Attribute.MAX_HEALTH, cfg.getDouble("base_health", 8.0));
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, damage * cfg.getDouble("damage_multiplier", 2.5));
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"assassin");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.DARK_PURPLE) + "ASSASSIN");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false));
        new BukkitRunnable(){

            public void run() {
                if (zombie.isDead() || !zombie.isValid()) {
                    this.cancel();
                    return;
                }
                zombie.getWorld().spawnParticle(Particle.WITCH, zombie.getLocation().add(0.0, 1.5, 0.0), 3, 0.2, 0.2, 0.2, 0.1);
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void createBlightZombie(final Zombie zombie, double baseDamage) {
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 20.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"blight");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.GREEN) + "BLIGHT ZOMBIE");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.POISON, Integer.MAX_VALUE, 1, false, false));
        new BukkitRunnable(){

            public void run() {
                if (zombie.isDead() || !zombie.isValid()) {
                    this.cancel();
                    return;
                }
                zombie.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, zombie.getLocation(), 5);
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void createBurster(Zombie zombie, double baseSpeed, double baseDamage) {
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 10.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, baseSpeed * 1.2);
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"burster");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.YELLOW) + "BURSTER");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.setMetadata("burster", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
    }

    private void createSpitter(Zombie zombie, double baseSpeed, double baseDamage) {
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 16.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.MOVEMENT_SPEED, baseSpeed * 0.5);
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage * 0.5);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"spitter");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.BLUE) + "SPITTER");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
    }

    private void createFrostZombie(Zombie zombie, double baseDamage) {
        this.setAttribute(zombie, Attribute.MAX_HEALTH, 20.0);
        zombie.setHealth(zombie.getAttribute(Attribute.MAX_HEALTH).getValue());
        this.setAttribute(zombie, Attribute.ATTACK_DAMAGE, baseDamage);
        zombie.getPersistentDataContainer().set(this.zombieTypeKey, PersistentDataType.STRING, (Object)"frost");
        if (this.showMutationNamesAboveZombies) {
            zombie.setCustomName(String.valueOf(ChatColor.AQUA) + "FROST ZOMBIE");
        } else {
            zombie.setCustomName(String.valueOf(ChatColor.WHITE) + "Zombie");
        }
        zombie.setCustomNameVisible(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 1, false, false));
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 1, false, false));
    }

    private void applyRandomMutation(Zombie zombie, double baseSpeed, double baseDamage) {
        double frostChance;
        double spitterChance;
        double bursterChance;
        double blightChance;
        double assassinChance;
        double chargerChance;
        double roll = this.random.nextDouble() * 100.0;
        ConfigurationSection mutations = this.getConfig().getConfigurationSection("mutation_types");
        double tankChance = mutations.getDouble("tank.chance", 50.0);
        double totalChance = tankChance + (chargerChance = mutations.getDouble("charger.chance", 30.0)) + (assassinChance = mutations.getDouble("assassin.chance", 20.0)) + (blightChance = mutations.getDouble("blight.chance", 0.0)) + (bursterChance = mutations.getDouble("burster.chance", 0.0)) + (spitterChance = mutations.getDouble("spitter.chance", 0.0)) + (frostChance = mutations.getDouble("frost.chance", 0.0));
        if (totalChance > 100.0) {
            this.getLogger().warning("Mutation chances exceed 100%. Please adjust your config.");
            return;
        }
        if (roll < tankChance) {
            this.createTank(zombie, baseSpeed, baseDamage);
        } else if (roll < tankChance + chargerChance) {
            this.createCharger(zombie, baseSpeed, baseDamage);
        } else if (roll < tankChance + chargerChance + assassinChance) {
            this.createAssassin(zombie, baseDamage);
        } else if (roll < tankChance + chargerChance + assassinChance + blightChance) {
            this.createBlightZombie(zombie, baseDamage);
        } else if (roll < tankChance + chargerChance + assassinChance + blightChance + bursterChance) {
            this.createBurster(zombie, baseSpeed, baseDamage);
        } else if (roll < tankChance + chargerChance + assassinChance + blightChance + bursterChance + spitterChance) {
            this.createSpitter(zombie, baseSpeed, baseDamage);
        } else {
            this.createFrostZombie(zombie, baseDamage);
        }
        zombie.getPersistentDataContainer().set(this.mutationDayKey, PersistentDataType.INTEGER, (Object)this.currentDay);
    }

    private void handleSpitterAbility(final Zombie spitter, Player target) {
        Location targetLoc;
        if (spitter.hasMetadata("spitter_cooldown")) {
            return;
        }
        Location spitterLoc = spitter.getLocation();
        if (spitterLoc.distance(targetLoc = target.getLocation()) <= 15.0) {
            ThrownPotion potion = (ThrownPotion)spitter.launchProjectile(ThrownPotion.class);
            ItemStack potionItem = new ItemStack(Material.SPLASH_POTION);
            PotionMeta meta = (PotionMeta)potionItem.getItemMeta();
            if (meta != null) {
                meta.addCustomEffect(new PotionEffect(PotionEffectType.POISON, 100, 1), true);
                potionItem.setItemMeta((ItemMeta)meta);
            }
            potion.setItem(potionItem);
            Vector direction = targetLoc.toVector().subtract(spitterLoc.toVector()).normalize().multiply(1.2);
            potion.setVelocity(direction);
            spitter.setMetadata("spitter_cooldown", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
            new BukkitRunnable(){

                public void run() {
                    spitter.removeMetadata("spitter_cooldown", (Plugin)ZombieApocalypse999.this);
                }
            }.runTaskLater((Plugin)this, 100L);
        }
    }

    private void handleBursterAbility(Zombie burster, Player target) {
        double distance;
        if (!burster.isDead() && burster.isValid() && (distance = burster.getLocation().distance(target.getLocation())) <= 5.0) {
            burster.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 40, 1, false, false));
        }
    }

    private class SunlightProtectionListener
    implements Listener {
        private SunlightProtectionListener() {
        }

        @EventHandler
        public void onEntityCombust(EntityCombustEvent event) {
            if (event.getEntityType() == EntityType.ZOMBIE && !(event instanceof EntityCombustByBlockEvent) && !(event instanceof EntityCombustByEntityEvent)) {
                event.setCancelled(true);
            }
        }
    }

    private static class PlayerMemory {
        private final Location lastKnownLocation;
        private final long expiryTime;

        public PlayerMemory(Location location) {
            this.lastKnownLocation = location.clone();
            this.expiryTime = System.currentTimeMillis() + 10000L;
        }

        public Location getLastKnownLocation() {
            return this.lastKnownLocation;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expiryTime;
        }
    }
}

