package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.tlotd.block.ModBlocks;
import net.tlotd.entity.ModEntities;
import net.tlotd.entity.custom.SeatEntity;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class BenchBlock extends class_2248 {

    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2318.field_10927;
    public static final class_2758 BENCH = class_2758.method_11867("bench", 0,3);

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910))
                .method_11657(BENCH, 0);

    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED, BENCH);
    }

    public BenchBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false).method_11657(BENCH, 0));
    }

    private static final class_265 BASE_SHAPE = class_2248.method_9541(0,0,0,16,8,16);

    public static final class_265 WEST_SHAPE = class_259.method_1084(
            class_2248.method_9541(0, 8, 0, 1, 21, 16),
            BASE_SHAPE
    );
    public static final class_265 NORTH_SHAPE = class_259.method_1084(
            class_2248.method_9541(0, 8, 0, 16, 21, 1),
            BASE_SHAPE
    );
    public static final class_265 EAST_SHAPE = class_259.method_1084(
            class_2248.method_9541(15, 8, 0, 16, 21, 16),
            BASE_SHAPE
    );
    public static final class_265 SOUTH_SHAPE = class_259.method_1084(
            class_2248.method_9541(0, 8, 15, 16, 21, 16),
            BASE_SHAPE
    );

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(FACING)) {
            case field_11043 -> NORTH_SHAPE;
            case field_11035 -> SOUTH_SHAPE;
            case field_11034 -> EAST_SHAPE;
            case field_11039 -> WEST_SHAPE;
            default -> BASE_SHAPE;
        };
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if(!world.field_9236){
            class_1297 entity = null;
            List<SeatEntity> entities = world.method_18023(ModEntities.SEAT, new class_238(pos), chair -> true);
            if(entities.isEmpty()) {
                entity = ModEntities.SEAT.method_47821((class_3218) world, pos, class_3730.field_16461);
            } else {
                entity = entities.get(0);
            }
            player.method_5804(entity);
        }
        return class_1269.field_5812;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        boolean thisWater = world.method_8316(pos).method_39360(class_3612.field_15910);
        if (world.method_8320(pos.method_10095()).method_27852(ModBlocks.BENCH)) {
            boolean water = world.method_8320(pos.method_10095()).method_11654(WATERLOGGED);
            if (world.method_8320(pos.method_10095()).method_11654(FACING).equals(class_2350.field_11039) && state.method_11654(FACING).equals(class_2350.field_11039)) {
                if (world.method_8320(pos.method_10095()).method_11654(BENCH) == 0) {
                    world.method_8501(pos.method_10095(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11039).method_11657(BENCH, 3).method_11657(WATERLOGGED, water));
                } else if (world.method_8320(pos.method_10095()).method_11654(BENCH) != 3) {
                    world.method_8501(pos.method_10095(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11039).method_11657(BENCH, 2).method_11657(WATERLOGGED, water));
                }
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11039).method_11657(BENCH, 1).method_11657(WATERLOGGED, thisWater));
            }
            if (world.method_8320(pos.method_10095()).method_11654(FACING).equals(class_2350.field_11034) && state.method_11654(FACING).equals(class_2350.field_11034)) {
                if (world.method_8320(pos.method_10095()).method_11654(BENCH) == 0) {
                    world.method_8501(pos.method_10095(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11034).method_11657(BENCH, 1).method_11657(WATERLOGGED, water));
                } else if (world.method_8320(pos.method_10095()).method_11654(BENCH) != 1) {
                    world.method_8501(pos.method_10095(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11034).method_11657(BENCH, 2).method_11657(WATERLOGGED, water));
                }
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11034).method_11657(BENCH, 3).method_11657(WATERLOGGED, thisWater));
            }
        }
        if (world.method_8320(pos.method_10072()).method_27852(ModBlocks.BENCH)) {
            boolean water = world.method_8320(pos.method_10072()).method_11654(WATERLOGGED);
            if (world.method_8320(pos.method_10072()).method_11654(FACING).equals(class_2350.field_11039) && state.method_11654(FACING).equals(class_2350.field_11039)) {
                if (world.method_8320(pos.method_10072()).method_11654(BENCH) == 0) {
                    world.method_8501(pos.method_10072(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11039).method_11657(BENCH, 1).method_11657(WATERLOGGED, water));
                } else if (world.method_8320(pos.method_10072()).method_11654(BENCH) != 1) {
                    world.method_8501(pos.method_10072(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11039).method_11657(BENCH, 2).method_11657(WATERLOGGED, water));
                }
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11039).method_11657(BENCH, 3).method_11657(WATERLOGGED, thisWater));
            }
            if (world.method_8320(pos.method_10072()).method_11654(FACING).equals(class_2350.field_11034) && state.method_11654(FACING).equals(class_2350.field_11034)) {
                if (world.method_8320(pos.method_10072()).method_11654(BENCH) == 0) {
                    world.method_8501(pos.method_10072(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11034).method_11657(BENCH, 3).method_11657(WATERLOGGED, water));
                } else if (world.method_8320(pos.method_10072()).method_11654(BENCH) != 3) {
                    world.method_8501(pos.method_10072(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11034).method_11657(BENCH, 2).method_11657(WATERLOGGED, water));
                }
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11034).method_11657(BENCH, 1).method_11657(WATERLOGGED, thisWater));
            }
        }
        if (world.method_8320(pos.method_10067()).method_27852(ModBlocks.BENCH)) {
            boolean water = world.method_8320(pos.method_10067()).method_11654(WATERLOGGED);
            if (world.method_8320(pos.method_10067()).method_11654(FACING).equals(class_2350.field_11043) && state.method_11654(FACING).equals(class_2350.field_11043)) {
                if (world.method_8320(pos.method_10067()).method_11654(BENCH) == 0) {
                    world.method_8501(pos.method_10067(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11043).method_11657(BENCH, 1).method_11657(WATERLOGGED, water));
                } else if (world.method_8320(pos.method_10067()).method_11654(BENCH) != 1) {
                    world.method_8501(pos.method_10067(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11043).method_11657(BENCH, 2).method_11657(WATERLOGGED, water));
                }
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11043).method_11657(BENCH, 3).method_11657(WATERLOGGED, thisWater));
            }
            if (world.method_8320(pos.method_10067()).method_11654(FACING).equals(class_2350.field_11035) && state.method_11654(FACING).equals(class_2350.field_11035)) {
                if (world.method_8320(pos.method_10067()).method_11654(BENCH) == 0) {
                    world.method_8501(pos.method_10067(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11035).method_11657(BENCH, 3).method_11657(WATERLOGGED, water));
                } else if (world.method_8320(pos.method_10067()).method_11654(BENCH) != 3) {
                    world.method_8501(pos.method_10067(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11035).method_11657(BENCH, 2).method_11657(WATERLOGGED, water));
                }
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11035).method_11657(BENCH, 1).method_11657(WATERLOGGED, thisWater));
            }
        }
        if (world.method_8320(pos.method_10078()).method_27852(ModBlocks.BENCH)) {
            boolean water = world.method_8320(pos.method_10078()).method_11654(WATERLOGGED);
            if (world.method_8320(pos.method_10078()).method_11654(FACING).equals(class_2350.field_11043) && state.method_11654(FACING).equals(class_2350.field_11043)) {
                if (world.method_8320(pos.method_10078()).method_11654(BENCH) == 0) {
                    world.method_8501(pos.method_10078(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11043).method_11657(BENCH, 3).method_11657(WATERLOGGED, water));
                } else if (world.method_8320(pos.method_10078()).method_11654(BENCH) != 3) {
                    world.method_8501(pos.method_10078(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11043).method_11657(BENCH, 2).method_11657(WATERLOGGED, water));
                }
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11043).method_11657(BENCH, 1).method_11657(WATERLOGGED, thisWater));
            }
            if (world.method_8320(pos.method_10078()).method_11654(FACING).equals(class_2350.field_11035) && state.method_11654(FACING).equals(class_2350.field_11035)) {
                if (world.method_8320(pos.method_10078()).method_11654(BENCH) == 0) {
                    world.method_8501(pos.method_10078(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11035).method_11657(BENCH, 1).method_11657(WATERLOGGED, water));
                } else if (world.method_8320(pos.method_10078()).method_11654(BENCH) != 1) {
                    world.method_8501(pos.method_10078(), ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11035).method_11657(BENCH, 2).method_11657(WATERLOGGED, water));
                }
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11035).method_11657(BENCH, 3).method_11657(WATERLOGGED, thisWater));
            }
        } //Middle Part
        if (world.method_8320(pos.method_10095()).method_27852(ModBlocks.BENCH) && world.method_8320(pos.method_10072()).method_27852(ModBlocks.BENCH)) {
            if (world.method_8320(pos.method_10095()).method_11654(FACING).equals(class_2350.field_11039) && world.method_8320(pos.method_10072()).method_11654(FACING).equals(class_2350.field_11039) && state.method_11654(FACING).equals(class_2350.field_11039)) {
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11039).method_11657(BENCH, 2).method_11657(WATERLOGGED, thisWater));
            }
            if (world.method_8320(pos.method_10095()).method_11654(FACING).equals(class_2350.field_11034) && world.method_8320(pos.method_10072()).method_11654(FACING).equals(class_2350.field_11034) && state.method_11654(FACING).equals(class_2350.field_11034)) {
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11034).method_11657(BENCH, 2).method_11657(WATERLOGGED, thisWater));
            }
        }
        if (world.method_8320(pos.method_10067()).method_27852(ModBlocks.BENCH) && world.method_8320(pos.method_10078()).method_27852(ModBlocks.BENCH)) {
            if (world.method_8320(pos.method_10067()).method_11654(FACING).equals(class_2350.field_11043) && world.method_8320(pos.method_10078()).method_11654(FACING).equals(class_2350.field_11043) && state.method_11654(FACING).equals(class_2350.field_11043)) {
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11043).method_11657(BENCH, 2).method_11657(WATERLOGGED, thisWater));
            }
            if (world.method_8320(pos.method_10067()).method_11654(FACING).equals(class_2350.field_11035) && world.method_8320(pos.method_10078()).method_11654(FACING).equals(class_2350.field_11035) && state.method_11654(FACING).equals(class_2350.field_11035)) {
                world.method_8501(pos, ModBlocks.BENCH.method_9564().method_11657(FACING, class_2350.field_11035).method_11657(BENCH, 2).method_11657(WATERLOGGED, thisWater));
            }
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }
}
