package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.tlotd.block.entity.GarbageCanBlockEntity;
import net.tlotd.block.entity.KeycardReaderBlockEntity;
import net.tlotd.item.ModItems;
import net.tlotd.sound.ModSounds;
import org.jetbrains.annotations.Nullable;

public class GarbageCanBlock extends class_2237 implements class_2343 {

    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(WATERLOGGED);
    }

    public GarbageCanBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(WATERLOGGED, false));
    }

    private static final class_265 SHAPE = class_259.method_17786(
            class_2248.method_9541(2,0,2,14,12,14),

            class_2248.method_9541(2, 12, 2, 3, 13, 14),
            class_2248.method_9541(2, 12, 2, 14, 13, 3),
            class_2248.method_9541(2, 12, 13, 14, 13, 14),
            class_2248.method_9541(13, 12, 2, 14, 13, 14),

            class_2248.method_9541(1, 13, 1, 3, 16, 15),
            class_2248.method_9541(1, 13, 1, 15, 16, 3),
            class_2248.method_9541(1, 13, 13, 15, 16, 15),
            class_2248.method_9541(13, 13, 1, 15, 16, 15)
            );

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GarbageCanBlockEntity(pos, state);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        class_2586 blockEntity = world.method_8321(pos);
        if (!world.field_9236 && blockEntity instanceof GarbageCanBlockEntity garbageCanBlockEntity) {
            if (player.method_5715()) {
                if (player.method_31548().method_7376() == -1) {
                    class_2248.method_9577(world, pos.method_10084(), garbageCanBlockEntity.method_5438(0));
                } else {
                    player.method_6122(hand, garbageCanBlockEntity.method_5438(0));
                }
                garbageCanBlockEntity.method_5447(0, garbageCanBlockEntity.method_5438(1));
                garbageCanBlockEntity.method_5447(1, garbageCanBlockEntity.method_5438(2));
                garbageCanBlockEntity.method_5447(2, class_1799.field_8037);
                world.method_8396(null,pos, ModSounds.BLOCK_GARBAGE_CAN_USED, class_3419.field_15245, 1.0f, 1.0f);
            } else if (!stack.method_7960()) {
                garbageCanBlockEntity.method_5447(2, garbageCanBlockEntity.method_5438(1));
                garbageCanBlockEntity.method_5447(1, garbageCanBlockEntity.method_5438(0));
                garbageCanBlockEntity.method_5447(0, stack);
                player.method_6122(hand, class_1799.field_8037);
                world.method_8396(null,pos, ModSounds.BLOCK_GARBAGE_CAN_USED, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        return class_1269.field_5812;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof GarbageCanBlockEntity) {
                class_1264.method_5451(world, pos, (GarbageCanBlockEntity)blockEntity);
                world.method_8455(pos, this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }
}