package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.util.*;
import net.tlotd.block.entity.MithrilAnvilBlockEntity;
import net.tlotd.block.entity.ModBlockEntities;
import net.tlotd.config.ModConfigs;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class MithrilAnvilBlock extends class_2237 implements class_2343 {

    public static final class_2753 FACING;
    private static final class_265 BASE_SHAPE;
    private static final class_265 X_STEP_SHAPE;
    private static final class_265 X_STEM_SHAPE;
    private static final class_265 X_FACE_SHAPE;
    private static final class_265 Z_STEP_SHAPE;
    private static final class_265 Z_STEM_SHAPE;
    private static final class_265 Z_FACE_SHAPE;
    private static final class_265 X_AXIS_SHAPE;
    private static final class_265 Z_AXIS_SHAPE;

    public MithrilAnvilBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_8042().method_10170());
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = state.method_11654(FACING);
        return direction.method_10166() == class_2350.class_2351.field_11048 ? X_AXIS_SHAPE : Z_AXIS_SHAPE;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    static {
        FACING = class_2383.field_11177;
        BASE_SHAPE = class_2248.method_9541(2.0F, 0.0F, 2.0F, 14.0F, 4.0F, 14.0F);
        X_STEP_SHAPE = class_2248.method_9541(3.0F, 4.0F, 4.0F, 13.0F, 5.0F, 12.0F);
        X_STEM_SHAPE = class_2248.method_9541(4.0F, 5.0F, 6.0F, 12.0F, 10.0F, 10.0F);
        X_FACE_SHAPE = class_2248.method_9541(0.0F, 10.0F, 3.0F, 16.0F, 16.0F, 13.0F);
        Z_STEP_SHAPE = class_2248.method_9541(4.0F, 4.0F, 3.0F, 12.0F, 5.0F, 13.0F);
        Z_STEM_SHAPE = class_2248.method_9541(6.0F, 5.0F, 4.0F, 10.0F, 10.0F, 12.0F);
        Z_FACE_SHAPE = class_2248.method_9541(3.0F, 10.0F, 0.0F, 13.0F, 16.0F, 16.0F);
        X_AXIS_SHAPE = class_259.method_17786(BASE_SHAPE, X_STEP_SHAPE, X_STEM_SHAPE, X_FACE_SHAPE);
        Z_AXIS_SHAPE = class_259.method_17786(BASE_SHAPE, Z_STEP_SHAPE, Z_STEM_SHAPE, Z_FACE_SHAPE);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MithrilAnvilBlockEntity(pos, state);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof MithrilAnvilBlockEntity) {
                class_1264.method_5451(world, pos, (MithrilAnvilBlockEntity)blockEntity);
                world.method_8455(pos, this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            class_3908 screenHandlerFactory = ((MithrilAnvilBlockEntity) world.method_8321(pos));
            if (screenHandlerFactory != null) {
                player.method_17355(screenHandlerFactory);
            }
        }
        return class_1269.field_5812;
    }

    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return method_31618(type, ModBlockEntities.MITHRIL_ANVIL_BLOCK_ENTITY,
                (world1, pos, state1, blockEntity) -> blockEntity.tick(world1, pos, state1));
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        spawnParticles(world, pos);
    }

    private static void spawnParticles(class_1937 world, class_2338 pos) {
        class_5819 random = world.field_9229;
        if (random.method_43048(5) == 1) {
            for(class_2350 direction : class_2350.values()) {
                class_2338 blockPos = pos.method_10093(direction);
                if (!world.method_8320(blockPos).method_26216(world, blockPos)) {
                    class_2350.class_2351 axis = direction.method_10166();
                    double e = axis == class_2350.class_2351.field_11048 ? 0.5F + 0.5625F * direction.method_10148() : random.method_43057();
                    double f = axis == class_2350.class_2351.field_11052 ? 0.5F + 0.5625F * direction.method_10164() : random.method_43057();
                    double g = axis == class_2350.class_2351.field_11051 ? 0.5F + 0.5625F * direction.method_10165() : random.method_43057();
                    world.method_8406(class_2398.field_11207, pos.method_10263() + e, pos.method_10264() + f, pos.method_10260() + g, 0.0F, 0.0F, 0.0F);
                }
            }
        }
    }

    public static final class_2960 RECIPIES_FONT_ID = new class_2960("tlotd", "recipies");

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        tooltip.add(class_2561.method_43470(""));
        if (ModConfigs.MITHRIL_ANVIL_NEEDS_DIRECT_MOONLIGHT) {
            tooltip.add(class_2561.method_43471("block.tlotd.mithril_anvil.tooltip").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("block.tlotd.mithril_anvil.tooltip_2").method_27692(class_124.field_1078)));
            tooltip.add(class_2561.method_43470(""));
        }
        if (class_437.method_25442()) {
            class_2583 style = this.method_9518().method_10866();
            tooltip.add(class_2561.method_43470("\uE010\uE000\uE018\uE019\uE01A\uE01B\uE011\uE013\uE014\uE012\uE016").method_10862(style.method_27704(RECIPIES_FONT_ID)));
            tooltip.add(class_2561.method_43470("\uE010\uE000\uE015\uE011\uE013\uE016\uE012\uE017").method_10862(style.method_27704(RECIPIES_FONT_ID)));

        } else {
            tooltip.add(class_2561.method_43470("").method_10852(class_2561.method_43471("text.tlotd.recipe.tooltip").method_27692(class_124.field_1063)).method_10852(class_2561.method_43471("key.keyboard.left.shift").method_27692(class_124.field_1080)).method_10852(class_2561.method_43471("text.tlotd.recipe.tooltip_2").method_27692(class_124.field_1063)));
        }
        super.method_9568(stack, world, tooltip, options);
    }
}
