package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.tlotd.block.ModBlocks;
import net.tlotd.config.ModConfigs;
import net.tlotd.item.ModItems;
import net.tlotd.sound.ModSounds;
import net.tlotd.util.ModTags;
import org.jetbrains.annotations.Nullable;

import java.util.List;

import static net.tlotd.block.custom.DataSaverBlock.*;
import static net.tlotd.block.custom.DataSaverBlock.FREQUENCY_4;

public class RadioBlock extends class_2248 {

    public static final class_2758 FREQUENCY = class_2758.method_11867("frequency", 0, 4);
    public static final class_2758 WOOD_TYPE = class_2758.method_11867("wood_type", 1, 15);
    public static final class_2746 MODDED = class_2746.method_11825("modded");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2318.field_10927;

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910))
                .method_11657(FREQUENCY, 0)
                .method_11657(WOOD_TYPE, 1)
                .method_11657(MODDED, false);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }

        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED, FREQUENCY, WOOD_TYPE, MODDED);
    }

    public RadioBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false).method_11657(FREQUENCY, 0).method_11657(WOOD_TYPE, 1).method_11657(MODDED, false));
    }

    public static final class_265 Z_SHAPE = class_2248.method_9541(4.0, 0.0, 0.0, 12.0, 11.0, 16.0);
    public static final class_265 X_SHAPE = class_2248.method_9541(0.0, 0.0, 4.0, 16.0, 11.0, 12.0);

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(FACING)) {
            case field_11034, field_11039 -> Z_SHAPE;
            default -> X_SHAPE;
        };
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        if (!ModConfigs.ALL_SIGNALS_UNLOCKED) {
            tooltip.add(class_2561.method_43470(""));
            tooltip.add(class_2561.method_43471("block.tlotd.radio.tooltip").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43471("block.tlotd.radio.tooltip_2").method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43470(" ").method_10852(class_2561.method_43471("block.tlotd.signal_transmitter").method_27692(class_124.field_1078)));
        }
        super.method_9568(stack, world, tooltip, options);
    }

    @Override
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return ModBlocks.RADIO.method_8389().method_7854();
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2338 zero = new class_2338(0,world.method_31607(),0);
        if (player.method_5715()) {
            class_310.method_1551().method_1483().method_4881();
            if (!world.field_9236) {
                if (state.method_26204().equals(ModBlocks.RADIO)) {
                    if (ModConfigs.ALL_SIGNALS_UNLOCKED) {
                        world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state));
                        if (state.method_11654(FREQUENCY) == 1) {
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.1"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_1, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (state.method_11654(FREQUENCY) == 2) {
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.2"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_2, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (state.method_11654(FREQUENCY) == 3) {
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.3"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_3, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (state.method_11654(FREQUENCY) == 4) {
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.4"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_4, class_3419.field_15247, 1.0f, 1.0f);
                        }
                    } else if (world.method_8320(zero).method_26204().equals(ModBlocks.BEDROCK)) {
                        if (world.method_8320(zero).method_11654(FREQUENCY_1) && state.method_11654(FREQUENCY) <= 1) {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, 1));
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.1"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_1, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (world.method_8320(zero).method_11654(FREQUENCY_2) && state.method_11654(FREQUENCY) <= 2) {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, 2));
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.2"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_2, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (world.method_8320(zero).method_11654(FREQUENCY_3) && state.method_11654(FREQUENCY) <= 3) {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, 3));
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.3"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_3, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (world.method_8320(zero).method_11654(FREQUENCY_4) && state.method_11654(FREQUENCY) <= 4) {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, 4));
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.4"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_4, class_3419.field_15247, 1.0f, 1.0f);
                        } else {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, 0));
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.0"), true);
                        }
                    } else {
                        world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY, 0));
                        player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.0"), true);
                    }
                } else {
                    class_310.method_1551().method_1483().method_4881();
                    world.method_8501(pos, ModBlocks.RADIO.method_34725(state));
                }
            }
            world.method_8396(null, pos, ModSounds.BLOCK_RADIO_SWITCH_FREQUENCY, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        } else {
            if (player.method_6047().method_31573(class_3489.field_15539) || player.method_6047().method_31573(class_3489.field_40987) || player.method_6047().method_31573(ModTags.Items.GINKGO_LOGS)){
                if (!world.field_9236) {
                    String name = player.method_6047().method_7922();
                    if (player.method_6047().method_31573(class_3489.field_15545)) {
                        updateWood(world,pos,1,false);
                    } else if (player.method_6047().method_31573(class_3489.field_15549)) {
                        updateWood(world,pos,2,false);
                    } else if (player.method_6047().method_31573(class_3489.field_15554)) {
                        updateWood(world,pos,3,false);
                    } else if (player.method_6047().method_31573(class_3489.field_15538)) {
                        updateWood(world,pos,4,false);
                    } else if (player.method_6047().method_31573(class_3489.field_15525)) {
                        updateWood(world,pos,5,false);
                    } else if (player.method_6047().method_31573(class_3489.field_15546)) {
                        updateWood(world,pos,6,false);
                    } else if (player.method_6047().method_31573(class_3489.field_37403)) {
                        updateWood(world,pos,7,false);
                    } else if (player.method_6047().method_31573(class_3489.field_42618)) {
                        updateWood(world,pos,8,false);
                    } else if (player.method_6047().method_31573(ModTags.Items.GINKGO_LOGS)) {
                        updateWood(world,pos,10,false);
                    } else if (player.method_6047().method_31573(class_3489.field_40987)) {
                        updateWood(world,pos,11,false);
                    } else if (player.method_6047().method_31573(class_3489.field_21957)) {
                        updateWood(world,pos,12,false);
                    } else if (player.method_6047().method_31573(class_3489.field_21958)) {
                        updateWood(world,pos,13,false);
                    } else if (name.contains("aether") && (name.contains("skyroot") || name.contains("golden_oak"))) { //modded logs
                        updateWood(world,pos,1,true);
                    } else if (name.contains("twilightforest") && name.contains("twilight_oak")) {
                        updateWood(world,pos,2,true);
                    } else if (name.contains("twilightforest") && name.contains("canopy")) {
                        updateWood(world,pos,3,true);
                    } else if (name.contains("twilightforest") && name.contains("mangrove")) {
                        updateWood(world,pos,4,true);
                    } else if (name.contains("twilightforest") && name.contains("dark")) {
                        updateWood(world,pos,5,true);
                    } else if (name.contains("twilightforest") && name.contains("time")) {
                        updateWood(world,pos,6,true);
                    } else if (name.contains("twilightforest") && name.contains("transformation")) {
                        updateWood(world,pos,7,true);
                    } else if (name.contains("twilightforest") && name.contains("mining")) {
                        updateWood(world,pos,8,true);
                    } else if (name.contains("twilightforest") && name.contains("sorting")) {
                        updateWood(world,pos,9,true);
                    } else if (name.contains("thermal") && name.contains("rubberwood")) {
                        updateWood(world,pos,10,true);
                    } else if (name.contains("quark") && name.contains("ancient")) {
                        updateWood(world,pos,11,true);
                    } else if (name.contains("quark") && name.contains("azalea")) {
                        updateWood(world,pos,12,true);
                    } else if (name.contains("quark") && name.contains("blossom")) {
                        updateWood(world,pos,13,true);
                    } else if (name.contains("alexscaves") && name.contains("pewen")) {
                        updateWood(world,pos,14,true);
                    } else if (name.contains("alexscaves") && name.contains("thornwood")) {
                        updateWood(world,pos,15,true);
                    }
                }
                world.method_8396(null, pos, class_3417.field_14718, class_3419.field_15245, 1.0f, 1.0f);
                return class_1269.field_5812;
            } else if (state.method_26204().equals(ModBlocks.RADIO_ON)) {
                class_310.method_1551().method_1483().method_4881();
                if (!world.field_9236) {
                    if (ModConfigs.ALL_SIGNALS_UNLOCKED) {
                        if (state.method_11654(FREQUENCY) < 4) {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state.method_11657(FREQUENCY, state.method_11654(FREQUENCY)+1)));
                        } else {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state.method_11657(FREQUENCY, 1)));
                        }
                        if (state.method_11654(FREQUENCY) == 1) {
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.2"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_2, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (state.method_11654(FREQUENCY) == 2) {
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.3"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_3, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (state.method_11654(FREQUENCY) == 3) {
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.4"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_4, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (state.method_11654(FREQUENCY) == 4) {
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.1"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_1, class_3419.field_15247, 1.0f, 1.0f);
                        }
                    } else if (world.method_8320(zero).method_26204().equals(ModBlocks.BEDROCK)) {
                        if (world.method_8320(zero).method_11654(FREQUENCY_1) && state.method_11654(FREQUENCY) < 1) {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY,1));
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.1"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_1, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (world.method_8320(zero).method_11654(FREQUENCY_2) && state.method_11654(FREQUENCY) < 2) {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY,2));
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.2"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_2, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (world.method_8320(zero).method_11654(FREQUENCY_3) && state.method_11654(FREQUENCY) < 3) {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY,3));
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.3"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_3, class_3419.field_15247, 1.0f, 1.0f);
                        } else if (world.method_8320(zero).method_11654(FREQUENCY_4) && state.method_11654(FREQUENCY) < 4) {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY,4));
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.4"), true);
                            world.method_8396(null, pos, ModSounds.RADIO_FREQUENCY_4, class_3419.field_15247, 1.0f, 1.0f);
                        } else {
                            world.method_8501(pos, ModBlocks.RADIO_ON.method_34725(state).method_11657(FREQUENCY,0));
                            player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.0"), true);
                        }
                    } else {
                        player.method_7353(class_2561.method_43471("messages.tlotd.radio.frequency.0"), true);
                    }
                }
                world.method_8396(null, pos, ModSounds.BLOCK_RADIO_SWITCH_FREQUENCY, class_3419.field_15245, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    public void updateWood(class_1937 world, class_2338 pos, int type, boolean modded) {
        world.method_8501(pos, world.method_8320(pos).method_11657(WOOD_TYPE, type).method_11657(MODDED, modded));
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_310.method_1551().method_1483().method_4881();
        world.method_8396(null, pos, class_3417.field_15026, class_3419.field_15245, 1.0f, 1.0f);
        super.method_9576(world, pos, state, player);
    }
}