package net.tlotd.block.custom;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.tlotd.block.ModBlocks;
import net.tlotd.block.entity.TeleporterBlockEntity;
import net.tlotd.item.ModItems;
import net.tlotd.sound.ModSounds;
import org.jetbrains.annotations.Nullable;

public class TeleporterBlock extends class_2248 implements class_2343 {

    public static final class_2746 LINKED = class_2746.method_11825("linked");

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(LINKED);
    }

    public TeleporterBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(LINKED, false));
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(LINKED, false);

    }

    public static final class_265 SHAPE = class_259.method_1084(
            class_2248.method_9541(0, 0, 0, 16, 2, 16),
            class_2248.method_9541(1, 2, 1, 15, 4, 15)
    );

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TeleporterBlockEntity(pos, state);
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (state.method_11654(LINKED) && blockEntity instanceof TeleporterBlockEntity teleporter) {
            if (teleporter.destination_y != 2147483647) {
                class_2338 pos2;
                if (teleporter.relative) {
                    pos2 = new class_2338(pos.method_10263()+teleporter.destination_x,pos.method_10264()+teleporter.destination_y,pos.method_10260()+teleporter.destination_z);
                } else {
                    pos2 = new class_2338(teleporter.destination_x,teleporter.destination_y,teleporter.destination_z);
                }
                if (world.method_8320(pos2).method_27852(ModBlocks.TELEPORTER)) {
                    world.method_8501(pos2, ModBlocks.TELEPORTER.method_9564());
                }
            }
        }
        world.method_31595(pos, state);
        world.method_8396(null, pos, class_3417.field_15026, class_3419.field_15245, 1.0f, 1.0f);
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        class_2586 blockEntity = world.method_8321(pos);
        if (entity.method_5715() && state.method_11654(LINKED) && blockEntity instanceof TeleporterBlockEntity teleporter && teleporter.destination_y != 2147483647) {
            class_2338 pos2;
            if (teleporter.relative) {
                pos2 = new class_2338(pos.method_10263()+teleporter.destination_x,pos.method_10264()+teleporter.destination_y,pos.method_10260()+teleporter.destination_z);
            } else {
                pos2 = new class_2338(teleporter.destination_x,teleporter.destination_y,teleporter.destination_z);
            }
            if (teleporter.one_way || world.method_8320(pos2).method_27852(ModBlocks.TELEPORTER)) {
                entity.method_5660(false);
                world.method_8396(null, pos, class_3417.field_14890, class_3419.field_15245, 1.0f, 1.0f);
                if (teleporter.relative) {
                    entity.method_20620(pos.method_10263()+teleporter.destination_x+0.5,pos.method_10264()+teleporter.destination_y+0.25,pos.method_10260()+teleporter.destination_z+0.5);
                } else {
                    entity.method_20620(teleporter.destination_x+0.5,teleporter.destination_y+0.25,teleporter.destination_z+0.5);
                }
                world.method_8396(null, pos2, class_3417.field_14890, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        class_2586 blockEntity = world.method_8321(pos);
        if (!world.field_9236 && stack.method_31574(ModItems.FLASH_DRIVE) && !state.method_11654(LINKED) && blockEntity instanceof TeleporterBlockEntity teleporter) {
            if (!stack.method_7985()) {
                player.method_7353(class_2561.method_43471("block.tlotd.teleporter.no_destination_on_drive"), true);
                world.method_8396(null, pos, class_3417.field_15008, class_3419.field_15245, 1.0f, 1.0f);
            } else if (!state.method_11654(LINKED)) {
                class_2338 pos2 = new class_2338(stack.method_7969().method_10550("destination_x"),stack.method_7969().method_10550("destination_y"),stack.method_7969().method_10550("destination_z"));
                if (pos.equals(pos2)) {
                    player.method_7353(class_2561.method_43471("block.tlotd.teleporter.destination_same"), true);
                    world.method_8396(null, pos, class_3417.field_15008, class_3419.field_15245, 1.0f, 1.0f);
                } else {
                    if (teleporter.one_way || world.method_8320(pos2).method_27852(ModBlocks.TELEPORTER)) {
                        class_2586 blockEntity2 = world.method_8321(pos2);
                        if (!world.method_8320(pos2).method_11654(LINKED) && blockEntity2 instanceof TeleporterBlockEntity teleporter2) {
                            world.method_8501(pos,state.method_11657(LINKED, true));
                            world.method_8501(pos2,state.method_11657(LINKED, true));
                            teleporter.destination_x = stack.method_7969().method_10550("destination_x");
                            teleporter.destination_y = stack.method_7969().method_10550("destination_y");
                            teleporter.destination_z = stack.method_7969().method_10550("destination_z");
                            teleporter.method_5431();
                            teleporter2.destination_x = pos.method_10263();
                            teleporter2.destination_y = pos.method_10264();
                            teleporter2.destination_z = pos.method_10260();
                            teleporter2.method_5431();
                            player.method_7353(class_2561.method_43471("block.tlotd.teleporter.connected"), true);
                            world.method_8396(null, pos, ModSounds.BLOCK_KEYCARD_READER_PLING, class_3419.field_15245, 1.0f, 1.0f);
                        } else {
                            player.method_7353(class_2561.method_43471("block.tlotd.teleporter.destination_in_use"), true);
                            world.method_8396(null, pos, class_3417.field_15008, class_3419.field_15245, 1.0f, 1.0f);
                        }
                    } else {
                        player.method_7353(class_2561.method_43471("block.tlotd.teleporter.none_at_destination"), true);
                        world.method_8396(null, pos, class_3417.field_15008, class_3419.field_15245, 1.0f, 1.0f);
                    }
                }
            } else {
                player.method_7353(class_2561.method_43471("block.tlotd.teleporter.already_in_use"), true);
                world.method_8396(null, pos, class_3417.field_15008, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }
}