package net.tlotd.block.entity;

import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.tlotd.gui.KeycardProgrammerGUIHandler;
import net.tlotd.util.ModTags;
import org.jetbrains.annotations.Nullable;

public class KeycardProgrammerBlockEntity extends class_2586 implements ExtendedScreenHandlerFactory, ImplementedInventory {

    private final class_2371<class_1799> inventory = class_2371.method_10213(3, class_1799.field_8037);

    protected final class_3913 propertyDelegate;
    private int progress = 0;
    private int maxProgress = 72;

    public KeycardProgrammerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.KEYCARD_PROGRAMMER_BLOCK_ENTITY, pos, state);
        this.propertyDelegate = new class_3913() {
            @Override
            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> KeycardProgrammerBlockEntity.this.progress;
                    case 1 -> KeycardProgrammerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            @Override
            public void method_17391(int index, int value) {
                switch (index) {
                    case 0 -> KeycardProgrammerBlockEntity.this.progress = value;
                    case 1 -> KeycardProgrammerBlockEntity.this.maxProgress = value;
                }

            }

            @Override
            public int method_17389() {
                return 2;
            }
        };
    }

    @Override
    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471("block.tlotd.keycard_programmer");
    }

    @Override
    public class_2371<class_1799> getItems() {
        return inventory;
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426(nbt, inventory);
        nbt.method_10569("progress", progress);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429(nbt, inventory);
        progress = nbt.method_10550("progress");
    }

    @Override
    public @Nullable class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new KeycardProgrammerGUIHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if(world.method_8608()) {
            return;
        }
        if(KeycardIsPresent()) {
            progress++;
            method_31663(world, pos, state);
            if(progress >= maxProgress) {
                class_2487 nbt = new class_2487();
                nbt.method_10582("password", this.method_5438(1).toString());
                this.method_5447(2, this.method_5438(0));
                this.method_5447(0, class_1799.field_8037);
                this.method_5438(2).method_7980(nbt);
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            method_31663(world, pos, state);
        }
    }


    private boolean KeycardIsPresent() {
        return this.method_5438(0).method_31573(ModTags.Items.KEYCARDS) && !this.method_5438(1).method_7960() && this.method_5438(2).method_7960();
    }

    private void resetProgress() {
        this.progress = 0;
    }
}
