package net.tlotd.entity;

import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5819;
import net.tlotd.TLOTD;
import net.tlotd.util.ModDamageTypes;
import net.tlotd.util.ModTags;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;

public class ModArmorProtection {
    public static void registerAllowedDamages() {
        final Set<UUID> ignoredDamagePlayers = Collections.newSetFromMap(new WeakHashMap<>());
        AtomicInteger oxygenTick = new AtomicInteger();
        ServerLivingEntityEvents.ALLOW_DAMAGE.register(((livingEntity, damageSource, amount) -> {
            if (!(livingEntity instanceof class_1657 player)) return true;
            if (ignoredDamagePlayers.contains(player.method_5667())) return true;

            if (damageSource.method_48792().comp_1242().contains("radiation") || damageSource.method_48792().comp_1242().contains("radiated")) {
                float radiationProtectionHelmet = 0f;
                float radiationProtection = 0f;
                for (class_1799 armor : player.method_5661()) {
                    if (armor.method_31573(ModTags.Items.RADIATION_PROTECTION_WITHOUT_HELMET) && armor.method_7919()+1 < armor.method_7936()) {
                        radiationProtectionHelmet++;
                        radiationProtection++;
                    } else if (armor.method_31573(ModTags.Items.RADIATION_PROTECTION) && armor.method_7919()+1 < armor.method_7936()) {
                        radiationProtection++;
                    }
                }
                if ((radiationProtectionHelmet >= 3) || (radiationProtection >= 4)) {
                    int maxSlot;
                    if (radiationProtectionHelmet >= 3) { maxSlot = 3; } else { maxSlot = 4; }
                    List<class_1799> armorList = new ArrayList<>();
                    List<Integer> slotIndices = new ArrayList<>();
                    for (int slot = 0; slot < maxSlot; slot++) {
                        class_1799 stack = player.method_31548().field_7548.get(slot);
                        if (!stack.method_7960() && stack.method_7963()) {
                            armorList.add(stack);
                            slotIndices.add(slot);
                        }
                    }
                    class_5819 random = player.method_6051();
                    int index = random.method_43048(armorList.size());
                    class_1799 armorPiece = armorList.get(index);
                    armorPiece.method_7956(1, player, (p) -> {
                    });
                    if (armorPiece.method_7919() >= armorPiece.method_7936()) {
                        player.method_31548().field_7548.set(slotIndices.get(index), class_1799.field_8037);
                    }
                    return false;
                }
            } else if (damageSource.method_48792().comp_1242().contains("hypoxia")) {
                float hypoxiaProtection = 0f;
                for (class_1799 armor : player.method_5661()) {
                    if (armor.method_31573(ModTags.Items.HYPOXIA_PROTECTION)) {
                        hypoxiaProtection++;
                    }
                }
                if (hypoxiaProtection >= 4 && player.method_31548().method_7372(2).method_7969().method_10550("tlotd:oxygen") > 0) {
                    if (oxygenTick.get() >= 20) {
                        oxygenTick.set(0);
                        class_2487 nbtData = new class_2487();
                        nbtData.method_10569("tlotd:oxygen", player.method_31548().method_7372(2).method_7969().method_10550("tlotd:oxygen")-1);
                        player.method_31548().method_7372(2).method_7980(nbtData);
                    } else {
                        oxygenTick.getAndIncrement();
                    }
                    return false;
                }
            } else if (damageSource.method_48792().comp_1242().contains("bullet") || damageSource.method_48792().comp_1242().contains("ammo") ||damageSource.method_48792().comp_1242().contains("round") || damageSource.method_48792().comp_1242().contains("gunfire")) {
                float armorProtection = 0f;
                for (class_1799 armor : player.method_5661()) {
                    if (armor.method_31573(ModTags.Items.BULLET_PROOF_ARMOR_III)) {
                        armorProtection = armorProtection+3f;
                    } else if (armor.method_31573(ModTags.Items.BULLET_PROOF_ARMOR_II)) {
                        armorProtection = armorProtection+2f;
                    } else if (armor.method_31573(ModTags.Items.BULLET_PROOF_ARMOR)) {
                        armorProtection++;
                    }
                }
                if (armorProtection > 0f) {
                    float resistance = ((2f / 3f) * armorProtection);
                    resistance = Math.min(resistance, 0.8f);
                    float reducedAmount = amount * (1f - resistance);
                    if (reducedAmount > 1.5f) {
                        ignoredDamagePlayers.add(player.method_5667());
                        player.method_5643(ModDamageTypes.of(livingEntity.method_37908(), ModDamageTypes.BULLET), reducedAmount);
                        ignoredDamagePlayers.remove(player.method_5667());
                    }
                    return false;
                }
            }
            return true;
        }));

        TLOTD.LOGGER.info("Registering Special Armor Protection for " + TLOTD.MOD_ID);
    }
}
