package net.tlotd.entity.ai;

import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1366;
import net.tlotd.entity.custom.TRexEntity;

public class TRexAttackGoal extends class_1366 {

    private final TRexEntity entity;
    private int attackDelay = 10;
    private int ticksUntilNextAttack = 0;
    private boolean shouldCountTowardsNextAttack = false;

    public TRexAttackGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
        super(mob, speed, pauseWhenMobIdle);
        entity = ((TRexEntity) mob);
    }

    @Override
    public void method_6269() {
        super.method_6269();
        attackDelay = 10;
        ticksUntilNextAttack = 0;
    }

    @Override
    protected void method_6288(class_1309 target, double squaredDistance) {
        if (isEnemyWithinAttackDistance(target)) {
            shouldCountTowardsNextAttack = true;

            if(isTimeToStartAttackAnimation()) {
                entity.method_19540(true);
            }

            if(isTimeToAttack()) {
                this.field_6503.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
                performAttack(target);
            }
        } else {
            resetAttackCooldown();
            shouldCountTowardsNextAttack = false;
            entity.method_19540(false);
            entity.attackAnimationTimeout = 0;
        }
    }

    private boolean isEnemyWithinAttackDistance(class_1309 pEnemy) {
        return this.entity.method_5739(pEnemy) <= 6f;
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.method_38847(attackDelay * 2);
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= attackDelay;
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected void performAttack(class_1309 pEnemy) {
        this.resetAttackCooldown();
        this.field_6503.method_6104(class_1268.field_5808);
        this.field_6503.method_6121(pEnemy);
    }
    
    @Override
    public void method_6268() {
        super.method_6268();
        if(shouldCountTowardsNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    @Override
    public void method_6270() {
        entity.method_19540(false);
        super.method_6270();
    }
}
