package net.tlotd.entity.client;

import com.google.common.collect.Maps;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import net.tlotd.TLOTD;
import net.tlotd.entity.client.variant.TRexVariant;
import net.tlotd.entity.custom.TRexEntity;

import java.util.Map;

public class TRexRenderer extends class_927<TRexEntity, TRexModel<TRexEntity>> {

    public static final Map<TRexVariant, class_2960> LOCATION_BY_VARIANT =
            class_156.method_654(Maps.newEnumMap(TRexVariant.class), (map) -> {
                map.put(TRexVariant.BROWN,
                        new class_2960(TLOTD.MOD_ID, "textures/block/t-rex/brown.png"));
                map.put(TRexVariant.GREEN,
                        new class_2960(TLOTD.MOD_ID, "textures/block/t-rex/green.png"));
                map.put(TRexVariant.GRAY,
                        new class_2960(TLOTD.MOD_ID, "textures/block/t-rex/gray.png"));
                map.put(TRexVariant.SCULK,
                        new class_2960(TLOTD.MOD_ID, "textures/block/t-rex/sculk.png"));
                map.put(TRexVariant.INFECTED,
                        new class_2960(TLOTD.MOD_ID, "textures/block/t-rex/infected.png"));
                map.put(TRexVariant.SICKENED,
                        new class_2960(TLOTD.MOD_ID, "textures/block/t-rex/sickened.png"));
            });

    public TRexRenderer(class_5617.class_5618 context) {
        super(context, new TRexModel<>(context.method_32167(ModModelLayers.TREX)), 2);
    }

    @Override
    public class_2960 getTexture(TRexEntity entity) {
        return LOCATION_BY_VARIANT.get(entity.method_47827());
    }

    @Override
    public void render(TRexEntity mobEntity, float f, float g, class_4587 matrixStack,
                       class_4597 vertexConsumerProvider, int i) {
        if(mobEntity.method_6109()) {
            matrixStack.method_22905(0.5f, 0.5f, 0.5f);
        } else {
            matrixStack.method_22905(1.0f, 1.0f, 1.0f);
        }

        super.method_4072(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }
}
