package net.tlotd.entity.custom;

import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1430;
import net.minecraft.class_1452;
import net.minecraft.class_1472;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4760;
import net.minecraft.class_4836;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5419;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6053;
import net.minecraft.class_7094;
import net.minecraft.class_7988;
import net.minecraft.entity.*;
import net.minecraft.entity.ai.goal.*;
import net.minecraft.entity.passive.*;
import net.tlotd.entity.ModEntities;
import net.tlotd.entity.ai.TRexAttackGoal;
import net.tlotd.entity.client.variant.TRexVariant;
import net.tlotd.sound.ModSounds;
import org.jetbrains.annotations.Nullable;

public class TRexEntity extends class_1429 implements class_7988<TRexVariant> {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(TRexEntity.class, class_2943.field_13327);
    public static final String VARIANT_KEY = "Variant";

    private static final class_2940<Boolean> ATTACKING = class_2945.method_12791(TRexEntity.class, class_2943.field_13323);

    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;

    public final class_7094 attackAnimationState = new class_7094();
    public int attackAnimationTimeout = 0;

    public void setVariant(TRexVariant variant) {
        this.field_6011.method_12778(VARIANT, variant.getId());
    }

    public TRexVariant method_47827() {
        return TRexVariant.byId(this.field_6011.method_12789(VARIANT));
    }

    public static boolean shouldBabyBeDifferent(class_5819 random) {
        return random.method_43048(1200) == 0;
    }
    
    public static class TRexData
            extends class_1296.class_4697 {
        public final TRexVariant[] variants;

        public TRexData(TRexVariant... variants) {
            super(false);
            this.variants = variants;
        }

        public TRexVariant getRandomVariant(class_5819 random) {
            return this.variants[random.method_43048(this.variants.length)];
        }
    }
    
    public TRexEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        
        if (this.method_6510() & attackAnimationTimeout <= 0) {
            attackAnimationTimeout = 10;
            attackAnimationState.method_41322(this.field_6012);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.method_6510()) {
            attackAnimationState.method_41325();
        }
    }

    @Override
    protected void method_48565(float posDelta) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if(this.method_37908().method_8608()) {
            setupAnimationStates();
        }
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new TRexAttackGoal(this, 1, true));
        this.field_6201.method_6277(2, new class_1341(this, 1.0F, class_1496.class));
        this.field_6201.method_6277(4, new class_1353(this, 1.0F));
        this.field_6201.method_6277(6, new class_1394(this, 0.7));
        this.field_6201.method_6277(7, new class_1361(this, class_1657.class, 6.0F));
        this.field_6201.method_6277(8, new class_1376(this));

        this.field_6185.method_6277(0, new class_1399(this));
        this.field_6185.method_6277(1, new class_1400<>(this, class_6053.class, false));
        this.field_6185.method_6277(2, new class_1400<>(this, class_1472.class, false));
        this.field_6185.method_6277(3, new class_1400<>(this, class_1452.class, false));
        this.field_6185.method_6277(4, new class_1400<>(this, class_1430.class, false));
        this.field_6185.method_6277(5, new class_1400<>(this, class_1496.class, false));
        this.field_6185.method_6277(6, new class_1400<>(this, class_4760.class, false));
        this.field_6185.method_6277(7, new class_1400<>(this, class_4836.class, false));
        this.field_6185.method_6277(8, new class_1400<>(this, class_5419.class, false));
        this.field_6185.method_6277(9, new class_1400<>(this, class_1646.class, false));
        this.field_6185.method_6277(10, new class_1400<>(this, class_1657.class, false));
    }

    public static class_5132.class_5133 createTRexAttributes() {
        return class_1308.method_26828()
                .method_26868(class_5134.field_23716, 100)
                .method_26868(class_5134.field_23724, 10)
                .method_26868(class_5134.field_23719, 0.6)
                .method_26868(class_5134.field_23717, 16)
                .method_26868(class_5134.field_23721, 16)
                .method_26868(class_5134.field_23722, 1);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8046);
    }

    @Override
    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        TRexEntity tRexEntity = ModEntities.TREX.method_5883(world);
        if (tRexEntity != null) {
            TRexVariant variant = shouldBabyBeDifferent(this.field_5974) ? TRexVariant.getRandomUnnatural(this.field_5974) : (this.field_5974.method_43056() ? this.method_47827() : ((TRexEntity)entity).method_47827());
            tRexEntity.setVariant(variant);
            tRexEntity.method_5971();
        }
        return tRexEntity;
    }

    @Override
    protected @Nullable class_3414 method_5994() {
        return ModSounds.ENTITY_TREX_IDLE;
    }

    @Override
    protected @Nullable class_3414 method_6011(class_1282 source) {
        return ModSounds.ENTITY_TREX_HURT;
    }

    @Override
    protected @Nullable class_3414 method_6002() {
        return ModSounds.ENTITY_TREX_DEATH;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569(VARIANT_KEY, this.method_47827().getId());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(TRexVariant.byId(nbt.method_10550(VARIANT_KEY)));
    }

    public void method_19540(boolean attacking) {
        this.field_6011.method_12778(ATTACKING, attacking);
    }

    public boolean method_6510() {
        return this.field_6011.method_12789(ATTACKING);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, 0);
        this.field_6011.method_12784(ATTACKING, false);
    }

    /* VARIANTS */
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT =
            class_2945.method_12791(TRexEntity.class, class_2943.field_13327);

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        boolean bl = false;
        if (spawnReason == class_3730.field_16473) {
            return entityData;
        }
        class_5819 random = world.method_8409();
        if (entityData instanceof TRexData) {
            if (((TRexData)entityData).method_22432() >= 2) {
                bl = true;
            }
        } else {
            entityData = new TRexData(TRexVariant.getRandomNatural(random), TRexVariant.getRandomNatural(random));
        }
        this.setVariant(((TRexData)entityData).getRandomVariant(random));
        if (bl) {
            this.method_5614(-24000);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }
}
