package net.tlotd.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.minecraft.class_1661;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_757;
import net.tlotd.TLOTD;
import net.tlotd.gui.renderer.FluidStackRenderer;
import net.tlotd.util.FluidStack;
import net.tlotd.util.MouseUtil;

public class WitchingTableGUI extends class_465<WitchingTableGUIHandler> {
    private static final class_2960 TEXTURE = new class_2960(TLOTD.MOD_ID, "textures/gui/witching_table.png");

    private FluidStackRenderer fluidStackRenderer;

    public WitchingTableGUI(WitchingTableGUIHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, class_2561.method_43471("gui.tlotd.witching"));
    }

    @Override
    protected void method_25426() {
        assignFluidStackRenderer();
        super.method_25426();
        field_25268 = 7;
        field_25270 = 74;
    }

    private void assignFluidStackRenderer() {
        fluidStackRenderer = new FluidStackRenderer(FluidConstants.BUCKET * 8,
                true, 15, 61);
    }

    @Override
    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        int x = (field_22789 - field_2792) / 2;
        int y = (field_22790 - field_2779) / 2;

        renderFluidTooltip(context, mouseX, mouseY, x, y, field_2797.fluidStack, 8, 15, fluidStackRenderer);
    }

    private void renderFluidTooltip(class_332 context, int mouseX, int mouseY, int x, int y,
                                    FluidStack fluidStack, int offsetX, int offsetY, FluidStackRenderer renderer) {
        if(isMouseAboveArea(mouseX, mouseY, x, y, offsetX, offsetY, renderer)) {
            method_47415(renderer.getTooltip(fluidStack, class_1836.class_1837.field_41070));
        }
    }

    @Override
    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        RenderSystem.setShaderTexture(0, TEXTURE);
        int x = (field_22789 - field_2792) / 2;
        int y = (field_22790 - field_2779) / 2;

        context.method_25302(TEXTURE, x, y, 0, 0, field_2792, field_2779);

        renderProgressArrow(context, x, y);

        fluidStackRenderer.drawFluid(context, field_2797.fluidStack, x+8, y+15, 16, 56,
                FluidConstants.BUCKET * 8);
    }

    private void renderProgressArrow(class_332 context, int x, int y) {
        if(field_2797.isCrafting()) {
            context.method_25302(TEXTURE,x+106,y+20,176,0, field_2797.getScaledProgress(), 44);
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        method_2380(context,mouseX, mouseY);
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, FluidStackRenderer renderer) {
        return MouseUtil.isMouseOver(pMouseX, pMouseY, x + offsetX, y + offsetY, renderer.getWidth(), renderer.getHeight());
    }
}
