package net.tlotd.gui.renderer;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3612;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import net.minecraft.client.render.*;
import net.tlotd.util.FluidStack;
import org.joml.Matrix4f;

import java.text.NumberFormat;

@Environment(EnvType.CLIENT)
public class FluidStackRenderer implements IIngredientRenderer<FluidStack> {
    private static final NumberFormat nf = NumberFormat.getIntegerInstance();
    public final long capacityMb;
    private final TooltipMode tooltipMode;
    private final int width;
    private final int height;

    public void drawSprite(class_332 context, int x, int y, int z, int width, int height, class_1058 sprite) {
        this.drawTexturedQuad(context, sprite.method_45852(), x, x + width, y, y + height, z, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575());
    }

    void drawTexturedQuad(class_332 context, class_2960 texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2) {
        RenderSystem.setShaderTexture(0, texture);
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)z).method_22913(u1, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)z).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)z).method_22913(u2, v1).method_1344();
        class_286.method_43433(bufferBuilder.method_1326());
    }

    enum TooltipMode {
        SHOW_AMOUNT,
        SHOW_AMOUNT_AND_CAPACITY,
        ITEM_LIST
    }

    public FluidStackRenderer(long capacityMb, boolean showCapacity, int width, int height) {
        this(capacityMb, showCapacity ? TooltipMode.SHOW_AMOUNT_AND_CAPACITY : TooltipMode.SHOW_AMOUNT, width, height);
    }

    @SuppressWarnings("DeprecatedIsStillUsed")
    @Deprecated
    public FluidStackRenderer(int capacityMb, boolean showCapacity, int width, int height) {
        this(capacityMb, showCapacity ? TooltipMode.SHOW_AMOUNT_AND_CAPACITY : TooltipMode.SHOW_AMOUNT, width, height);
    }

    private FluidStackRenderer(long capacityMb, TooltipMode tooltipMode, int width, int height) {
        Preconditions.checkArgument(capacityMb > 0, "capacity must be > 0");
        Preconditions.checkArgument(width > 0, "width must be > 0");
        Preconditions.checkArgument(height > 0, "height must be > 0");
        this.capacityMb = capacityMb;
        this.tooltipMode = tooltipMode;
        this.width = width;
        this.height = height;
    }

    /*
    * METHOD FROM https://github.com/TechReborn/TechReborn
    * UNDER MIT LICENSE: https://github.com/TechReborn/TechReborn/blob/1.19/LICENSE.md
    */
    public void drawFluid(class_332 context, FluidStack fluid, int x, int y, int width, int height, long maxCapacity) {
        if (fluid.getFluidVariant().getFluid() == class_3612.field_15906) {
            return;
        }
        RenderSystem.setShaderTexture(0, class_1723.field_21668);
        y += height;
        final class_1058 sprite = FluidVariantRendering.getSprite(fluid.getFluidVariant());
        int color = FluidVariantRendering.getColor(fluid.getFluidVariant());

        final int drawHeight = (int) (fluid.getAmount() / (maxCapacity * 1F) * height);
        final int iconHeight = sprite.method_45851().method_45815();
        int offsetHeight = drawHeight;

        RenderSystem.setShaderColor((color >> 16 & 255) / 255.0F, (float) (color >> 8 & 255) / 255.0F, (float) (color & 255) / 255.0F, 1F);

        int iteration = 0;
        while (offsetHeight != 0) {
            final int curHeight = offsetHeight < iconHeight ? offsetHeight : iconHeight;
            this.drawSprite(context, x, y - offsetHeight, 0, width, curHeight, sprite);
            offsetHeight -= curHeight;
            iteration++;
            if (iteration > 50) {
                break;
            }
        }
        RenderSystem.setShaderColor(1F, 1F, 1F, 1F);

        RenderSystem.setShaderTexture(0, FluidRenderHandlerRegistry.INSTANCE.get(fluid.getFluidVariant().getFluid())
                .getFluidSprites(class_310.method_1551().field_1687, null, fluid.getFluidVariant().getFluid().method_15785())[0].method_45852());
    }

    @Override
    public class_2561 getTooltip(FluidStack fluidStack, class_1836 tooltipFlag) {
        long amount = fluidStack.getAmount();
        class_2561 tooltip = class_2561.method_43469("gui.tlotd.tooltip.liquid_amount_with_capacity", class_2561.method_43471("block." + class_7923.field_41173.method_10221(fluidStack.fluidVariant.getFluid()).method_42094()), nf.format(FluidStack.convertDropletsToMb(amount)), nf.format(FluidStack.convertDropletsToMb(capacityMb))).method_27696(class_2583.field_24360.method_10977(class_124.field_1080));
        return tooltip;
    }

    @Override
    public int getWidth() {
        return width;
    }

    @Override
    public int getHeight() {
        return height;
    }
}