package net.tlotd.item;

import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.tlotd.TLOTD;

import java.util.function.Supplier;

public enum ModArmorMaterial implements class_1741 {
    HELIORITE("heliorite", 40, new int[] { 4, 9, 7, 4}, 18, class_3417.field_21866, 3.5f, 0.15f, () -> class_1856.method_8091(ModItems.HELIORITE_INGOT)),
    ENDURIUM("endurium", 43, new int[] { 4, 9, 7, 4}, 18, class_3417.field_21866, 3.5f, 0.15f, () -> class_1856.method_8091(ModItems.ENDURIUM_INGOT)),
    PALLADIUM("palladium", 42, new int[] { 5, 10, 8, 5}, 21, class_3417.field_21866, 4f, 0.2f, () -> class_1856.method_8091(ModItems.PALLADIUM_INGOT)),
    JURASSOLINE("jurassoline", 45, new int[] { 5, 10, 8, 5}, 21, class_3417.field_21866, 4f, 0.2f, () -> class_1856.method_8091(ModItems.JURASSOLINE_INGOT)),
    CINNABAR("cinnabar", 48, new int[] { 5, 10, 8, 5}, 21, class_3417.field_21866, 4.5f, 0.25f, () -> class_1856.method_8091(ModItems.CINNABAR_INGOT)),
    NEBULAR("nebular", 50, new int[] { 5, 10, 8, 5}, 21, class_3417.field_21866, 4.5f, 0.25f, () -> class_1856.method_8091(ModItems.NEBULAR_INGOT)),
    MITHRIL("mithril", 60, new int[] { 6, 12, 10, 6}, 25, class_3417.field_21866, 5f, 0.3f, () -> class_1856.method_8091(ModItems.MITHRIL_INGOT)),

    MONOCLE("victorian", 20, new int[] { 0, 0, 0, 0}, 0, class_3417.field_14883, 0f, 0f, () -> class_1856.method_8091(class_1802.field_8141)),
    VICTORIAN("victorian", 20, new int[] { 0, 3, 2, 1}, 0, class_3417.field_14581, 0f, 0f, () -> class_1856.method_8091(class_1802.field_8745)),

    PICKELHAUBE("imperial_german_uniform", 20, new int[] { 4, 0, 0, 0}, 0, class_3417.field_21866, 3f, 0f, () -> class_1856.method_8091(ModItems.STEEL_INGOT)),
    IMPERIAL_GERMAN_UNIFORM("imperial_german_uniform", 20, new int[] { 0, 3, 2, 1}, 0, class_3417.field_14581, 0f, 0f, () -> class_1856.method_8091(class_1802.field_8745)),

    ASTRONAUT("space_suit", 20, new int[] { 1, 0, 0, 0}, 0, class_3417.field_14883, 0f, 0f, () -> class_1856.method_8091(class_1802.field_27019)),
    SPACE_SUIT("space_suit", 20, new int[] { 0, 3, 2, 1}, 0, class_3417.field_14581, 0f, 0f, () -> class_1856.method_8091(class_1802.field_8745)),

    CTHONAUT("depth_suit", 20, new int[] { 1, 0, 0, 0}, 0, class_3417.field_14883, 0f, 0f, () -> class_1856.method_8091(class_1802.field_27019)),
    DEPTH_SUIT("depth_suit", 20, new int[] { 0, 3, 2, 1}, 0, class_3417.field_14581, 0f, 0f, () -> class_1856.method_8091(class_1802.field_8745)),

    SCIENTIST("hev_suit", 20, new int[] { 0, 0, 0, 0}, 0, class_3417.field_14883, 0f, 0f, () -> class_1856.method_8091(class_1802.field_8141)),
    HEV_SUIT("hev_suit", 30, new int[] { 0, 6, 4, 2}, 0, class_3417.field_21866, 5f, 0.5f, () -> class_1856.method_8091(ModItems.XEN_CRYSTAL)),

    EMPEROR("emperor", 50, new int[] { 4, 0, 0, 0}, 25, class_3417.field_14761, 3f, 0f, () -> class_1856.method_8091(class_1802.field_8695))
    ;

    private final String name;
    private final int durabilityMultiplier;
    private final int[] protectionAmounts;
    private final int enchantability;
    private final class_3414 equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<class_1856> repairIngredient;

    private static final int[] BASE_DURABILITY = {11, 16, 15, 13 };

    ModArmorMaterial(String name, int durabilityMultiplier, int[] protectionAmounts, int enchantability, class_3414 equipSound, float toughness, float knockbackResistance, Supplier<class_1856> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionAmounts = protectionAmounts;
        this.enchantability = enchantability;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    @Override
    public int method_48402(class_1738.class_8051 type) {
        return BASE_DURABILITY[type.ordinal()] * this.durabilityMultiplier;
    }

    @Override
    public int method_48403(class_1738.class_8051 type) {
        return protectionAmounts[type.ordinal()];
    }

    @Override
    public int method_7699() {
        return this.enchantability;
    }

    @Override
    public class_3414 method_7698() {
        return this.equipSound;
    }

    @Override
    public class_1856 method_7695() {
        return this.repairIngredient.get();
    }

    @Override
    public String method_7694() {
        return TLOTD.MOD_ID + ":" + this.name;
    }

    @Override
    public float method_7700() {
        return this.toughness;
    }

    @Override
    public float method_24355() {
        return this.knockbackResistance;
    }
}