package net.tlotd.item.custom;

import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.tlotd.sound.ModSounds;
import net.tlotd.util.ModTags;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class OxygenTankItem extends class_1792 {
    public OxygenTankItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        String oxygen = "0.0%";
        Float oxygenPercentage;
        if(stack.method_7985()) {
            oxygenPercentage = stack.method_7969().method_10550("tlotd:oxygen")/10.0F;
            oxygen = String.join("",String.valueOf(oxygenPercentage), "%");
        }
        tooltip.add(class_2561.method_43469("item.tlotd.oxygen_level.tooltip", oxygen).method_27692(class_124.field_1080));
    }

    public float getProgress(class_1799 stack) {
        if (!stack.method_7985()) {
            return 1000f;
        } else {
            return 1000f - stack.method_7969().method_10550("tlotd:oxygen");
        }
    }

    @Override
    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - getProgress(stack) * 13.0f / 1000f);
    }

    @Override
    public int method_31571(class_1799 stack) {
        return 0x9fc5e8;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (!world.method_8608()) {
            class_1799 chest = user.method_31548().method_7372(2);
            if (itemStack.method_7985() && itemStack.method_7969().method_10550("tlotd:oxygen") > 0 && chest.method_31573(ModTags.Items.OXYGEN_CHARGABLE)) {
                int chestOxygen = 0;
                if (chest.method_7969() != null) {
                    chestOxygen = chest.method_7969().method_10550("tlotd:oxygen");
                }
                int itemOxygen = itemStack.method_7969().method_10550("tlotd:oxygen");
                if (chestOxygen + itemOxygen <= 1000) {
                    chestOxygen = chestOxygen + itemOxygen;
                    itemOxygen = 0;
                } else {
                    itemOxygen = itemOxygen - (1000 - chestOxygen);
                    chestOxygen = 1000;
                }
                class_2487 itemNbtData = new class_2487();
                itemNbtData.method_10569("tlotd:oxygen", itemOxygen);
                itemStack.method_7980(itemNbtData);
                class_2487 chestNbtData = new class_2487();
                chestNbtData.method_10569("tlotd:oxygen", chestOxygen);
                chest.method_7980(chestNbtData);
                world.method_8396(null, user.method_24515(), class_3417.field_14726, class_3419.field_15248, 1.0f, 1.0f);
                return class_1271.method_22427(itemStack);
            }
        }
        return class_1271.method_22430(itemStack);
    }
}