package net.tlotd.networking.packet;

import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.tlotd.block.entity.WitchingTableBlockEntity;
import net.tlotd.gui.WitchingTableGUIHandler;
import net.tlotd.util.FluidStack;

public class FluidSyncS2CPacket {
    public static void receive(class_310 client, class_634 handler,
                               class_2540 buf, PacketSender responseSender) {
        FluidVariant variant = FluidVariant.fromPacket(buf);
        long fluidLevel = buf.readLong();
        class_2338 position = buf.method_10811();

        if(client.field_1687.method_8321(position) instanceof WitchingTableBlockEntity blockEntity) {
            blockEntity.setFluidLevel(variant, fluidLevel);

            if(client.field_1724.field_7512 instanceof WitchingTableGUIHandler screenHandler &&
                    screenHandler.blockEntity.method_11016().equals(position)) {
                blockEntity.setFluidLevel(variant, fluidLevel);
                screenHandler.setFluid(new FluidStack(variant, fluidLevel));
            }
        }
    }
}
